/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.entity;

import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.snowyspirit.configs.CommonConfigs;
import net.mehvahdjukaar.snowyspirit.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public enum GroundStatus {
    ON_SNOW,
    ON_SNOW_LAYER,
    ON_LAND,
    IN_WATER,
    IN_AIR;


    public boolean touchingGround() {
        return this != IN_AIR && this != IN_WATER;
    }

    public boolean onSnow() {
        return this == ON_SNOW || this == ON_SNOW_LAYER;
    }

    private Pair<GroundStatus, Float> withFriction(float friction) {
        return Pair.of((Object)((Object)this), (Object)Float.valueOf(friction));
    }

    public static Pair<GroundStatus, Float> computeFriction(Entity sled) {
        if (sled.m_20069_()) {
            return IN_WATER.withFriction(1.0f);
        }
        Level level = sled.m_9236_();
        AABB aabb = sled.m_20191_();
        AABB aabb1 = new AABB(aabb.f_82288_, aabb.f_82289_ - 0.001, aabb.f_82290_, aabb.f_82291_, aabb.f_82289_, aabb.f_82293_);
        int i = Mth.m_14107_((double)aabb1.f_82288_) - 1;
        int j = Mth.m_14165_((double)aabb1.f_82291_) + 1;
        int k = Mth.m_14107_((double)aabb1.f_82289_) - 1;
        int l = Mth.m_14165_((double)aabb1.f_82292_) + 1;
        int i1 = Mth.m_14107_((double)aabb1.f_82290_) - 1;
        int j1 = Mth.m_14165_((double)aabb1.f_82293_) + 1;
        VoxelShape voxelshape = Shapes.m_83064_((AABB)aabb1);
        float cumulativeFriction = 0.0f;
        int blockCount = 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        boolean onSnow = false;
        boolean onSnowLayer = false;
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    mutable.m_122178_(l1, k2, i2);
                    double snowFriction = CommonConfigs.SNOW_FRICTION.get();
                    BlockState above = level.m_8055_(mutable.m_7494_());
                    if (above.m_60734_() instanceof SnowLayerBlock || above.m_61138_((Property)SnowLayerBlock.f_56581_) && above.m_204336_(ModTags.SLED_SNOW)) {
                        onSnowLayer = true;
                        cumulativeFriction = (float)((double)cumulativeFriction + snowFriction);
                        ++blockCount;
                        continue;
                    }
                    BlockState blockstate = level.m_8055_((BlockPos)mutable);
                    if (blockstate.m_204336_(ModTags.SLED_SNOW)) {
                        onSnow = true;
                        cumulativeFriction = (float)((double)cumulativeFriction + snowFriction);
                        ++blockCount;
                        continue;
                    }
                    if (blockstate.m_204336_(ModTags.SLED_SAND)) {
                        cumulativeFriction = (float)((double)cumulativeFriction + CommonConfigs.SAND_FRICTION.get());
                        ++blockCount;
                        continue;
                    }
                    if (!Shapes.m_83157_((VoxelShape)blockstate.m_60812_((BlockGetter)level, (BlockPos)mutable).m_83216_((double)l1, (double)k2, (double)i2), (VoxelShape)voxelshape, (BooleanOp)BooleanOp.f_82689_)) continue;
                    float fr = ForgeHelper.getFriction((BlockState)blockstate, (LevelReader)level, (BlockPos)mutable, (Entity)sled);
                    if ((double)fr > 0.9) {
                        fr = (float)((double)fr * CommonConfigs.ICE_FRICTION_MULTIPLIER.get());
                    }
                    cumulativeFriction += fr;
                    ++blockCount;
                }
            }
        }
        if (cumulativeFriction <= 0.0f) {
            return IN_AIR.withFriction(0.0f);
        }
        float friction = cumulativeFriction / (float)blockCount;
        if (sled.m_20096_()) {
            double slopeFriction = Mth.m_14036_((float)sled.m_146909_(), (float)-45.0f, (float)45.0f) / 45.0f;
            friction = (float)((double)friction + CommonConfigs.SLOPE_FRICTION_INCREASE.get() * slopeFriction);
        }
        float landFriction = Math.min(0.9995f, friction);
        if (onSnowLayer) {
            return ON_SNOW_LAYER.withFriction(landFriction);
        }
        if (onSnow) {
            return ON_SNOW.withFriction(landFriction);
        }
        return ON_LAND.withFriction(landFriction);
    }
}

