/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.client.tooltip;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.QuarkClient;
import org.violetmoon.quark.base.client.handler.ClientUtil;
import org.violetmoon.quark.content.client.hax.PseudoAccessorItemStack;
import org.violetmoon.quark.content.client.module.ImprovedTooltipsModule;
import org.violetmoon.quark.content.client.resources.AttributeDisplayType;
import org.violetmoon.quark.content.client.resources.AttributeIconEntry;
import org.violetmoon.quark.content.client.resources.AttributeSlot;
import org.violetmoon.zeta.client.event.play.ZGatherTooltipComponents;
import org.violetmoon.zeta.util.ItemNBTHelper;

public class AttributeTooltips {
    public static final ResourceLocation TEXTURE_UPGRADE = new ResourceLocation("quark", "textures/attribute/upgrade.png");
    public static final ResourceLocation TEXTURE_DOWNGRADE = new ResourceLocation("quark", "textures/attribute/downgrade.png");
    private static final Map<ResourceLocation, AttributeIconEntry> attributes = new HashMap<ResourceLocation, AttributeIconEntry>();

    public static void receiveAttributes(Map<String, AttributeIconEntry> map) {
        attributes.clear();
        for (Map.Entry<String, AttributeIconEntry> entry : map.entrySet()) {
            attributes.put(new ResourceLocation(entry.getKey()), entry.getValue());
        }
    }

    @Nullable
    private static AttributeIconEntry getIconForAttribute(Attribute attribute) {
        ResourceLocation loc = BuiltInRegistries.f_256951_.m_7981_((Object)attribute);
        if (loc != null) {
            return attributes.get(loc);
        }
        return null;
    }

    private static MutableComponent format(Attribute attribute, double value, AttributeDisplayType displayType) {
        switch (displayType) {
            case DIFFERENCE: {
                return Component.m_237113_((String)((value > 0.0 ? "+" : "") + ItemStack.f_41584_.format(value))).m_130940_(value < 0.0 ? ChatFormatting.RED : ChatFormatting.WHITE);
            }
            case PERCENTAGE: {
                return Component.m_237113_((String)((value > 0.0 ? "+" : "") + ItemStack.f_41584_.format(value * 100.0) + "%")).m_130940_(value < 0.0 ? ChatFormatting.RED : ChatFormatting.WHITE);
            }
            case MULTIPLIER: {
                AttributeSupplier supplier = DefaultAttributes.m_22297_((EntityType)EntityType.f_20532_);
                double scaledValue = value / supplier.m_22253_(attribute);
                return Component.m_237113_((String)(ItemStack.f_41584_.format(scaledValue) + "x")).m_130940_(scaledValue < 1.0 ? ChatFormatting.RED : ChatFormatting.WHITE);
            }
        }
        return Component.m_237113_((String)ItemStack.f_41584_.format(value)).m_130940_(value < 0.0 ? ChatFormatting.RED : ChatFormatting.WHITE);
    }

    public static void makeTooltip(ZGatherTooltipComponents event) {
        ItemStack stack = event.getItemStack();
        if (!Screen.m_96638_()) {
            List tooltipRaw = event.getTooltipElements();
            HashMap attributeTooltips = Maps.newHashMap();
            boolean onlyInvalid = true;
            Multimap<Attribute, AttributeModifier> baseCheck = null;
            boolean allAreSame = true;
            for (AttributeSlot slot : AttributeSlot.values()) {
                if (!AttributeTooltips.canShowAttributes(stack, slot)) continue;
                Multimap<Attribute, AttributeModifier> slotAttributes = AttributeTooltips.getModifiers(stack, slot);
                if (baseCheck == null) {
                    baseCheck = slotAttributes;
                } else if (slot.hasCanonicalSlot() && allAreSame && !slotAttributes.equals(baseCheck)) {
                    allAreSame = false;
                }
                if (!slotAttributes.isEmpty() && !slot.hasCanonicalSlot()) {
                    allAreSame = false;
                }
                onlyInvalid = AttributeTooltips.extractAttributeValues(stack, attributeTooltips, onlyInvalid, slot, slotAttributes);
            }
            AttributeSlot primarySlot = AttributeTooltips.getPrimarySlot(stack);
            int i = 1;
            for (AttributeSlot slot : AttributeSlot.values()) {
                if (!attributeTooltips.containsKey((Object)slot)) continue;
                int tooltipSlot = slot == primarySlot ? 1 : i;
                tooltipRaw.add(tooltipSlot, Either.right((Object)new AttributeComponent(stack, slot)));
                ++i;
                if (allAreSame) break;
            }
        }
    }

    private static Multimap<Attribute, AttributeModifier> getModifiersOnEquipped(Player player, ItemStack stack, Multimap<Attribute, AttributeModifier> attributes, AttributeSlot slot) {
        ItemStack equipped;
        if (ImprovedTooltipsModule.showUpgradeStatus && slot.hasCanonicalSlot() && !(equipped = player.m_6844_(slot.getCanonicalSlot())).equals(stack) && !equipped.m_41619_()) {
            equipped.m_41651_(player, (TooltipFlag)TooltipFlag.Default.f_256752_);
            return AttributeTooltips.getModifiers(equipped, slot);
        }
        return ImmutableMultimap.of();
    }

    private static Multimap<Attribute, AttributeModifier> getModifiers(ItemStack stack, AttributeSlot slot) {
        if (!Quark.ZETA.isProduction && !(stack instanceof PseudoAccessorItemStack)) {
            return ImmutableMultimap.of();
        }
        Map<AttributeSlot, Multimap<Attribute, AttributeModifier>> capturedModifiers = ((PseudoAccessorItemStack)stack).quark$getCapturedAttributes();
        if (capturedModifiers.containsKey((Object)slot)) {
            Multimap<Attribute, AttributeModifier> map = capturedModifiers.get((Object)slot);
            if (slot == AttributeSlot.MAINHAND) {
                if (!map.containsKey((Object)Attributes.f_22281_) && (map.containsKey((Object)Attributes.f_22283_) || EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_) > 0.0f)) {
                    map.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(Util.f_137441_, "-", 0.0, AttributeModifier.Operation.ADDITION));
                }
                if (!map.containsKey((Object)Attributes.f_22283_) && map.containsKey((Object)Attributes.f_22281_)) {
                    map.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(Util.f_137441_, "-", 0.0, AttributeModifier.Operation.ADDITION));
                }
                if (!map.containsKey((Object)Attributes.f_22282_) && Quark.ZETA.itemExtensions.get(stack).getEnchantmentLevelZeta(stack, Enchantments.f_44980_) > 0) {
                    map.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(Util.f_137441_, "-", 0.0, AttributeModifier.Operation.ADDITION));
                }
            }
            return map;
        }
        return ImmutableMultimap.of();
    }

    private static boolean extractAttributeValues(ItemStack stack, Map<AttributeSlot, MutableComponent> attributeTooltips, boolean onlyInvalid, AttributeSlot slot, Multimap<Attribute, AttributeModifier> slotAttributes) {
        boolean anyInvalid = false;
        for (Attribute attr : slotAttributes.keySet()) {
            AttributeIconEntry entry = AttributeTooltips.getIconForAttribute(attr);
            if (entry != null) {
                onlyInvalid = false;
                Minecraft mc = Minecraft.m_91087_();
                double attributeValue = AttributeTooltips.getAttribute((Player)mc.f_91074_, slot, stack, slotAttributes, attr);
                if (attributeValue == 0.0) continue;
                if (!attributeTooltips.containsKey((Object)slot)) {
                    attributeTooltips.put(slot, Component.m_237113_((String)""));
                }
                attributeTooltips.get((Object)slot).m_130946_(AttributeTooltips.format(attr, attributeValue, entry.displayTypes().get((Object)slot)).getString()).m_130946_("/");
                continue;
            }
            if (anyInvalid) continue;
            anyInvalid = true;
            if (!attributeTooltips.containsKey((Object)slot)) {
                attributeTooltips.put(slot, Component.m_237113_((String)""));
            }
            attributeTooltips.get((Object)slot).m_130946_("[+]");
        }
        return onlyInvalid;
    }

    private static int renderAttribute(GuiGraphics guiGraphics, Attribute attribute, AttributeSlot slot, int x, int y, ItemStack stack, Multimap<Attribute, AttributeModifier> slotAttributes, Minecraft mc, boolean forceRenderIfZero, Multimap<Attribute, AttributeModifier> equippedSlotAttributes, @Nullable Set<Attribute> equippedAttrsToRender) {
        AttributeIconEntry entry = AttributeTooltips.getIconForAttribute(attribute);
        if (entry != null) {
            double value;
            if (equippedAttrsToRender != null) {
                equippedAttrsToRender.remove(attribute);
            }
            if ((value = AttributeTooltips.getAttribute((Player)mc.f_91074_, slot, stack, slotAttributes, attribute)) != 0.0 || forceRenderIfZero) {
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.m_280163_(entry.texture(), x, y, 0.0f, 0.0f, 9, 9, 9, 9);
                MutableComponent valueStr = AttributeTooltips.format(attribute, value, entry.displayTypes().get((Object)slot));
                if (ImprovedTooltipsModule.showUpgradeStatus && slot.hasCanonicalSlot()) {
                    ItemStack equipped;
                    AttributeIconEntry.CompareType compareType = entry.comparison();
                    EquipmentSlot equipSlot = slot.getCanonicalSlot();
                    if (!(mc.f_91074_ == null || (equipped = mc.f_91074_.m_6844_(equipSlot)).equals(stack) || equipped.m_41619_() || equippedSlotAttributes.isEmpty())) {
                        double otherValue = AttributeTooltips.getAttribute((Player)mc.f_91074_, slot, equipped, equippedSlotAttributes, attribute);
                        ChatFormatting color = compareType.getColor(value, otherValue);
                        if (color != ChatFormatting.WHITE) {
                            int xp = x - 2;
                            int yp = y - 2;
                            if (ImprovedTooltipsModule.animateUpDownArrows && QuarkClient.ticker.total % 20.0f < 10.0f) {
                                ++yp;
                            }
                            guiGraphics.m_280163_(color == ChatFormatting.RED ? TEXTURE_DOWNGRADE : TEXTURE_UPGRADE, xp, yp, 0.0f, 0.0f, 13, 13, 13, 13);
                        }
                        valueStr = valueStr.m_130940_(color);
                    }
                }
                guiGraphics.m_280430_(mc.f_91062_, (Component)valueStr, x + 12, y + 1, -1);
                x += mc.f_91062_.m_92852_((FormattedText)valueStr) + 20;
            }
        }
        return x;
    }

    private static AttributeSlot getPrimarySlot(ItemStack stack) {
        if (stack.m_41720_() instanceof PotionItem || stack.m_41720_() instanceof TippedArrowItem) {
            return AttributeSlot.POTION;
        }
        return AttributeSlot.fromCanonicalSlot(Mob.m_147233_((ItemStack)stack));
    }

    private static boolean canShowAttributes(ItemStack stack, AttributeSlot slot) {
        if (stack.m_41619_()) {
            return false;
        }
        if (slot == AttributeSlot.POTION) {
            return (ItemNBTHelper.getInt((ItemStack)stack, (String)"HideFlags", (int)0) & 0x20) == 0;
        }
        return (ItemNBTHelper.getInt((ItemStack)stack, (String)"HideFlags", (int)0) & 2) == 0;
    }

    private static double getAttribute(Player player, AttributeSlot slot, ItemStack stack, Multimap<Attribute, AttributeModifier> map, Attribute key) {
        AttributeInstance attribute;
        AttributeInstance attribute2;
        if (player == null) {
            return 0.0;
        }
        Collection collection = map.get((Object)key);
        if (collection.isEmpty()) {
            return 0.0;
        }
        double value = 0.0;
        AttributeIconEntry entry = AttributeTooltips.getIconForAttribute(key);
        if (entry == null) {
            return 0.0;
        }
        AttributeDisplayType displayType = entry.displayTypes().get((Object)slot);
        if (!(displayType == AttributeDisplayType.PERCENTAGE || slot == AttributeSlot.POTION && key.equals(Attributes.f_22281_) || (attribute2 = player.m_21051_(key)) == null)) {
            value = attribute2.m_22115_();
        }
        for (AttributeModifier modifier : collection) {
            if (modifier.m_22217_() != AttributeModifier.Operation.ADDITION) continue;
            value += modifier.m_22218_();
        }
        double rawValue = value;
        for (AttributeModifier modifier : collection) {
            if (modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE) continue;
            value += rawValue * modifier.m_22218_();
        }
        for (AttributeModifier modifier : collection) {
            if (modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL) continue;
            value += value * modifier.m_22218_();
        }
        if (key.equals(Attributes.f_22281_) && slot == AttributeSlot.MAINHAND) {
            value += (double)EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_);
        }
        if (key.equals(Attributes.f_22282_) && slot == AttributeSlot.MAINHAND) {
            value += (double)Quark.ZETA.itemExtensions.get(stack).getEnchantmentLevelZeta(stack, Enchantments.f_44980_);
        }
        if (!(displayType != AttributeDisplayType.DIFFERENCE || slot == AttributeSlot.POTION && key.equals(Attributes.f_22281_) || (attribute = player.m_21051_(key)) == null)) {
            value -= attribute.m_22115_();
        }
        return value;
    }

    public record AttributeComponent(ItemStack stack, AttributeSlot slot) implements ClientTooltipComponent,
    TooltipComponent
    {
        public void m_183452_(@NotNull Font font, int tooltipX, int tooltipY, @NotNull GuiGraphics guiGraphics) {
            PoseStack pose = guiGraphics.m_280168_();
            if (!Screen.m_96638_()) {
                pose.m_85836_();
                pose.m_252880_(0.0f, 0.0f, 500.0f);
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft mc = Minecraft.m_91087_();
                int y = tooltipY - 1;
                AttributeSlot primarySlot = AttributeTooltips.getPrimarySlot(this.stack);
                boolean showSlots = false;
                int x = tooltipX;
                if (AttributeTooltips.canShowAttributes(this.stack, this.slot)) {
                    Multimap<Attribute, AttributeModifier> slotAttributes = AttributeTooltips.getModifiers(this.stack, this.slot);
                    Multimap<Attribute, AttributeModifier> presentOnEquipped = AttributeTooltips.getModifiersOnEquipped((Player)mc.f_91074_, this.stack, slotAttributes, this.slot);
                    LinkedHashSet<Attribute> equippedAttrsToRender = new LinkedHashSet<Attribute>(presentOnEquipped.keySet());
                    for (Attribute attr : slotAttributes.keySet()) {
                        if (AttributeTooltips.getIconForAttribute(attr) == null || this.slot == primarySlot) continue;
                        showSlots = true;
                        break;
                    }
                    boolean anyToRender = false;
                    for (Attribute attr : slotAttributes.keySet()) {
                        double value = AttributeTooltips.getAttribute((Player)mc.f_91074_, this.slot, this.stack, slotAttributes, attr);
                        if (value == 0.0) continue;
                        anyToRender = true;
                        break;
                    }
                    if (anyToRender) {
                        if (showSlots) {
                            RenderSystem.setShader(GameRenderer::m_172817_);
                            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            guiGraphics.m_280163_(ClientUtil.GENERAL_ICONS, x, y, (float)(193 + this.slot.ordinal() * 9), 35.0f, 9, 9, 256, 256);
                            x += 20;
                        }
                        for (Attribute key : slotAttributes.keySet()) {
                            x = AttributeTooltips.renderAttribute(guiGraphics, key, this.slot, x, y, this.stack, slotAttributes, mc, false, presentOnEquipped, equippedAttrsToRender);
                        }
                        for (Attribute key : equippedAttrsToRender) {
                            x = AttributeTooltips.renderAttribute(guiGraphics, key, this.slot, x, y, this.stack, slotAttributes, mc, true, presentOnEquipped, null);
                        }
                        for (Attribute key : slotAttributes.keys()) {
                            if (AttributeTooltips.getIconForAttribute(key) != null) continue;
                            guiGraphics.m_280056_(font, "[+]", x + 1, y + 1, 0xFFFF55, true);
                            break;
                        }
                    }
                }
                pose.m_85849_();
            }
        }

        public int m_142103_() {
            return 10;
        }

        public int m_142069_(@NotNull Font font) {
            int width = 0;
            if (AttributeTooltips.canShowAttributes(this.stack, this.slot)) {
                Minecraft mc = Minecraft.m_91087_();
                Multimap<Attribute, AttributeModifier> slotAttributes = AttributeTooltips.getModifiers(this.stack, this.slot);
                Multimap<Attribute, AttributeModifier> presentOnEquipped = AttributeTooltips.getModifiersOnEquipped((Player)mc.f_91074_, this.stack, slotAttributes, this.slot);
                LinkedHashSet equippedAttrsToRender = new LinkedHashSet(presentOnEquipped.keySet());
                AttributeSlot primarySlot = AttributeTooltips.getPrimarySlot(this.stack);
                boolean showSlots = false;
                for (Attribute attr : slotAttributes.keySet()) {
                    if (AttributeTooltips.getIconForAttribute(attr) == null || this.slot == primarySlot) continue;
                    showSlots = true;
                    break;
                }
                boolean anyToRender = false;
                for (Attribute attr : slotAttributes.keySet()) {
                    double value = AttributeTooltips.getAttribute((Player)mc.f_91074_, this.slot, this.stack, slotAttributes, attr);
                    if (value == 0.0) continue;
                    anyToRender = true;
                    break;
                }
                if (anyToRender) {
                    MutableComponent valueStr;
                    double value;
                    if (showSlots) {
                        width += 20;
                    }
                    for (Attribute key : slotAttributes.keySet()) {
                        AttributeIconEntry icons = AttributeTooltips.getIconForAttribute(key);
                        if (icons == null) continue;
                        equippedAttrsToRender.remove(key);
                        value = AttributeTooltips.getAttribute((Player)mc.f_91074_, this.slot, this.stack, slotAttributes, key);
                        if (value == 0.0) continue;
                        valueStr = AttributeTooltips.format(key, value, icons.displayTypes().get((Object)this.slot));
                        width += font.m_92852_((FormattedText)valueStr) + 20;
                    }
                    for (Attribute key : equippedAttrsToRender) {
                        AttributeIconEntry icons = AttributeTooltips.getIconForAttribute(key);
                        if (icons == null) continue;
                        value = AttributeTooltips.getAttribute((Player)mc.f_91074_, this.slot, this.stack, slotAttributes, key);
                        valueStr = AttributeTooltips.format(key, value, icons.displayTypes().get((Object)this.slot));
                        width += font.m_92852_((FormattedText)valueStr) + 20;
                    }
                    for (Attribute key : slotAttributes.keys()) {
                        if (AttributeTooltips.getIconForAttribute(key) != null) continue;
                        width += font.m_92895_("[+]") + 8;
                        break;
                    }
                }
            }
            return width - 8;
        }
    }
}

