/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.layout;

import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.layout.Layout;
import de.johni0702.minecraft.gui.utils.lwjgl.Dimension;
import de.johni0702.minecraft.gui.utils.lwjgl.Point;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadablePoint;
import de.johni0702.minecraft.gui.utils.lwjgl.WritableDimension;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public abstract class CustomLayout<T extends GuiContainer<T>>
implements Layout {
    private final Layout parent;
    private final Map<GuiElement, Pair<Point, Dimension>> result = new LinkedHashMap<GuiElement, Pair<Point, Dimension>>();

    public CustomLayout() {
        this(null);
    }

    public CustomLayout(Layout parent) {
        this.parent = parent;
    }

    public Map<GuiElement, Pair<ReadablePoint, ReadableDimension>> layOut(GuiContainer container, ReadableDimension size) {
        this.result.clear();
        if (this.parent == null) {
            Collection<GuiElement> elements = container.getChildren();
            for (GuiElement element : elements) {
                this.result.put(element, (Pair<Point, Dimension>)Pair.of((Object)new Point(0, 0), (Object)new Dimension(element.getMinSize())));
            }
        } else {
            Map<GuiElement, Pair<ReadablePoint, ReadableDimension>> elements = this.parent.layOut(container, size);
            for (Map.Entry<GuiElement, Pair<ReadablePoint, ReadableDimension>> entry : elements.entrySet()) {
                Pair<ReadablePoint, ReadableDimension> pair = entry.getValue();
                this.result.put(entry.getKey(), (Pair<Point, Dimension>)Pair.of((Object)new Point((ReadablePoint)pair.getLeft()), (Object)new Dimension((ReadableDimension)pair.getRight())));
            }
        }
        this.layout(container, size.getWidth(), size.getHeight());
        return this.result;
    }

    private Pair<Point, Dimension> entry(GuiElement element) {
        return this.result.get(element);
    }

    protected void set(GuiElement element, int x, int y, int width, int height) {
        Pair<Point, Dimension> entry = this.entry(element);
        ((Point)entry.getLeft()).setLocation(x, y);
        ((Dimension)entry.getRight()).setSize(width, height);
    }

    protected void pos(GuiElement element, int x, int y) {
        ((Point)this.entry(element).getLeft()).setLocation(x, y);
    }

    protected void size(GuiElement element, ReadableDimension size) {
        size.getSize((WritableDimension)this.entry(element).getRight());
    }

    protected void size(GuiElement element, int width, int height) {
        ((Dimension)this.entry(element).getRight()).setSize(width, height);
    }

    protected void x(GuiElement element, int x) {
        ((Point)this.entry(element).getLeft()).setX(x);
    }

    protected void y(GuiElement element, int y) {
        ((Point)this.entry(element).getLeft()).setY(y);
    }

    protected void width(GuiElement element, int width) {
        ((Dimension)this.entry(element).getRight()).setWidth(width);
    }

    protected void height(GuiElement element, int height) {
        ((Dimension)this.entry(element).getRight()).setHeight(height);
    }

    protected int x(GuiElement element) {
        return ((Point)this.entry(element).getLeft()).getX();
    }

    protected int y(GuiElement element) {
        return ((Point)this.entry(element).getLeft()).getY();
    }

    protected int width(GuiElement element) {
        return ((Dimension)this.entry(element).getRight()).getWidth();
    }

    protected int height(GuiElement element) {
        return ((Dimension)this.entry(element).getRight()).getHeight();
    }

    protected abstract void layout(T var1, int var2, int var3);

    @Override
    public ReadableDimension calcMinSize(GuiContainer<?> container) {
        return new Dimension(0, 0);
    }
}

