/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.element.advanced;

import de.johni0702.minecraft.gui.GuiRenderer;
import de.johni0702.minecraft.gui.RenderInfo;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.element.AbstractGuiElement;
import de.johni0702.minecraft.gui.element.advanced.IGuiTextArea;
import de.johni0702.minecraft.gui.function.Clickable;
import de.johni0702.minecraft.gui.function.Focusable;
import de.johni0702.minecraft.gui.function.Tickable;
import de.johni0702.minecraft.gui.function.Typeable;
import de.johni0702.minecraft.gui.utils.Consumer;
import de.johni0702.minecraft.gui.utils.Utils;
import de.johni0702.minecraft.gui.utils.lwjgl.Color;
import de.johni0702.minecraft.gui.utils.lwjgl.Dimension;
import de.johni0702.minecraft.gui.utils.lwjgl.Point;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableColor;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadablePoint;
import de.johni0702.minecraft.gui.versions.MCVer;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.SharedConstants;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;

public abstract class AbstractGuiTextArea<T extends AbstractGuiTextArea<T>>
extends AbstractGuiElement<T>
implements Clickable,
Typeable,
Tickable,
IGuiTextArea<T> {
    private static final ReadableColor BACKGROUND_COLOR = new Color(160, 160, 160);
    private static final ReadableColor CURSOR_COLOR = new Color(240, 240, 240);
    private static final int BORDER = 4;
    private static final int LINE_SPACING = 2;
    private boolean focused;
    private Focusable next;
    private Focusable previous;
    private Consumer<Boolean> focusChanged;
    private int maxTextWidth = -1;
    private int maxTextHeight = -1;
    private int maxCharCount = -1;
    private String[] text = new String[]{""};
    private String[] hint;
    private int cursorX;
    private int cursorY;
    private int selectionX;
    private int selectionY;
    private int currentXOffset;
    private int currentYOffset;
    private int blinkCursorTick;
    public ReadableColor textColorEnabled = new Color(224, 224, 224);
    public ReadableColor textColorDisabled = new Color(112, 112, 112);
    private ReadableDimension size = new Dimension(0, 0);

    public AbstractGuiTextArea() {
    }

    public AbstractGuiTextArea(GuiContainer container) {
        super(container);
    }

    @Override
    public T setText(String[] lines) {
        if (lines.length > this.maxTextHeight) {
            lines = Arrays.copyOf(lines, this.maxTextHeight);
        }
        this.text = lines;
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].length() <= this.maxTextWidth) continue;
            lines[i] = lines[i].substring(0, this.maxTextWidth);
        }
        return (T)((AbstractGuiTextArea)this.getThis());
    }

    @Override
    public String[] getText() {
        return this.text;
    }

    @Override
    public String getText(int fromX, int fromY, int toX, int toY) {
        StringBuilder sb = new StringBuilder();
        if (fromY == toY) {
            sb.append(this.text[fromY].substring(fromX, toX));
        } else {
            sb.append(this.text[fromY].substring(fromX)).append('\n');
            for (int y = fromY + 1; y < toY; ++y) {
                sb.append(this.text[y]).append('\n');
            }
            sb.append(this.text[toY].substring(0, toX));
        }
        return sb.toString();
    }

    private void deleteText(int fromX, int fromY, int toX, int toY) {
        String[] newText = new String[this.text.length - (toY - fromY)];
        if (fromY > 0) {
            System.arraycopy(this.text, 0, newText, 0, fromY);
        }
        newText[fromY] = this.text[fromY].substring(0, fromX) + this.text[toY].substring(toX);
        if (toY + 1 < this.text.length) {
            System.arraycopy(this.text, toY + 1, newText, fromY + 1, this.text.length - toY - 1);
        }
        this.text = newText;
    }

    @Override
    public int getSelectionFromX() {
        if (this.cursorY == this.selectionY) {
            return this.cursorX > this.selectionX ? this.selectionX : this.cursorX;
        }
        return this.cursorY > this.selectionY ? this.selectionX : this.cursorX;
    }

    @Override
    public int getSelectionToX() {
        if (this.cursorY == this.selectionY) {
            return this.cursorX > this.selectionX ? this.cursorX : this.selectionX;
        }
        return this.cursorY > this.selectionY ? this.cursorX : this.selectionX;
    }

    @Override
    public int getSelectionFromY() {
        return this.cursorY > this.selectionY ? this.selectionY : this.cursorY;
    }

    @Override
    public int getSelectionToY() {
        return this.cursorY > this.selectionY ? this.cursorY : this.selectionY;
    }

    @Override
    public String getSelectedText() {
        if (this.cursorX == this.selectionX && this.cursorY == this.selectionY) {
            return "";
        }
        int fromX = this.getSelectionFromX();
        int fromY = this.getSelectionFromY();
        int toX = this.getSelectionToX();
        int toY = this.getSelectionToY();
        return this.getText(fromX, fromY, toX, toY);
    }

    @Override
    public void deleteSelectedText() {
        if (this.cursorX == this.selectionX && this.cursorY == this.selectionY) {
            return;
        }
        int fromX = this.getSelectionFromX();
        int fromY = this.getSelectionFromY();
        int toX = this.getSelectionToX();
        int toY = this.getSelectionToY();
        this.deleteText(fromX, fromY, toX, toY);
        this.cursorX = this.selectionX = fromX;
        this.cursorY = this.selectionY = fromY;
    }

    private void updateCurrentOffset() {
        this.currentXOffset = Math.min(this.currentXOffset, this.cursorX);
        String line = this.text[this.cursorY].substring(this.currentXOffset, this.cursorX);
        Font fontRenderer = MCVer.getFontRenderer();
        int currentWidth = fontRenderer.m_92895_(line);
        if (currentWidth > this.size.getWidth() - 8) {
            this.currentXOffset = this.cursorX - fontRenderer.m_92837_(line, this.size.getWidth() - 8, true).length();
        }
        this.currentYOffset = Math.min(this.currentYOffset, this.cursorY);
        Objects.requireNonNull(MCVer.getFontRenderer());
        int lineHeight = 9 + 2;
        int contentHeight = this.size.getHeight() - 8;
        int maxLines = contentHeight / lineHeight;
        if (this.cursorY - this.currentYOffset >= maxLines) {
            this.currentYOffset = this.cursorY - maxLines + 1;
        }
    }

    @Override
    public String cutSelectedText() {
        String selection = this.getSelectedText();
        this.deleteSelectedText();
        return selection;
    }

    @Override
    public void writeText(String append) {
        for (char c : append.toCharArray()) {
            this.writeChar(c);
        }
    }

    @Override
    public void writeChar(char c) {
        if (!SharedConstants.m_136188_((char)c)) {
            return;
        }
        int totalCharCount = 0;
        for (String line : this.text) {
            totalCharCount += line.length();
        }
        if (this.maxCharCount > 0 && totalCharCount - this.getSelectedText().length() >= this.maxCharCount) {
            return;
        }
        this.deleteSelectedText();
        if (c == '\n') {
            if (this.text.length >= this.maxTextHeight) {
                return;
            }
            String[] newText = new String[this.text.length + 1];
            if (this.cursorY > 0) {
                System.arraycopy(this.text, 0, newText, 0, this.cursorY);
            }
            newText[this.cursorY] = this.text[this.cursorY].substring(0, this.cursorX);
            newText[this.cursorY + 1] = this.text[this.cursorY].substring(this.cursorX);
            if (this.cursorY + 1 < this.text.length) {
                System.arraycopy(this.text, this.cursorY + 1, newText, this.cursorY + 2, this.text.length - this.cursorY - 1);
            }
            this.text = newText;
            this.cursorX = 0;
            this.selectionX = 0;
            this.selectionY = ++this.cursorY;
        } else {
            Object line = this.text[this.cursorY];
            if (((String)line).length() >= this.maxTextWidth) {
                return;
            }
            this.text[this.cursorY] = line = ((String)line).substring(0, this.cursorX) + c + ((String)line).substring(this.cursorX);
            this.selectionX = ++this.cursorX;
        }
    }

    private void deleteNextChar() {
        Object line = this.text[this.cursorY];
        if (this.cursorX < ((String)line).length()) {
            this.text[this.cursorY] = line = ((String)line).substring(0, this.cursorX) + ((String)line).substring(this.cursorX + 1);
        } else if (this.cursorY + 1 < this.text.length) {
            this.deleteText(this.cursorX, this.cursorY, 0, this.cursorY + 1);
        }
    }

    private int getNextWordLength() {
        int length = 0;
        String line = this.text[this.cursorY];
        boolean inWord = true;
        for (int i = this.cursorX; i < line.length(); ++i) {
            if (inWord) {
                if (line.charAt(i) == ' ') {
                    inWord = false;
                }
            } else if (line.charAt(i) != ' ') {
                return length;
            }
            ++length;
        }
        return length;
    }

    private void deleteNextWord() {
        int worldLength = this.getNextWordLength();
        if (worldLength == 0) {
            this.deleteNextChar();
        } else {
            this.deleteText(this.cursorX, this.cursorY, this.cursorX + worldLength, this.cursorY);
        }
    }

    private void deletePreviousChar() {
        if (this.cursorX > 0) {
            Object line = this.text[this.cursorY];
            line = ((String)line).substring(0, this.cursorX - 1) + ((String)line).substring(this.cursorX);
            this.selectionX = --this.cursorX;
            this.text[this.cursorY] = line;
        } else if (this.cursorY > 0) {
            int fromX = this.text[this.cursorY - 1].length();
            this.deleteText(fromX, this.cursorY - 1, this.cursorX, this.cursorY);
            this.selectionX = this.cursorX = fromX;
            this.selectionY = --this.cursorY;
        }
    }

    private int getPreviousWordLength() {
        int length = 0;
        String line = this.text[this.cursorY];
        boolean inWord = false;
        for (int i = this.cursorX - 1; i >= 0; --i) {
            if (inWord) {
                if (line.charAt(i) == ' ') {
                    return length;
                }
            } else if (line.charAt(i) != ' ') {
                inWord = true;
            }
            ++length;
        }
        return length;
    }

    private void deletePreviousWord() {
        int worldLength = this.getPreviousWordLength();
        if (worldLength == 0) {
            this.deletePreviousChar();
        } else {
            this.deleteText(this.cursorX, this.cursorY, this.cursorX - worldLength, this.cursorY);
            this.selectionX = this.cursorX -= worldLength;
        }
    }

    @Override
    public T setCursorPosition(int x, int y) {
        this.selectionY = this.cursorY = Utils.clamp(y, 0, this.text.length - 1);
        this.selectionX = this.cursorX = Utils.clamp(x, 0, this.text[this.cursorY].length());
        return (T)((AbstractGuiTextArea)this.getThis());
    }

    @Override
    protected ReadableDimension calcMinSize() {
        return new Dimension(0, 0);
    }

    @Override
    public boolean mouseClick(ReadablePoint position, int button) {
        boolean hovering;
        if (this.getContainer() != null) {
            position = new Point(position);
            this.getContainer().convertFor(this, (Point)position);
        }
        if ((hovering = this.isMouseHovering(position)) && this.isFocused() && button == 0) {
            this.updateCurrentOffset();
            int mouseX = position.getX() - 4;
            int mouseY = position.getY() - 4;
            Font fontRenderer = MCVer.getFontRenderer();
            Objects.requireNonNull(fontRenderer);
            int textY = Utils.clamp(mouseY / (9 + 2) + this.currentYOffset, 0, this.text.length - 1);
            if (this.cursorY != textY) {
                this.currentXOffset = 0;
            }
            String line = this.text[textY].substring(this.currentXOffset);
            int textX = fontRenderer.m_92834_(line, mouseX).length() + this.currentXOffset;
            this.setCursorPosition(textX, textY);
        }
        this.setFocused(hovering);
        return hovering;
    }

    protected boolean isMouseHovering(ReadablePoint pos) {
        return pos.getX() > 0 && pos.getY() > 0 && pos.getX() < this.size.getWidth() && pos.getY() < this.size.getHeight();
    }

    @Override
    public T setFocused(boolean isFocused) {
        if (isFocused && !this.focused) {
            this.blinkCursorTick = 0;
        }
        if (this.focused != isFocused) {
            this.focused = isFocused;
            this.onFocusChanged(this.focused);
        }
        return (T)((AbstractGuiTextArea)this.getThis());
    }

    @Override
    public T setNext(Focusable next) {
        this.next = next;
        return (T)((AbstractGuiTextArea)this.getThis());
    }

    @Override
    public T setPrevious(Focusable previous) {
        this.previous = previous;
        return (T)((AbstractGuiTextArea)this.getThis());
    }

    @Override
    public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
        this.size = size;
        this.updateCurrentOffset();
        super.draw(renderer, size, renderInfo);
        Font fontRenderer = MCVer.getFontRenderer();
        int width = size.getWidth();
        int height = size.getHeight();
        renderer.drawRect(0, 0, width, height, BACKGROUND_COLOR);
        renderer.drawRect(1, 1, width - 2, height - 2, ReadableColor.BLACK);
        ReadableColor textColor = this.isEnabled() ? this.textColorEnabled : this.textColorDisabled;
        Objects.requireNonNull(fontRenderer);
        int lineHeight = 9 + 2;
        int contentHeight = height - 8;
        int maxLines = contentHeight / lineHeight;
        int contentWidth = width - 8;
        if (this.hint != null && !this.isFocused() && Arrays.stream(this.text).allMatch(String::isEmpty)) {
            for (int i = 0; i < maxLines && i < this.hint.length; ++i) {
                String line = fontRenderer.m_92834_(this.hint[i], contentWidth);
                int posY = 4 + i * lineHeight;
                renderer.drawString(4, posY, this.textColorDisabled, line, true);
            }
            return;
        }
        for (int i = 0; i < maxLines && i + this.currentYOffset < this.text.length; ++i) {
            int lineY = i + this.currentYOffset;
            String line = this.text[lineY];
            int leftTrimmed = 0;
            if (lineY == this.cursorY) {
                line = line.substring(this.currentXOffset);
                leftTrimmed = this.currentXOffset;
            }
            line = fontRenderer.m_92834_(line, contentWidth);
            int posY = 4 + i * lineHeight;
            int lineEnd = renderer.drawString(4, posY, textColor, line, true);
            int fromX = this.getSelectionFromX();
            int fromY = this.getSelectionFromY();
            int toX = this.getSelectionToX();
            int toY = this.getSelectionToY();
            if (lineY > fromY && lineY < toY) {
                renderer.invertColors(lineEnd, posY - 1 + lineHeight, 4, posY - 1);
            } else if (lineY == fromY && lineY == toY) {
                leftStr = line.substring(0, Utils.clamp(fromX - leftTrimmed, 0, line.length()));
                String rightStr = line.substring(Utils.clamp(toX - leftTrimmed, 0, line.length()));
                int left = 4 + fontRenderer.m_92895_(leftStr);
                int right = lineEnd - fontRenderer.m_92895_(rightStr) - 1;
                renderer.invertColors(right, posY - 1 + lineHeight, left, posY - 1);
            } else if (lineY == fromY) {
                String rightStr = line.substring(Utils.clamp(fromX - leftTrimmed, 0, line.length()));
                renderer.invertColors(lineEnd, posY - 1 + lineHeight, lineEnd - fontRenderer.m_92895_(rightStr), posY - 1);
            } else if (lineY == toY) {
                leftStr = line.substring(0, Utils.clamp(toX - leftTrimmed, 0, line.length()));
                int right = 4 + fontRenderer.m_92895_(leftStr);
                renderer.invertColors(right, posY - 1 + lineHeight, 4, posY - 1);
            }
            if (lineY != this.cursorY || this.blinkCursorTick / 6 % 2 != 0 || !this.focused) continue;
            String beforeCursor = line.substring(0, this.cursorX - leftTrimmed);
            int posX = 4 + fontRenderer.m_92895_(beforeCursor);
            if (this.cursorX == this.text[lineY].length()) {
                renderer.drawString(posX, posY, CURSOR_COLOR, "_", true);
                continue;
            }
            Objects.requireNonNull(fontRenderer);
            renderer.drawRect(posX, posY - 1, 1, 1 + 9, CURSOR_COLOR);
        }
    }

    @Override
    public boolean typeKey(ReadablePoint mousePosition, int keyCode, char keyChar, boolean ctrlDown, boolean shiftDown) {
        if (keyCode == 258) {
            Focusable other;
            Focusable focusable = other = shiftDown ? this.previous : this.next;
            if (other != null) {
                this.setFocused(false);
                other.setFocused(true);
            }
            return true;
        }
        if (!this.focused) {
            return false;
        }
        if (Screen.m_96637_()) {
            switch (keyCode) {
                case 65: {
                    this.cursorY = 0;
                    this.cursorX = 0;
                    this.selectionY = this.text.length - 1;
                    this.selectionX = this.text[this.selectionY].length();
                    return true;
                }
                case 67: {
                    MCVer.setClipboardString(this.getSelectedText());
                    return true;
                }
                case 86: {
                    if (this.isEnabled()) {
                        this.writeText(MCVer.getClipboardString());
                    }
                    return true;
                }
                case 88: {
                    if (this.isEnabled()) {
                        MCVer.setClipboardString(this.cutSelectedText());
                    }
                    return true;
                }
            }
        }
        boolean words = Screen.m_96637_();
        boolean select = Screen.m_96638_();
        switch (keyCode) {
            case 268: {
                this.cursorX = 0;
                break;
            }
            case 269: {
                this.cursorX = this.text[this.cursorY].length();
                break;
            }
            case 263: {
                if (this.cursorX == 0) {
                    if (this.cursorY <= 0) break;
                    --this.cursorY;
                    this.cursorX = this.text[this.cursorY].length();
                    break;
                }
                if (words) {
                    this.cursorX -= this.getPreviousWordLength();
                    break;
                }
                --this.cursorX;
                break;
            }
            case 262: {
                if (this.cursorX == this.text[this.cursorY].length()) {
                    if (this.cursorY >= this.text.length - 1) break;
                    ++this.cursorY;
                    this.cursorX = 0;
                    break;
                }
                if (words) {
                    this.cursorX += this.getNextWordLength();
                    break;
                }
                ++this.cursorX;
                break;
            }
            case 265: {
                if (this.cursorY <= 0) break;
                --this.cursorY;
                this.cursorX = Math.min(this.cursorX, this.text[this.cursorY].length());
                break;
            }
            case 264: {
                if (this.cursorY + 1 >= this.text.length) break;
                ++this.cursorY;
                this.cursorX = Math.min(this.cursorX, this.text[this.cursorY].length());
                break;
            }
            case 259: {
                if (this.isEnabled()) {
                    if (this.getSelectedText().length() > 0) {
                        this.deleteSelectedText();
                    } else if (words) {
                        this.deletePreviousWord();
                    } else {
                        this.deletePreviousChar();
                    }
                }
                return true;
            }
            case 261: {
                if (this.isEnabled()) {
                    if (this.getSelectedText().length() > 0) {
                        this.deleteSelectedText();
                    } else if (words) {
                        this.deleteNextWord();
                    } else {
                        this.deleteNextChar();
                    }
                }
                return true;
            }
            default: {
                if (this.isEnabled()) {
                    if (keyChar == '\r') {
                        keyChar = (char)10;
                    }
                    this.writeChar(keyChar);
                }
                return true;
            }
        }
        if (!select) {
            this.selectionX = this.cursorX;
            this.selectionY = this.cursorY;
        }
        return true;
    }

    @Override
    public void tick() {
        ++this.blinkCursorTick;
    }

    @Override
    public T setMaxTextWidth(int maxTextWidth) {
        this.maxTextWidth = maxTextWidth;
        return (T)((AbstractGuiTextArea)this.getThis());
    }

    @Override
    public T setMaxTextHeight(int maxTextHeight) {
        this.maxTextHeight = maxTextHeight;
        return (T)((AbstractGuiTextArea)this.getThis());
    }

    @Override
    public T setMaxCharCount(int maxCharCount) {
        this.maxCharCount = maxCharCount;
        return (T)((AbstractGuiTextArea)this.getThis());
    }

    @Override
    public T setTextColor(ReadableColor textColor) {
        this.textColorEnabled = textColor;
        return (T)((AbstractGuiTextArea)this.getThis());
    }

    @Override
    public T setTextColorDisabled(ReadableColor textColorDisabled) {
        this.textColorDisabled = textColorDisabled;
        return (T)((AbstractGuiTextArea)this.getThis());
    }

    @Override
    public T onFocusChange(Consumer<Boolean> focusChanged) {
        this.focusChanged = focusChanged;
        return (T)((AbstractGuiTextArea)this.getThis());
    }

    protected void onFocusChanged(boolean focused) {
        if (this.focusChanged != null) {
            this.focusChanged.consume(focused);
        }
    }

    @Override
    public String[] getHint() {
        return this.hint;
    }

    @Override
    public T setHint(String ... hint) {
        this.hint = hint;
        return (T)((AbstractGuiTextArea)this.getThis());
    }

    @Override
    public T setI18nHint(String hint, Object ... args) {
        this.setHint(I18n.m_118938_((String)hint, (Object[])args).split("/n"));
        return (T)((AbstractGuiTextArea)this.getThis());
    }

    @Override
    public boolean isFocused() {
        return this.focused;
    }

    @Override
    public Focusable getNext() {
        return this.next;
    }

    @Override
    public Focusable getPrevious() {
        return this.previous;
    }

    @Override
    public int getMaxTextWidth() {
        return this.maxTextWidth;
    }

    @Override
    public int getMaxTextHeight() {
        return this.maxTextHeight;
    }

    @Override
    public int getMaxCharCount() {
        return this.maxCharCount;
    }
}

