/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.element;

import com.google.common.base.Preconditions;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.element.AbstractGuiTextField;
import de.johni0702.minecraft.gui.element.IGuiNumberField;
import java.util.Locale;
import java.util.regex.Pattern;

public abstract class AbstractGuiNumberField<T extends AbstractGuiNumberField<T>>
extends AbstractGuiTextField<T>
implements IGuiNumberField<T> {
    private int precision;
    private volatile Pattern precisionPattern;
    private Double minValue;
    private Double maxValue;
    private boolean validateOnFocusChange = false;

    public AbstractGuiNumberField() {
        this.setValue(0);
    }

    public AbstractGuiNumberField(GuiContainer container) {
        super(container);
        this.setValue(0);
    }

    @Override
    public T setText(String text) {
        if (!this.isTextValid(text, !this.validateOnFocusChange)) {
            throw new IllegalArgumentException(text + " is not a valid number!");
        }
        return (T)((AbstractGuiNumberField)super.setText(text));
    }

    @Override
    public T setValidateOnFocusChange(boolean validateOnFocusChange) {
        this.validateOnFocusChange = validateOnFocusChange;
        return (T)((AbstractGuiNumberField)this.getThis());
    }

    private boolean isSemiZero(String text) {
        return text.isEmpty() || "-".equals(text);
    }

    private boolean isTextValid(String text, boolean validateRange) {
        if (this.validateOnFocusChange && this.isSemiZero(text)) {
            return !validateRange || this.valueInRange(0.0);
        }
        try {
            if (this.precision == 0) {
                int val = Integer.parseInt(text);
                return !validateRange || this.valueInRange(val);
            }
            double val = Double.parseDouble(text);
            return !validateRange || this.valueInRange(val) && this.precisionPattern.matcher(text).matches();
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean valueInRange(double value) {
        return (this.minValue == null || value >= this.minValue) && (this.maxValue == null || value <= this.maxValue);
    }

    @Override
    protected void onTextChanged(String from) {
        if (this.isTextValid(this.getText(), !this.validateOnFocusChange)) {
            super.onTextChanged(from);
        } else {
            this.setText(from);
        }
    }

    @Override
    public byte getByte() {
        if (this.validateOnFocusChange && this.isSemiZero(this.getText())) {
            return 0;
        }
        return Byte.parseByte(this.getText());
    }

    @Override
    public short getShort() {
        if (this.validateOnFocusChange && this.isSemiZero(this.getText())) {
            return 0;
        }
        return Short.parseShort(this.getText());
    }

    @Override
    public int getInteger() {
        if (this.validateOnFocusChange && this.isSemiZero(this.getText())) {
            return 0;
        }
        return Integer.parseInt(this.getText());
    }

    @Override
    public long getLong() {
        if (this.validateOnFocusChange && this.isSemiZero(this.getText())) {
            return 0L;
        }
        return Long.parseLong(this.getText());
    }

    @Override
    public float getFloat() {
        if (this.validateOnFocusChange && this.isSemiZero(this.getText())) {
            return 0.0f;
        }
        return Float.parseFloat(this.getText());
    }

    @Override
    public double getDouble() {
        if (this.validateOnFocusChange && this.isSemiZero(this.getText())) {
            return 0.0;
        }
        return Double.parseDouble(this.getText());
    }

    @Override
    public T setValue(int value) {
        this.setText(Integer.toString(value));
        return (T)((AbstractGuiNumberField)this.getThis());
    }

    @Override
    public T setValue(double value) {
        this.setText(String.format(Locale.ROOT, "%." + this.precision + "f", value));
        return (T)((AbstractGuiNumberField)this.getThis());
    }

    @Override
    public T setPrecision(int precision) {
        Preconditions.checkArgument((precision >= 0 ? 1 : 0) != 0, (Object)"precision must not be negative");
        this.precisionPattern = Pattern.compile(String.format("-?[0-9]*+((\\.[0-9]{0,%d})?)||(\\.)?", precision));
        this.precision = precision;
        return (T)((AbstractGuiNumberField)this.getThis());
    }

    @Override
    public T setMinValue(Double minValue) {
        this.minValue = minValue;
        return (T)((AbstractGuiNumberField)this.getThis());
    }

    @Override
    public T setMaxValue(Double maxValue) {
        this.maxValue = maxValue;
        return (T)((AbstractGuiNumberField)this.getThis());
    }

    @Override
    public T setMinValue(int minValue) {
        return (T)this.setMinValue(Double.valueOf(minValue));
    }

    @Override
    public T setMaxValue(int maxValue) {
        return (T)this.setMaxValue(Double.valueOf(maxValue));
    }

    private double clampToBounds() {
        double d = this.getDouble();
        if (this.getMinValue() != null && d < this.getMinValue()) {
            return this.getMinValue();
        }
        if (this.getMaxValue() != null && d > this.getMaxValue()) {
            return this.getMaxValue();
        }
        return d;
    }

    @Override
    protected void onFocusChanged(boolean focused) {
        this.setValue(this.clampToBounds());
        super.onFocusChanged(focused);
    }

    public Double getMinValue() {
        return this.minValue;
    }

    public Double getMaxValue() {
        return this.maxValue;
    }
}

