/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.element;

import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.element.AbstractGuiElement;
import de.johni0702.minecraft.gui.element.ComposedGuiElement;
import de.johni0702.minecraft.gui.element.GuiElement;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class AbstractComposedGuiElement<T extends AbstractComposedGuiElement<T>>
extends AbstractGuiElement<T>
implements ComposedGuiElement<T> {
    public AbstractComposedGuiElement() {
    }

    public AbstractComposedGuiElement(GuiContainer container) {
        super(container);
    }

    @Override
    public int getMaxLayer() {
        return this.getLayer() + this.getChildren().stream().mapToInt(e -> e instanceof ComposedGuiElement ? ((ComposedGuiElement)e).getMaxLayer() : e.getLayer()).max().orElse(0);
    }

    @Override
    public <C, R> R forEach(int layer, Class<C> ofType, BiFunction<ComposedGuiElement<?>, Integer, R> recurse, Function<C, R> function) {
        R result;
        if (ofType.isInstance(this) && this.getLayer() == layer && (result = function.apply(ofType.cast(this))) != null) {
            return result;
        }
        for (GuiElement element : this.getChildren()) {
            R result2 = null;
            if (element instanceof ComposedGuiElement) {
                ComposedGuiElement composed = (ComposedGuiElement)element;
                if (layer <= composed.getMaxLayer()) {
                    result2 = recurse.apply(composed, layer - composed.getLayer());
                }
            } else if (ofType.isInstance(element) && element.getLayer() == layer) {
                result2 = function.apply(ofType.cast(element));
            }
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }
}

