/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.container;

import de.johni0702.minecraft.gui.GuiRenderer;
import de.johni0702.minecraft.gui.MinecraftGuiRenderer;
import de.johni0702.minecraft.gui.OffsetGuiRenderer;
import de.johni0702.minecraft.gui.RenderInfo;
import de.johni0702.minecraft.gui.container.AbstractGuiContainer;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.element.GuiLabel;
import de.johni0702.minecraft.gui.function.Clickable;
import de.johni0702.minecraft.gui.function.Closeable;
import de.johni0702.minecraft.gui.function.Draggable;
import de.johni0702.minecraft.gui.function.Loadable;
import de.johni0702.minecraft.gui.function.Scrollable;
import de.johni0702.minecraft.gui.function.Tickable;
import de.johni0702.minecraft.gui.function.Typeable;
import de.johni0702.minecraft.gui.utils.MouseUtils;
import de.johni0702.minecraft.gui.utils.lwjgl.Dimension;
import de.johni0702.minecraft.gui.utils.lwjgl.Point;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadablePoint;
import de.johni0702.minecraft.gui.versions.MCVer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public abstract class AbstractGuiScreen<T extends AbstractGuiScreen<T>>
extends AbstractGuiContainer<T> {
    private final MinecraftGuiScreen wrapped = new MinecraftGuiScreen();
    private Dimension screenSize;
    private Background background = Background.DEFAULT;
    private boolean enabledRepeatedKeyEvents = true;
    private GuiLabel title;
    protected boolean suppressVanillaKeys;

    public Screen toMinecraft() {
        return this.wrapped;
    }

    @Override
    public void layout(ReadableDimension size, RenderInfo renderInfo) {
        GuiElement tooltip;
        if (size == null) {
            size = this.screenSize;
        }
        if (renderInfo.layer == 0 && this.title != null) {
            this.title.layout(this.title.getMinSize(), renderInfo);
        }
        super.layout(size, renderInfo);
        if (renderInfo.layer == this.getMaxLayer() && (tooltip = this.forEach(GuiElement.class, e -> e.getTooltip(renderInfo))) != null) {
            tooltip.layout(tooltip.getMinSize(), renderInfo);
        }
    }

    @Override
    public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
        GuiElement tooltip;
        if (renderInfo.layer == 0) {
            switch (this.background) {
                case NONE: {
                    break;
                }
                case DEFAULT: {
                    this.wrapped.m_280273_(renderer.getContext());
                    break;
                }
                case TRANSPARENT: {
                    int top = -1072689136;
                    int bottom = -804253680;
                    renderer.drawRect(0, 0, size.getWidth(), size.getHeight(), top, top, bottom, bottom);
                    break;
                }
                case DIRT: {
                    this.wrapped.m_280039_(renderer.getContext());
                }
            }
            if (this.title != null) {
                ReadableDimension titleSize = this.title.getMinSize();
                int x = this.screenSize.getWidth() / 2 - titleSize.getWidth() / 2;
                OffsetGuiRenderer eRenderer = new OffsetGuiRenderer(renderer, (ReadablePoint)new Point(x, 10), (ReadableDimension)new Dimension(0, 0));
                this.title.draw(eRenderer, titleSize, renderInfo);
            }
        }
        super.draw(renderer, size, renderInfo);
        if (renderInfo.layer == this.getMaxLayer() && (tooltip = this.forEach(GuiElement.class, e -> e.getTooltip(renderInfo))) != null) {
            ReadableDimension tooltipSize = tooltip.getMinSize();
            int x = renderInfo.mouseX + 8 + tooltipSize.getWidth() < this.screenSize.getWidth() ? renderInfo.mouseX + 8 : this.screenSize.getWidth() - tooltipSize.getWidth() - 1;
            int y = renderInfo.mouseY + 8 + tooltipSize.getHeight() < this.screenSize.getHeight() ? renderInfo.mouseY + 8 : this.screenSize.getHeight() - tooltipSize.getHeight() - 1;
            Point position = new Point(x, y);
            try {
                OffsetGuiRenderer eRenderer = new OffsetGuiRenderer(renderer, (ReadablePoint)position, tooltipSize);
                tooltip.draw(eRenderer, tooltipSize, renderInfo);
            }
            catch (Exception ex) {
                CrashReport crashReport = CrashReport.m_127521_((Throwable)ex, (String)"Rendering Gui Tooltip");
                renderInfo.addTo(crashReport);
                CrashReportCategory category = crashReport.m_127514_("Gui container details");
                MCVer.addDetail(category, "Container", this::toString);
                MCVer.addDetail(category, "Width", () -> "" + size.getWidth());
                MCVer.addDetail(category, "Height", () -> "" + size.getHeight());
                category = crashReport.m_127514_("Tooltip details");
                MCVer.addDetail(category, "Element", tooltip::toString);
                MCVer.addDetail(category, "Position", ((ReadablePoint)position)::toString);
                MCVer.addDetail(category, "Size", tooltipSize::toString);
                throw new ReportedException(crashReport);
            }
        }
    }

    @Override
    public ReadableDimension getMinSize() {
        return this.screenSize;
    }

    @Override
    public ReadableDimension getMaxSize() {
        return this.screenSize;
    }

    public void setEnabledRepeatedKeyEvents(boolean enableRepeatKeyEvents) {
        this.enabledRepeatedKeyEvents = enableRepeatKeyEvents;
        if (this.wrapped.active) {
            MCVer.Keyboard.enableRepeatEvents(enableRepeatKeyEvents);
        }
    }

    public void display() {
        this.getMinecraft().m_91152_(this.toMinecraft());
    }

    public Background getBackground() {
        return this.background;
    }

    public boolean isEnabledRepeatedKeyEvents() {
        return this.enabledRepeatedKeyEvents;
    }

    public GuiLabel getTitle() {
        return this.title;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public void setTitle(GuiLabel title) {
        this.title = title;
    }

    protected class MinecraftGuiScreen
    extends Screen {
        private boolean active;

        protected MinecraftGuiScreen() {
            super(null);
        }

        public Component m_96636_() {
            GuiLabel title = AbstractGuiScreen.this.title;
            return MCVer.literalText(title == null ? "" : title.getText());
        }

        public void m_88315_(GuiGraphics stack, int mouseX, int mouseY, float partialTicks) {
            int layers = AbstractGuiScreen.this.getMaxLayer();
            RenderInfo renderInfo = new RenderInfo(partialTicks, mouseX, mouseY, 0);
            for (int layer = 0; layer <= layers; ++layer) {
                AbstractGuiScreen.this.layout((ReadableDimension)AbstractGuiScreen.this.screenSize, renderInfo.layer(layer));
            }
            MinecraftGuiRenderer renderer = new MinecraftGuiRenderer(stack);
            for (int layer = 0; layer <= layers; ++layer) {
                AbstractGuiScreen.this.draw(renderer, (ReadableDimension)AbstractGuiScreen.this.screenSize, renderInfo.layer(layer));
            }
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            boolean shiftDown;
            boolean ctrlDown;
            Point mouse = MouseUtils.getMousePos();
            if (!AbstractGuiScreen.this.invokeHandlers(Typeable.class, arg_0 -> MinecraftGuiScreen.lambda$keyPressed$0(mouse, keyCode, ctrlDown = MinecraftGuiScreen.m_96637_(), shiftDown = MinecraftGuiScreen.m_96638_(), arg_0))) {
                if (AbstractGuiScreen.this.suppressVanillaKeys) {
                    return false;
                }
                return super.m_7933_(keyCode, scanCode, modifiers);
            }
            return true;
        }

        public boolean m_5534_(char keyChar, int scanCode) {
            boolean shiftDown;
            boolean ctrlDown;
            Point mouse = MouseUtils.getMousePos();
            if (!AbstractGuiScreen.this.invokeHandlers(Typeable.class, arg_0 -> MinecraftGuiScreen.lambda$charTyped$1(mouse, keyChar, ctrlDown = MinecraftGuiScreen.m_96637_(), shiftDown = MinecraftGuiScreen.m_96638_(), arg_0))) {
                if (AbstractGuiScreen.this.suppressVanillaKeys) {
                    return false;
                }
                return super.m_5534_(keyChar, scanCode);
            }
            return true;
        }

        public boolean m_6375_(double mouseXD, double mouseYD, int mouseButton) {
            int mouseX = (int)Math.round(mouseXD);
            int mouseY = (int)Math.round(mouseYD);
            return AbstractGuiScreen.this.invokeHandlers(Clickable.class, e -> e.mouseClick((ReadablePoint)new Point(mouseX, mouseY), mouseButton));
        }

        public boolean m_6348_(double mouseXD, double mouseYD, int mouseButton) {
            int mouseX = (int)Math.round(mouseXD);
            int mouseY = (int)Math.round(mouseYD);
            return AbstractGuiScreen.this.invokeHandlers(Draggable.class, e -> e.mouseRelease((ReadablePoint)new Point(mouseX, mouseY), mouseButton));
        }

        public boolean m_7979_(double mouseXD, double mouseYD, int mouseButton, double deltaX, double deltaY) {
            int mouseX = (int)Math.round(mouseXD);
            int mouseY = (int)Math.round(mouseYD);
            long timeSinceLastClick = 0L;
            return AbstractGuiScreen.this.invokeHandlers(Draggable.class, e -> e.mouseDrag((ReadablePoint)new Point(mouseX, mouseY), mouseButton, timeSinceLastClick));
        }

        public void m_86600_() {
            AbstractGuiScreen.this.invokeAll(Tickable.class, Tickable::tick);
        }

        public boolean m_6050_(double mouseX, double mouseY, double dWheel) {
            Point mouse = new Point((int)mouseX, (int)mouseY);
            int wheel = (int)(dWheel * 120.0);
            return AbstractGuiScreen.this.invokeHandlers(Scrollable.class, e -> e.scroll((ReadablePoint)mouse, wheel));
        }

        public void m_7861_() {
            AbstractGuiScreen.this.invokeAll(Closeable.class, Closeable::close);
            this.active = false;
            if (AbstractGuiScreen.this.enabledRepeatedKeyEvents) {
                MCVer.Keyboard.enableRepeatEvents(false);
            }
        }

        public void m_7856_() {
            this.active = false;
            if (AbstractGuiScreen.this.enabledRepeatedKeyEvents) {
                MCVer.Keyboard.enableRepeatEvents(true);
            }
            AbstractGuiScreen.this.screenSize = new Dimension(this.f_96543_, this.f_96544_);
            AbstractGuiScreen.this.invokeAll(Loadable.class, Loadable::load);
        }

        public T getWrapper() {
            return (AbstractGuiScreen)AbstractGuiScreen.this.getThis();
        }

        private static /* synthetic */ Boolean lambda$charTyped$1(Point mouse, char keyChar, boolean ctrlDown, boolean shiftDown, Typeable e) {
            return e.typeKey((ReadablePoint)mouse, 0, keyChar, ctrlDown, shiftDown);
        }

        private static /* synthetic */ Boolean lambda$keyPressed$0(Point mouse, int keyCode, boolean ctrlDown, boolean shiftDown, Typeable e) {
            return e.typeKey((ReadablePoint)mouse, keyCode, '\u0000', ctrlDown, shiftDown);
        }
    }

    public static enum Background {
        NONE,
        DEFAULT,
        TRANSPARENT,
        DIRT;

    }
}

