/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.stream;

import com.replaymod.replaystudio.PacketData;
import com.replaymod.replaystudio.filter.StreamFilter;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.stream.PacketStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class IteratorStream
implements PacketStream {
    private final ListIterator<PacketData> iterator;
    private final List<PacketData> added = new ArrayList<PacketData>();
    private final PacketStream.FilterInfo filter;
    private boolean filterActive;
    private boolean processing;
    private long lastTimestamp = -1L;

    public IteratorStream(ListIterator<PacketData> iterator, StreamFilter filter) {
        this(iterator, new PacketStream.FilterInfo(filter, -1L, -1L));
    }

    public IteratorStream(ListIterator<PacketData> iterator, PacketStream.FilterInfo filter) {
        this.iterator = iterator;
        this.filter = filter;
    }

    @Override
    public void insert(PacketData packet) {
        if (this.processing) {
            this.added.add(packet);
        } else {
            this.iterator.add(packet);
        }
        if (packet.getTime() > this.lastTimestamp) {
            this.lastTimestamp = packet.getTime();
        }
    }

    @Override
    public void insert(long time, Packet packet) {
        this.insert(new PacketData(time, packet));
    }

    @Override
    public void addFilter(StreamFilter filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addFilter(StreamFilter filter, long from, long to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeFilter(StreamFilter filter) {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public PacketData next() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<PacketStream.FilterInfo> getFilters() {
        return Arrays.asList(this.filter);
    }

    public void processNext() throws IOException {
        this.processing = true;
        PacketData next = this.iterator.next();
        boolean keep = true;
        if (!(this.filter.getFrom() != -1L && this.filter.getFrom() > next.getTime() || this.filter.getTo() != -1L && this.filter.getFrom() < next.getTime())) {
            if (!this.filterActive) {
                this.filter.getFilter().onStart(this);
                this.filterActive = true;
            }
            keep = this.filter.getFilter().onPacket(this, next);
        } else if (this.filterActive) {
            this.filter.getFilter().onEnd(this, this.lastTimestamp);
            this.filterActive = false;
        }
        if (!keep) {
            this.iterator.remove();
            next.getPacket().getBuf().release();
            if (this.lastTimestamp == -1L) {
                this.lastTimestamp = next.getTime();
            }
        } else if (next.getTime() > this.lastTimestamp) {
            this.lastTimestamp = next.getTime();
        }
        for (PacketData data : this.added) {
            this.iterator.add(data);
        }
        this.added.clear();
        this.processing = false;
    }

    public void processAll() throws IOException {
        while (this.hasNext()) {
            this.processNext();
        }
        this.end();
    }

    @Override
    public void start() {
    }

    @Override
    public List<PacketData> end() throws IOException {
        if (this.filterActive) {
            this.filterActive = false;
            this.filter.getFilter().onEnd(this, this.lastTimestamp);
        }
        return Collections.unmodifiableList(this.added);
    }
}

