/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.rar.containers;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import com.replaymod.replaystudio.rar.PacketSink;
import com.replaymod.replaystudio.rar.containers.FullStateTree;
import com.replaymod.replaystudio.util.Utils;
import java.io.IOException;

public class PacketStateTree
extends FullStateTree<Packet> {
    private final PacketTypeRegistry registry;

    public PacketStateTree(PacketTypeRegistry registry, int index) {
        super(index);
        this.registry = registry;
    }

    @Override
    protected Packet read(NetInput in) throws IOException {
        return Utils.readCompressedPacket(this.registry, in);
    }

    @Override
    protected void discard(Packet value) {
        value.release();
    }

    @Override
    protected void apply(PacketSink sink, Packet value) throws IOException {
        sink.accept(value.retain());
    }

    public static class Builder
    extends FullStateTree.Builder<Packet> {
        @Override
        protected void write(NetOutput out, Packet value, int time) throws IOException {
            Utils.writeCompressedPacket(out, value);
            value.release();
        }

        @Override
        protected void discard(Packet value) {
            value.release();
        }
    }
}

