/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.protocol.packets;

import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketType;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import java.io.IOException;

public class PacketPlayerPositionRotation {
    public double x;
    public double y;
    public double z;
    public float yaw;
    public float pitch;
    public int flags;
    public int teleportId;
    public boolean dismount;

    public static PacketPlayerPositionRotation read(Packet packet) throws IOException {
        try (Packet.Reader in = packet.reader();){
            PacketPlayerPositionRotation result = new PacketPlayerPositionRotation();
            result.read(packet, in);
            PacketPlayerPositionRotation packetPlayerPositionRotation = result;
            return packetPlayerPositionRotation;
        }
    }

    private void read(Packet packet, Packet.Reader in) throws IOException {
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
        this.yaw = in.readFloat();
        this.pitch = in.readFloat();
        this.flags = in.readByte();
        if (packet.atLeast(ProtocolVersion.v1_9)) {
            this.teleportId = in.readVarInt();
        }
        if (packet.atLeast(ProtocolVersion.v1_17) && packet.atMost(ProtocolVersion.v1_19_3)) {
            this.dismount = in.readBoolean();
        }
    }

    public Packet write(PacketTypeRegistry registry) throws IOException {
        Packet packet = new Packet(registry, PacketType.PlayerPositionRotation);
        try (Packet.Writer out = packet.overwrite();){
            out.writeDouble(this.x);
            out.writeDouble(this.y);
            out.writeDouble(this.z);
            out.writeFloat(this.yaw);
            out.writeFloat(this.pitch);
            out.writeByte(this.flags);
            if (packet.atLeast(ProtocolVersion.v1_9)) {
                out.writeVarInt(this.teleportId);
            }
            if (packet.atLeast(ProtocolVersion.v1_17) && packet.atMost(ProtocolVersion.v1_19_3)) {
                out.writeBoolean(this.dismount);
            }
        }
        return packet;
    }
}

