/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.protocol.packets;

import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketType;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import com.replaymod.replaystudio.protocol.data.StringOrNbtText;
import com.replaymod.replaystudio.util.Property;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class PacketPlayerListEntry {
    private UUID uuid;
    private String name;
    private List<Property> properties;
    private StringOrNbtText displayName;
    private int gamemode;
    private boolean listed;
    private int latency;
    private SigData sigData;

    public static PacketPlayerListEntry updateChatKey(PacketPlayerListEntry entry, SigData sigData) {
        entry = new PacketPlayerListEntry(entry);
        entry.sigData = sigData;
        return entry;
    }

    public static PacketPlayerListEntry updateGamemode(PacketPlayerListEntry entry, int gamemode) {
        entry = new PacketPlayerListEntry(entry);
        entry.gamemode = gamemode;
        return entry;
    }

    public static PacketPlayerListEntry updateListed(PacketPlayerListEntry entry, boolean listed) {
        entry = new PacketPlayerListEntry(entry);
        entry.listed = listed;
        return entry;
    }

    public static PacketPlayerListEntry updateLatency(PacketPlayerListEntry entry, int latency) {
        entry = new PacketPlayerListEntry(entry);
        entry.latency = latency;
        return entry;
    }

    public static PacketPlayerListEntry updateDisplayName(PacketPlayerListEntry entry, StringOrNbtText displayName) {
        entry = new PacketPlayerListEntry(entry);
        entry.displayName = displayName;
        return entry;
    }

    public static Set<Action> getActions(Packet packet) throws IOException {
        try (Packet.Reader in = packet.reader();){
            if (packet.atLeast(ProtocolVersion.v1_19_3)) {
                if (packet.getType() == PacketType.PlayerListEntryRemove) {
                    Set<Action> set = Collections.singleton(Action.REMOVE);
                    return set;
                }
                EnumSet<Action> enumSet = Action.readSet(in, Action.VALUES_1_19_3);
                return enumSet;
            }
            if (packet.atLeast(ProtocolVersion.v1_8)) {
                Set<Action> set = Collections.singleton(Action.VALUES_1_8.get(in.readVarInt()));
                return set;
            }
            in.readString();
            if (in.readBoolean()) {
                Set<Action> set = Collections.singleton(Action.ADD);
                return set;
            }
            Set<Action> set = Collections.singleton(Action.REMOVE);
            return set;
        }
    }

    public static List<PacketPlayerListEntry> read(Packet packet) throws IOException {
        try (Packet.Reader in = packet.reader();){
            if (packet.atLeast(ProtocolVersion.v1_8)) {
                Set<Action> actions = packet.getType() == PacketType.PlayerListEntryRemove ? Collections.singleton(Action.REMOVE) : (packet.atLeast(ProtocolVersion.v1_19_3) ? Action.readSet(in, Action.VALUES_1_19_3) : Collections.singleton(Action.VALUES_1_8.get(in.readVarInt())));
                int count = in.readVarInt();
                ArrayList<PacketPlayerListEntry> result = new ArrayList<PacketPlayerListEntry>(count);
                for (int i = 0; i < count; ++i) {
                    PacketPlayerListEntry entry = new PacketPlayerListEntry();
                    entry.uuid = in.readUUID();
                    for (Action action : actions) {
                        switch (action) {
                            case ADD: {
                                entry.name = in.readString();
                                entry.properties = in.readList(() -> Property.read(in));
                                if (!packet.olderThan(ProtocolVersion.v1_19_3)) break;
                                entry.gamemode = in.readVarInt();
                                entry.latency = in.readVarInt();
                                if (in.readBoolean()) {
                                    entry.displayName = in.readText();
                                }
                                if (!packet.atLeast(ProtocolVersion.v1_19) || !in.readBoolean()) break;
                                entry.sigData = SigData.read(packet, in);
                                break;
                            }
                            case CHAT_KEY: {
                                if (!in.readBoolean()) break;
                                entry.sigData = SigData.read(packet, in);
                                break;
                            }
                            case GAMEMODE: {
                                entry.gamemode = in.readVarInt();
                                break;
                            }
                            case LISTED: {
                                entry.listed = in.readBoolean();
                                break;
                            }
                            case LATENCY: {
                                entry.latency = in.readVarInt();
                                break;
                            }
                            case DISPLAY_NAME: {
                                if (!in.readBoolean()) break;
                                entry.displayName = in.readText();
                            }
                        }
                    }
                    result.add(entry);
                }
                ArrayList<PacketPlayerListEntry> arrayList = result;
                return arrayList;
            }
            PacketPlayerListEntry entry = new PacketPlayerListEntry();
            entry.name = in.readString();
            in.readBoolean();
            entry.latency = in.readShort();
            List<PacketPlayerListEntry> list = Collections.singletonList(entry);
            return list;
        }
    }

    public static Packet write(PacketTypeRegistry registry, Set<Action> actions, PacketPlayerListEntry entry) throws IOException {
        return PacketPlayerListEntry.write(registry, actions, Collections.singletonList(entry)).get(0);
    }

    public static List<Packet> write(PacketTypeRegistry registry, Set<Action> actions, List<PacketPlayerListEntry> entries) throws IOException {
        if (registry.atLeast(ProtocolVersion.v1_8)) {
            return Collections.singletonList(PacketPlayerListEntry.write_1_8(registry, actions, entries));
        }
        ArrayList<Packet> packets = new ArrayList<Packet>(entries.size());
        for (PacketPlayerListEntry it : entries) {
            packets.add(PacketPlayerListEntry.write_1_7(registry, actions.iterator().next(), it));
        }
        return packets;
    }

    private static Packet write_1_8(PacketTypeRegistry registry, Set<Action> actions, List<PacketPlayerListEntry> entries) throws IOException {
        if (registry.atLeast(ProtocolVersion.v1_19_3) && actions.contains((Object)Action.REMOVE)) {
            Packet packet = new Packet(registry, PacketType.PlayerListEntry);
            try (Packet.Writer out = packet.overwrite();){
                out.writeList(entries, entry -> out.writeUUID(entry.uuid));
            }
            return packet;
        }
        Packet packet = new Packet(registry, PacketType.PlayerListEntry);
        try (Packet.Writer out = packet.overwrite();){
            if (packet.atLeast(ProtocolVersion.v1_19_3)) {
                Action.writeSet(out, actions, Action.VALUES_1_19_3);
            } else {
                out.writeVarInt(Action.VALUES_1_8.indexOf((Object)actions.iterator().next()));
            }
            out.writeVarInt(entries.size());
            for (PacketPlayerListEntry entry2 : entries) {
                out.writeUUID(entry2.uuid);
                for (Action action : actions) {
                    switch (action) {
                        case ADD: {
                            out.writeString(entry2.name);
                            out.writeList(entry2.properties, it -> it.write(out));
                            if (!packet.olderThan(ProtocolVersion.v1_19_3)) break;
                            out.writeVarInt(entry2.gamemode);
                            out.writeVarInt(entry2.latency);
                            if (entry2.displayName != null) {
                                out.writeBoolean(true);
                                out.writeText(entry2.displayName);
                            } else {
                                out.writeBoolean(false);
                            }
                            if (!packet.atLeast(ProtocolVersion.v1_19)) break;
                            if (entry2.sigData != null) {
                                out.writeBoolean(true);
                                entry2.sigData.write(packet, out);
                                break;
                            }
                            out.writeBoolean(false);
                            break;
                        }
                        case CHAT_KEY: {
                            if (entry2.sigData != null) {
                                out.writeBoolean(true);
                                entry2.sigData.write(packet, out);
                                break;
                            }
                            out.writeBoolean(false);
                            break;
                        }
                        case GAMEMODE: {
                            out.writeVarInt(entry2.gamemode);
                            break;
                        }
                        case LISTED: {
                            out.writeBoolean(entry2.listed);
                            break;
                        }
                        case LATENCY: {
                            out.writeVarInt(entry2.latency);
                            break;
                        }
                        case DISPLAY_NAME: {
                            if (entry2.displayName != null) {
                                out.writeBoolean(true);
                                out.writeText(entry2.displayName);
                                break;
                            }
                            out.writeBoolean(false);
                        }
                    }
                }
            }
        }
        return packet;
    }

    private static Packet write_1_7(PacketTypeRegistry registry, Action action, PacketPlayerListEntry entry) throws IOException {
        Packet packet = new Packet(registry, PacketType.PlayerListEntry);
        try (Packet.Writer out = packet.overwrite();){
            out.writeString(entry.name);
            if (action == Action.ADD) {
                out.writeBoolean(true);
            } else if (action == Action.REMOVE) {
                out.writeBoolean(false);
            } else {
                throw new IllegalStateException("1.7 only supports ADD or REMOVE");
            }
            out.writeShort(entry.latency);
        }
        return packet;
    }

    private PacketPlayerListEntry() {
    }

    private PacketPlayerListEntry(PacketPlayerListEntry from) {
        this.uuid = from.uuid;
        this.name = from.name;
        this.properties = from.properties;
        this.displayName = from.displayName;
        this.gamemode = from.gamemode;
        this.listed = from.listed;
        this.latency = from.latency;
        this.sigData = from.sigData;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public StringOrNbtText getDisplayName() {
        return this.displayName;
    }

    public int getGamemode() {
        return this.gamemode;
    }

    public boolean isListed() {
        return this.listed;
    }

    public int getLatency() {
        return this.latency;
    }

    public SigData getSigData() {
        return this.sigData;
    }

    public String getId() {
        return this.uuid != null ? this.uuid.toString() : this.name;
    }

    public static class SigData {
        private final UUID sessionUuid;
        private final long expireTimestamp;
        private final byte[] publicKey;
        private final byte[] signature;

        public SigData(UUID sessionUuid, long expireTimestamp, byte[] publicKey, byte[] signature) {
            this.sessionUuid = sessionUuid;
            this.expireTimestamp = expireTimestamp;
            this.publicKey = publicKey;
            this.signature = signature;
        }

        public static SigData read(Packet packet, Packet.Reader in) throws IOException {
            UUID sessionUuid = packet.atLeast(ProtocolVersion.v1_19_3) ? in.readUUID() : null;
            long expireTimestamp = in.readLong();
            byte[] publicKey = in.readBytes(in.readVarInt());
            byte[] signature = in.readBytes(in.readVarInt());
            return new SigData(sessionUuid, expireTimestamp, publicKey, signature);
        }

        public void write(Packet packet, Packet.Writer out) throws IOException {
            if (packet.atLeast(ProtocolVersion.v1_19_3)) {
                out.writeUUID(this.sessionUuid);
            }
            out.writeLong(this.expireTimestamp);
            out.writeVarInt(this.publicKey.length);
            out.writeBytes(this.publicKey);
            out.writeVarInt(this.signature.length);
            out.writeBytes(this.signature);
        }
    }

    public static enum Action {
        ADD,
        CHAT_KEY,
        GAMEMODE,
        LISTED,
        LATENCY,
        DISPLAY_NAME,
        REMOVE;

        private static final List<Action> VALUES_1_19_3;
        private static final List<Action> VALUES_1_8;
        private static final List<Action> VALUES_1_7;

        public static Set<Action> init(PacketTypeRegistry registry) {
            if (registry.atLeast(ProtocolVersion.v1_19_3)) {
                return EnumSet.copyOf(VALUES_1_19_3);
            }
            return EnumSet.of(ADD);
        }

        public static List<Action> values(PacketTypeRegistry registry) {
            if (registry.atLeast(ProtocolVersion.v1_19_3)) {
                return VALUES_1_19_3;
            }
            if (registry.atLeast(ProtocolVersion.v1_8)) {
                return VALUES_1_8;
            }
            return VALUES_1_7;
        }

        public static EnumSet<Action> readSet(Packet.Reader in, List<Action> values) throws IOException {
            BitSet bitSet = BitSet.valueOf(in.readBytes((values.size() + 7) / 8));
            EnumSet<Action> set = EnumSet.noneOf(Action.class);
            for (int i = 0; i < values.size(); ++i) {
                if (!bitSet.get(i)) continue;
                set.add(values.get(i));
            }
            return set;
        }

        public static void writeSet(Packet.Writer out, Set<Action> actions, List<Action> values) throws IOException {
            BitSet bitSet = new BitSet();
            for (int i = 0; i < values.size(); ++i) {
                if (!actions.contains((Object)values.get(i))) continue;
                bitSet.set(i);
            }
            out.writeBytes(Arrays.copyOf(bitSet.toByteArray(), (values.size() + 7) / 8));
        }

        static {
            VALUES_1_19_3 = Arrays.asList(ADD, CHAT_KEY, GAMEMODE, LISTED, LATENCY, DISPLAY_NAME);
            VALUES_1_8 = Arrays.asList(ADD, GAMEMODE, LATENCY, DISPLAY_NAME, REMOVE);
            VALUES_1_7 = Arrays.asList(ADD, REMOVE);
        }
    }
}

