/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.protocol.packets;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketType;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import com.replaymod.replaystudio.protocol.registry.DimensionType;
import com.replaymod.replaystudio.util.IGlobalPosition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PacketJoinGame {
    public int entityId;
    public boolean hardcore;
    public byte gameMode;
    public byte prevGameMode;
    public List<String> dimensions;
    public CompoundTag registries;
    public DimensionType dimensionType;
    public String dimension;
    public long seed;
    public int difficulty;
    public int maxPlayers;
    public int viewDistance;
    public int simulationDistance;
    public boolean reducedDebugInfo;
    public boolean respawnScreen;
    public boolean limitedCrafting;
    public boolean debugWorld;
    public boolean flatWorld;
    public IGlobalPosition lastDeathPosition;
    public int portalCooldown;

    public PacketJoinGame() {
    }

    public PacketJoinGame(PacketJoinGame other) {
        this.entityId = other.entityId;
        this.hardcore = other.hardcore;
        this.gameMode = other.gameMode;
        this.prevGameMode = other.prevGameMode;
        this.dimensions = other.dimensions;
        this.registries = other.registries;
        this.dimensionType = other.dimensionType;
        this.dimension = other.dimension;
        this.seed = other.seed;
        this.difficulty = other.difficulty;
        this.maxPlayers = other.maxPlayers;
        this.viewDistance = other.viewDistance;
        this.simulationDistance = other.simulationDistance;
        this.reducedDebugInfo = other.reducedDebugInfo;
        this.respawnScreen = other.respawnScreen;
        this.limitedCrafting = other.limitedCrafting;
        this.debugWorld = other.debugWorld;
        this.flatWorld = other.flatWorld;
        this.lastDeathPosition = other.lastDeathPosition;
        this.portalCooldown = other.portalCooldown;
    }

    public static PacketJoinGame read(Packet packet, CompoundTag registries) throws IOException {
        try (Packet.Reader in = packet.reader();){
            PacketJoinGame joinGame = new PacketJoinGame();
            joinGame.registries = registries;
            joinGame.read(packet, in);
            PacketJoinGame packetJoinGame = joinGame;
            return packetJoinGame;
        }
    }

    public void read(Packet packet, Packet.Reader in) throws IOException {
        this.entityId = in.readInt();
        if (packet.atLeast(ProtocolVersion.v1_16_2)) {
            this.hardcore = in.readBoolean();
            if (packet.olderThan(ProtocolVersion.v1_20_2)) {
                this.gameMode = in.readByte();
            }
        } else {
            byte flags = in.readByte();
            this.hardcore = (flags & 8) != 0;
            this.gameMode = (byte)(flags & 0xFFFFFFF7);
        }
        if (packet.atLeast(ProtocolVersion.v1_16)) {
            if (packet.olderThan(ProtocolVersion.v1_20_2)) {
                this.prevGameMode = in.readByte();
            }
            int count = in.readVarInt();
            this.dimensions = new ArrayList<String>(count);
            for (int i = 0; i < count; ++i) {
                this.dimensions.add(in.readString());
            }
            if (packet.olderThan(ProtocolVersion.v1_20_2)) {
                this.registries = in.readNBT();
                this.dimensionType = packet.atLeast(ProtocolVersion.v1_19) ? PacketJoinGame.getDimensionType(this.registries, in.readString()) : (packet.atLeast(ProtocolVersion.v1_16_2) ? new DimensionType(in.readNBT()) : new DimensionType(in.readString()));
            }
        }
        if (packet.olderThan(ProtocolVersion.v1_20_2)) {
            this.dimension = packet.atLeast(ProtocolVersion.v1_16) ? in.readString() : (packet.atLeast(ProtocolVersion.v1_9_1) ? String.valueOf(in.readInt()) : String.valueOf(in.readByte()));
            if (packet.atLeast(ProtocolVersion.v1_15)) {
                this.seed = in.readLong();
            }
        }
        if (packet.olderThan(ProtocolVersion.v1_14)) {
            this.difficulty = in.readByte();
        }
        this.maxPlayers = packet.atLeast(ProtocolVersion.v1_16_2) ? in.readVarInt() : (int)in.readByte();
        if (packet.olderThan(ProtocolVersion.v1_16)) {
            this.dimensionType = new DimensionType(in.readString());
        }
        if (packet.atLeast(ProtocolVersion.v1_14)) {
            this.viewDistance = in.readVarInt();
        }
        if (packet.atLeast(ProtocolVersion.v1_18)) {
            this.simulationDistance = in.readVarInt();
        }
        if (packet.atLeast(ProtocolVersion.v1_8)) {
            this.reducedDebugInfo = in.readBoolean();
        }
        if (packet.atLeast(ProtocolVersion.v1_15)) {
            this.respawnScreen = in.readBoolean();
        }
        if (packet.atLeast(ProtocolVersion.v1_20_2)) {
            this.limitedCrafting = in.readBoolean();
            this.dimensionType = PacketJoinGame.getDimensionType(this.registries, in.readString());
            this.dimension = in.readString();
            this.seed = in.readLong();
            this.gameMode = in.readByte();
            this.prevGameMode = in.readByte();
        }
        if (packet.atLeast(ProtocolVersion.v1_16)) {
            this.debugWorld = in.readBoolean();
            this.flatWorld = in.readBoolean();
        }
        if (packet.atLeast(ProtocolVersion.v1_19) && in.readBoolean()) {
            this.lastDeathPosition = in.readGlobalPosition();
        }
        if (packet.atLeast(ProtocolVersion.v1_20)) {
            this.portalCooldown = in.readVarInt();
        }
    }

    public Packet write(PacketTypeRegistry registry) throws IOException {
        Packet packet = new Packet(registry, PacketType.JoinGame);
        try (Packet.Writer out = packet.overwrite();){
            this.write(packet, out);
        }
        return packet;
    }

    public void write(Packet packet, Packet.Writer out) throws IOException {
        out.writeInt(this.entityId);
        if (packet.atLeast(ProtocolVersion.v1_16_2)) {
            out.writeBoolean(this.hardcore);
            if (packet.olderThan(ProtocolVersion.v1_20_2)) {
                out.writeByte(this.gameMode);
            }
        } else {
            out.writeByte((this.hardcore ? 8 : 0) | this.gameMode);
        }
        if (packet.atLeast(ProtocolVersion.v1_16)) {
            if (packet.olderThan(ProtocolVersion.v1_20_2)) {
                out.writeByte(this.prevGameMode);
            }
            out.writeVarInt(this.dimensions.size());
            for (String dimension : this.dimensions) {
                out.writeString(dimension);
            }
            if (packet.olderThan(ProtocolVersion.v1_20_2)) {
                out.writeNBT(this.registries);
                if (packet.atLeast(ProtocolVersion.v1_19)) {
                    out.writeString(this.dimensionType.getName());
                } else if (packet.atLeast(ProtocolVersion.v1_16_2)) {
                    out.writeNBT(this.dimensionType.getTag());
                } else {
                    out.writeString(this.dimensionType.getName());
                }
            }
        }
        if (packet.olderThan(ProtocolVersion.v1_20_2)) {
            if (packet.atLeast(ProtocolVersion.v1_16)) {
                out.writeString(this.dimension);
            } else if (packet.atLeast(ProtocolVersion.v1_9_1)) {
                out.writeInt(Integer.parseInt(this.dimension));
            } else {
                out.writeByte(Integer.parseInt(this.dimension));
            }
            if (packet.atLeast(ProtocolVersion.v1_15)) {
                out.writeLong(this.seed);
            }
        }
        if (packet.olderThan(ProtocolVersion.v1_14)) {
            out.writeByte(this.difficulty);
        }
        if (packet.atLeast(ProtocolVersion.v1_16_2)) {
            out.writeVarInt(this.maxPlayers);
        } else {
            out.writeByte(this.maxPlayers);
        }
        if (packet.olderThan(ProtocolVersion.v1_16)) {
            out.writeString(this.dimensionType.getName());
        }
        if (packet.atLeast(ProtocolVersion.v1_14)) {
            out.writeVarInt(this.viewDistance);
        }
        if (packet.atLeast(ProtocolVersion.v1_18)) {
            out.writeVarInt(this.simulationDistance);
        }
        if (packet.atLeast(ProtocolVersion.v1_8)) {
            out.writeBoolean(this.reducedDebugInfo);
        }
        if (packet.atLeast(ProtocolVersion.v1_15)) {
            out.writeBoolean(this.respawnScreen);
        }
        if (packet.atLeast(ProtocolVersion.v1_20_2)) {
            out.writeBoolean(this.limitedCrafting);
            out.writeString(this.dimensionType.getName());
            out.writeString(this.dimension);
            out.writeLong(this.seed);
            out.writeByte(this.gameMode);
            out.writeByte(this.prevGameMode);
        }
        if (packet.atLeast(ProtocolVersion.v1_16)) {
            out.writeBoolean(this.debugWorld);
            out.writeBoolean(this.flatWorld);
        }
        if (packet.atLeast(ProtocolVersion.v1_19)) {
            if (this.lastDeathPosition != null) {
                out.writeBoolean(true);
                out.writeGlobalPosition(this.lastDeathPosition);
            } else {
                out.writeBoolean(false);
            }
        }
        if (packet.atLeast(ProtocolVersion.v1_20)) {
            out.writeVarInt(this.portalCooldown);
        }
    }

    public static ListTag getRegistry(CompoundTag registries, String id) {
        if (registries == null) {
            return null;
        }
        CompoundTag entry = (CompoundTag)registries.get(id);
        if (entry == null) {
            return null;
        }
        return (ListTag)entry.get("value");
    }

    public static CompoundTag getRegistryEntry(CompoundTag registries, String registryId, String entryId) {
        ListTag entries = PacketJoinGame.getRegistry(registries, registryId);
        if (entries == null) {
            return null;
        }
        for (Tag entry : entries) {
            StringTag name = (StringTag)((CompoundTag)entry).get("name");
            if (name == null || !name.getValue().equals(entryId)) continue;
            return (CompoundTag)((CompoundTag)entry).get("element");
        }
        return null;
    }

    public static DimensionType getDimensionType(CompoundTag registries, String id) {
        CompoundTag tag = PacketJoinGame.getRegistryEntry(registries, "minecraft:dimension_type", id);
        if (tag == null) {
            tag = new CompoundTag();
        }
        return new DimensionType(tag, id);
    }
}

