/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.protocol.packets;

import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketType;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import com.replaymod.replaystudio.util.DPosition;
import java.io.IOException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class PacketEntityMovement {
    public static Triple<DPosition, Pair<Float, Float>, Boolean> getMovement(Packet packet) throws IOException {
        PacketType type = packet.getType();
        boolean hasPos = type == PacketType.EntityPosition || type == PacketType.EntityPositionRotation;
        boolean hasRot = type == PacketType.EntityRotation || type == PacketType.EntityPositionRotation;
        try (Packet.Reader in = packet.reader();){
            if (packet.atLeast(ProtocolVersion.v1_8)) {
                in.readVarInt();
            } else {
                in.readInt();
            }
            DPosition pos = null;
            if (hasPos) {
                pos = packet.atLeast(ProtocolVersion.v1_9) ? new DPosition((double)in.readShort() / 4096.0, (double)in.readShort() / 4096.0, (double)in.readShort() / 4096.0) : new DPosition((double)in.readByte() / 32.0, (double)in.readByte() / 32.0, (double)in.readByte() / 32.0);
            }
            Pair yawPitch = null;
            if (hasRot) {
                yawPitch = Pair.of((Object)Float.valueOf((float)in.readByte() / 256.0f * 360.0f), (Object)Float.valueOf((float)in.readByte() / 256.0f * 360.0f));
            }
            boolean onGround = true;
            if (packet.atLeast(ProtocolVersion.v1_8) && (hasPos || hasRot)) {
                onGround = in.readBoolean();
            }
            Triple triple = Triple.of(pos, yawPitch, (Object)onGround);
            return triple;
        }
    }

    public static Packet write(PacketTypeRegistry registry, int entityId, DPosition deltaPos, Pair<Float, Float> yawPitch, boolean onGround) throws IOException {
        boolean hasRot;
        boolean hasPos = deltaPos != null;
        boolean bl = hasRot = yawPitch != null;
        PacketType type = hasPos ? (hasRot ? PacketType.EntityPositionRotation : PacketType.EntityPosition) : (hasRot ? PacketType.EntityRotation : PacketType.EntityMovement);
        Packet packet = new Packet(registry, type);
        try (Packet.Writer out = packet.overwrite();){
            if (packet.atLeast(ProtocolVersion.v1_8)) {
                out.writeVarInt(entityId);
            } else {
                out.writeInt(entityId);
            }
            if (hasPos) {
                if (packet.atLeast(ProtocolVersion.v1_9)) {
                    out.writeShort((int)(deltaPos.getX() * 4096.0));
                    out.writeShort((int)(deltaPos.getY() * 4096.0));
                    out.writeShort((int)(deltaPos.getZ() * 4096.0));
                } else {
                    out.writeByte((int)(deltaPos.getX() * 32.0));
                    out.writeByte((int)(deltaPos.getY() * 32.0));
                    out.writeByte((int)(deltaPos.getZ() * 32.0));
                }
            }
            if (hasRot) {
                out.writeByte((int)(((Float)yawPitch.getKey()).floatValue() / 360.0f * 256.0f));
                out.writeByte((int)(((Float)yawPitch.getValue()).floatValue() / 360.0f * 256.0f));
            }
            if (packet.atLeast(ProtocolVersion.v1_8) && (hasPos || hasRot)) {
                out.writeBoolean(onGround);
            }
        }
        return packet;
    }
}

