/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.pathing.impl;

import com.replaymod.replaystudio.pathing.impl.KeyframeImpl;
import com.replaymod.replaystudio.pathing.impl.PathSegmentImpl;
import com.replaymod.replaystudio.pathing.interpolation.InterpolationParameters;
import com.replaymod.replaystudio.pathing.interpolation.Interpolator;
import com.replaymod.replaystudio.pathing.path.Keyframe;
import com.replaymod.replaystudio.pathing.path.Path;
import com.replaymod.replaystudio.pathing.path.PathSegment;
import com.replaymod.replaystudio.pathing.path.Timeline;
import com.replaymod.replaystudio.pathing.property.Property;
import com.replaymod.replaystudio.pathing.property.PropertyPart;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

public class PathImpl
implements Path {
    private final Timeline timeline;
    private Map<Long, Keyframe> keyframes = new TreeMap<Long, Keyframe>();
    private List<PathSegment> segments = new LinkedList<PathSegment>();
    private boolean active = true;

    public PathImpl(Timeline timeline) {
        this.timeline = timeline;
    }

    @Override
    public Timeline getTimeline() {
        return this.timeline;
    }

    @Override
    public Collection<Keyframe> getKeyframes() {
        return Collections.unmodifiableCollection(this.keyframes.values());
    }

    @Override
    public Collection<PathSegment> getSegments() {
        return Collections.unmodifiableCollection(this.segments);
    }

    @Override
    public void update() {
        this.update(false);
    }

    @Override
    public void updateAll() {
        this.update(false);
    }

    private void update(boolean force) {
        Interpolator interpolator = null;
        Map<PropertyPart, InterpolationParameters> parameters = new HashMap<PropertyPart, InterpolationParameters>();
        for (PathSegment segment : this.segments) {
            if (segment.getInterpolator() == interpolator) continue;
            interpolator = segment.getInterpolator();
            if (!force && !interpolator.isDirty()) continue;
            parameters = interpolator.bake(parameters);
        }
    }

    @Override
    public <T> Optional<T> getValue(Property<T> property, long time) {
        Interpolator interpolator;
        PathSegment segment = this.getSegment(time);
        if (segment != null && (interpolator = segment.getInterpolator()) != null && interpolator.getKeyframeProperties().contains(property)) {
            return interpolator.getValue(property, time);
        }
        return Optional.empty();
    }

    @Override
    public Keyframe insert(long time) {
        KeyframeImpl keyframe = new KeyframeImpl(time);
        this.insert(keyframe);
        return keyframe;
    }

    @Override
    public Keyframe getKeyframe(long time) {
        return this.keyframes.get(time);
    }

    @Override
    public void insert(Keyframe keyframe) {
        if (this.keyframes.containsKey(keyframe.getTime())) {
            throw new IllegalStateException("A keyframe at " + keyframe.getTime() + " already exists.");
        }
        this.keyframes.put(keyframe.getTime(), keyframe);
        if (this.segments.isEmpty()) {
            if (this.keyframes.size() >= 2) {
                Iterator<Keyframe> iter = this.keyframes.values().iterator();
                this.segments.add(new PathSegmentImpl(this, iter.next(), iter.next()));
            }
            return;
        }
        ListIterator<PathSegment> iter = this.segments.listIterator();
        PathSegment next = iter.next();
        if (keyframe.getTime() < next.getStartKeyframe().getTime()) {
            iter.previous();
            iter.add(new PathSegmentImpl(this, keyframe, next.getStartKeyframe(), next.getInterpolator()));
            return;
        }
        while (true) {
            if (next.getStartKeyframe().getTime() <= keyframe.getTime() && next.getEndKeyframe().getTime() >= keyframe.getTime()) {
                iter.remove();
                iter.add(new PathSegmentImpl(this, next.getStartKeyframe(), keyframe, next.getInterpolator()));
                iter.add(new PathSegmentImpl(this, keyframe, next.getEndKeyframe(), next.getInterpolator()));
                next.setInterpolator(null);
                return;
            }
            if (!iter.hasNext()) break;
            next = iter.next();
        }
        iter.add(new PathSegmentImpl(this, next.getEndKeyframe(), keyframe, next.getInterpolator()));
    }

    @Override
    public void remove(Keyframe keyframe, boolean useFirstInterpolator) {
        if (this.keyframes.get(keyframe.getTime()) != keyframe) {
            throw new IllegalArgumentException("The keyframe " + keyframe + " is not part of this path.");
        }
        this.keyframes.remove(keyframe.getTime());
        if (this.segments.size() < 2) {
            for (PathSegment segment : this.segments) {
                segment.setInterpolator(null);
            }
            this.segments.clear();
            return;
        }
        ListIterator<PathSegment> iter = this.segments.listIterator();
        while (iter.hasNext()) {
            PathSegment next = iter.next();
            if (next.getEndKeyframe() == keyframe) {
                iter.remove();
                if (iter.hasNext()) {
                    PathSegment next2 = iter.next();
                    iter.remove();
                    iter.add(new PathSegmentImpl(this, next.getStartKeyframe(), next2.getEndKeyframe(), (useFirstInterpolator ? next : next2).getInterpolator()));
                    next2.setInterpolator(null);
                }
                next.setInterpolator(null);
                return;
            }
            if (next.getStartKeyframe() != keyframe) continue;
            next.setInterpolator(null);
            iter.remove();
            return;
        }
        throw new AssertionError((Object)"No segment for keyframe found!");
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    private PathSegment getSegment(long time) {
        for (PathSegment segment : this.segments) {
            if (segment.getStartKeyframe().getTime() > time || segment.getEndKeyframe().getTime() < time) continue;
            return segment;
        }
        return null;
    }
}

