/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.libs.mcstructs.text.events.hover.impl;

import com.replaymod.replaystudio.lib.viaversion.libs.mcstructs.core.Identifier;
import com.replaymod.replaystudio.lib.viaversion.libs.mcstructs.snbt.SNbtSerializer;
import com.replaymod.replaystudio.lib.viaversion.libs.mcstructs.snbt.exceptions.SNbtSerializeException;
import com.replaymod.replaystudio.lib.viaversion.libs.mcstructs.text.ATextComponent;
import com.replaymod.replaystudio.lib.viaversion.libs.mcstructs.text.components.StringComponent;
import com.replaymod.replaystudio.lib.viaversion.libs.mcstructs.text.events.hover.AHoverEvent;
import com.replaymod.replaystudio.lib.viaversion.libs.mcstructs.text.events.hover.HoverEventAction;
import com.replaymod.replaystudio.lib.viaversion.libs.mcstructs.text.events.hover.impl.TextHoverEvent;
import com.replaymod.replaystudio.lib.viaversion.libs.mcstructs.text.serializer.TextComponentSerializer;
import com.replaymod.replaystudio.lib.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import java.util.Objects;
import java.util.UUID;

public class EntityHoverEvent
extends AHoverEvent {
    private final Identifier entityType;
    private final UUID uuid;
    private final ATextComponent name;

    public EntityHoverEvent(HoverEventAction action, Identifier entityType, UUID uuid, ATextComponent name) {
        super(action);
        this.entityType = entityType;
        this.uuid = uuid;
        this.name = name;
    }

    public Identifier getEntityType() {
        return this.entityType;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public ATextComponent getName() {
        return this.name;
    }

    @Override
    public TextHoverEvent toLegacy(TextComponentSerializer textComponentSerializer, SNbtSerializer<?> sNbtSerializer) {
        CompoundTag tag = new CompoundTag();
        tag.putString("type", this.entityType.getValue());
        tag.putString("id", this.uuid.toString());
        tag.putString("name", textComponentSerializer.serialize(this.name));
        try {
            return new TextHoverEvent(this.getAction(), new StringComponent(sNbtSerializer.serialize(tag)));
        }
        catch (SNbtSerializeException e) {
            throw new RuntimeException("This should never happen! Please report to the developer immediately!", e);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityHoverEvent that = (EntityHoverEvent)o;
        return Objects.equals(this.entityType, that.entityType) && Objects.equals(this.uuid, that.uuid) && Objects.equals(this.name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entityType, this.uuid, this.name);
    }

    @Override
    public String toString() {
        return "EntityHoverEvent{entityType=" + this.entityType + ", uuid=" + this.uuid + ", name=" + this.name + '}';
    }
}

