/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render.utils;

import com.google.common.base.Objects;
import com.replaymod.core.ReplayMod;
import java.nio.ByteBuffer;
import org.apache.logging.log4j.LogManager;
import org.lwjgl.opengl.ARBVertexBufferObject;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL15;

public class PixelBufferObject {
    public static final boolean SUPPORTED = GL.getCapabilities().GL_ARB_pixel_buffer_object || GL.getCapabilities().OpenGL15;
    private static final boolean arb = !GL.getCapabilities().OpenGL15;
    private static ThreadLocal<Integer> bound = new ThreadLocal();
    private static ThreadLocal<Integer> mapped = new ThreadLocal();
    private final long size;
    private long handle;

    public PixelBufferObject(long size, Usage usage) {
        if (!SUPPORTED) {
            throw new UnsupportedOperationException("PBOs not supported.");
        }
        this.size = size;
        this.handle = arb ? (long)ARBVertexBufferObject.glGenBuffersARB() : (long)GL15.glGenBuffers();
        this.bind();
        if (arb) {
            ARBVertexBufferObject.glBufferDataARB((int)35051, (long)size, (int)usage.arb);
        } else {
            GL15.glBufferData((int)35051, (long)size, (int)usage.gl15);
        }
        this.unbind();
    }

    private int getHandle() {
        if (this.handle == -1L) {
            throw new IllegalStateException("PBO not allocated.");
        }
        return (int)this.handle;
    }

    public void bind() {
        if (arb) {
            ARBVertexBufferObject.glBindBufferARB((int)35051, (int)this.getHandle());
        } else {
            GL15.glBindBuffer((int)35051, (int)this.getHandle());
        }
        bound.set(this.getHandle());
    }

    public void unbind() {
        this.checkBound();
        if (arb) {
            ARBVertexBufferObject.glBindBufferARB((int)35051, (int)0);
        } else {
            GL15.glBindBuffer((int)35051, (int)0);
        }
        bound.set(0);
    }

    private void checkBound() {
        if (!Objects.equal((Object)this.getHandle(), (Object)bound.get())) {
            throw new IllegalStateException("Buffer not bound.");
        }
    }

    private void checkNotMapped() {
        if (Objects.equal((Object)this.getHandle(), (Object)mapped.get())) {
            throw new IllegalStateException("Buffer already mapped.");
        }
    }

    public ByteBuffer mapReadOnly() {
        this.checkBound();
        this.checkNotMapped();
        ByteBuffer buffer = arb ? ARBVertexBufferObject.glMapBufferARB((int)35051, (int)35000, (long)this.size, null) : GL15.glMapBuffer((int)35051, (int)35000, (long)this.size, null);
        mapped.set(this.getHandle());
        return buffer;
    }

    public ByteBuffer mapWriteOnly() {
        this.checkBound();
        this.checkNotMapped();
        ByteBuffer buffer = arb ? ARBVertexBufferObject.glMapBufferARB((int)35051, (int)35001, (long)this.size, null) : GL15.glMapBuffer((int)35051, (int)35001, (long)this.size, null);
        mapped.set(this.getHandle());
        return buffer;
    }

    public ByteBuffer mapReadWrite() {
        this.checkBound();
        this.checkNotMapped();
        ByteBuffer buffer = arb ? ARBVertexBufferObject.glMapBufferARB((int)35051, (int)35002, (long)this.size, null) : GL15.glMapBuffer((int)35051, (int)35002, (long)this.size, null);
        mapped.set(this.getHandle());
        return buffer;
    }

    public void unmap() {
        this.checkBound();
        if (!Objects.equal((Object)mapped.get(), (Object)this.getHandle())) {
            throw new IllegalStateException("Buffer not mapped.");
        }
        if (arb) {
            ARBVertexBufferObject.glUnmapBufferARB((int)35051);
        } else {
            GL15.glUnmapBuffer((int)35051);
        }
        mapped.set(0);
    }

    public void delete() {
        if (this.handle != -1L) {
            if (arb) {
                ARBVertexBufferObject.glDeleteBuffersARB((int)this.getHandle());
            } else {
                GL15.glDeleteBuffers((int)this.getHandle());
            }
            this.handle = -1L;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.handle != -1L) {
            LogManager.getLogger().warn("PBO garbage collected before deleted!");
            ReplayMod.instance.runLater(this::delete);
        }
    }

    public static enum Usage {
        COPY(35042, 35042),
        DRAW(35040, 35040),
        READ(35041, 35041);

        private final int arb;
        private final int gl15;

        private Usage(int arb, int gl15) {
            this.arb = arb;
            this.gl15 = gl15;
        }
    }
}

