/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render.rendering;

import com.replaymod.render.RenderSettings;
import com.replaymod.render.blend.BlendFrameCapturer;
import com.replaymod.render.capturer.CubicOpenGlFrameCapturer;
import com.replaymod.render.capturer.CubicPboOpenGlFrameCapturer;
import com.replaymod.render.capturer.IrisODSFrameCapturer;
import com.replaymod.render.capturer.ODSFrameCapturer;
import com.replaymod.render.capturer.OpenGlFrameCapturer;
import com.replaymod.render.capturer.RenderInfo;
import com.replaymod.render.capturer.SimpleOpenGlFrameCapturer;
import com.replaymod.render.capturer.SimplePboOpenGlFrameCapturer;
import com.replaymod.render.capturer.StereoscopicOpenGlFrameCapturer;
import com.replaymod.render.capturer.StereoscopicPboOpenGlFrameCapturer;
import com.replaymod.render.frame.BitmapFrame;
import com.replaymod.render.frame.CubicOpenGlFrame;
import com.replaymod.render.frame.ODSOpenGlFrame;
import com.replaymod.render.frame.OpenGlFrame;
import com.replaymod.render.frame.StereoscopicOpenGlFrame;
import com.replaymod.render.hooks.EntityRendererHandler;
import com.replaymod.render.processor.CubicToBitmapProcessor;
import com.replaymod.render.processor.DummyProcessor;
import com.replaymod.render.processor.EquirectangularToBitmapProcessor;
import com.replaymod.render.processor.ODSToBitmapProcessor;
import com.replaymod.render.processor.OpenGlToBitmapProcessor;
import com.replaymod.render.processor.StereoscopicToBitmapProcessor;
import com.replaymod.render.rendering.Channel;
import com.replaymod.render.rendering.FrameCapturer;
import com.replaymod.render.rendering.FrameConsumer;
import com.replaymod.render.rendering.Pipeline;
import com.replaymod.render.utils.PixelBufferObject;
import java.util.Map;
import net.minecraftforge.fml.loading.LoadingModList;

public class Pipelines {
    public static Pipeline newPipeline(RenderSettings.RenderMethod method, RenderInfo renderInfo, FrameConsumer<BitmapFrame> consumer) {
        switch (method) {
            case DEFAULT: {
                return Pipelines.newDefaultPipeline(renderInfo, consumer);
            }
            case STEREOSCOPIC: {
                return Pipelines.newStereoscopicPipeline(renderInfo, consumer);
            }
            case CUBIC: {
                return Pipelines.newCubicPipeline(renderInfo, consumer);
            }
            case EQUIRECTANGULAR: {
                return Pipelines.newEquirectangularPipeline(renderInfo, consumer);
            }
            case ODS: {
                return Pipelines.newODSPipeline(renderInfo, consumer);
            }
            case BLEND: {
                throw new UnsupportedOperationException("Use newBlendPipeline instead!");
            }
        }
        throw new UnsupportedOperationException("Unknown method: " + method);
    }

    public static Pipeline<OpenGlFrame, BitmapFrame> newDefaultPipeline(RenderInfo renderInfo, FrameConsumer<BitmapFrame> consumer) {
        RenderSettings settings = renderInfo.getRenderSettings();
        EntityRendererHandler worldRenderer = new EntityRendererHandler(settings, renderInfo);
        OpenGlFrameCapturer capturer = PixelBufferObject.SUPPORTED || settings.isDepthMap() ? new SimplePboOpenGlFrameCapturer(worldRenderer, renderInfo) : new SimpleOpenGlFrameCapturer(worldRenderer, renderInfo);
        return new Pipeline<OpenGlFrame, BitmapFrame>(worldRenderer, capturer, new OpenGlToBitmapProcessor(), consumer);
    }

    public static Pipeline<StereoscopicOpenGlFrame, BitmapFrame> newStereoscopicPipeline(RenderInfo renderInfo, FrameConsumer<BitmapFrame> consumer) {
        RenderSettings settings = renderInfo.getRenderSettings();
        EntityRendererHandler worldRenderer = new EntityRendererHandler(settings, renderInfo);
        OpenGlFrameCapturer capturer = PixelBufferObject.SUPPORTED || settings.isDepthMap() ? new StereoscopicPboOpenGlFrameCapturer(worldRenderer, renderInfo) : new StereoscopicOpenGlFrameCapturer(worldRenderer, renderInfo);
        return new Pipeline<StereoscopicOpenGlFrame, BitmapFrame>(worldRenderer, capturer, new StereoscopicToBitmapProcessor(), consumer);
    }

    public static Pipeline<CubicOpenGlFrame, BitmapFrame> newCubicPipeline(RenderInfo renderInfo, FrameConsumer<BitmapFrame> consumer) {
        RenderSettings settings = renderInfo.getRenderSettings();
        EntityRendererHandler worldRenderer = new EntityRendererHandler(settings, renderInfo);
        OpenGlFrameCapturer capturer = PixelBufferObject.SUPPORTED || settings.isDepthMap() ? new CubicPboOpenGlFrameCapturer(worldRenderer, renderInfo, settings.getVideoWidth() / 4) : new CubicOpenGlFrameCapturer(worldRenderer, renderInfo, settings.getVideoWidth() / 4);
        return new Pipeline<CubicOpenGlFrame, BitmapFrame>(worldRenderer, capturer, new CubicToBitmapProcessor(), consumer);
    }

    public static Pipeline<CubicOpenGlFrame, BitmapFrame> newEquirectangularPipeline(RenderInfo renderInfo, FrameConsumer<BitmapFrame> consumer) {
        RenderSettings settings = renderInfo.getRenderSettings();
        EntityRendererHandler worldRenderer = new EntityRendererHandler(settings, renderInfo);
        EquirectangularToBitmapProcessor processor = new EquirectangularToBitmapProcessor(settings.getVideoWidth(), settings.getVideoHeight(), settings.getSphericalFovX());
        OpenGlFrameCapturer capturer = PixelBufferObject.SUPPORTED || settings.isDepthMap() ? new CubicPboOpenGlFrameCapturer(worldRenderer, renderInfo, processor.getFrameSize()) : new CubicOpenGlFrameCapturer(worldRenderer, renderInfo, processor.getFrameSize());
        return new Pipeline<CubicOpenGlFrame, BitmapFrame>(worldRenderer, capturer, processor, consumer);
    }

    public static Pipeline<ODSOpenGlFrame, BitmapFrame> newODSPipeline(RenderInfo renderInfo, FrameConsumer<BitmapFrame> consumer) {
        RenderSettings settings = renderInfo.getRenderSettings();
        EntityRendererHandler worldRenderer = new EntityRendererHandler(settings, renderInfo);
        ODSToBitmapProcessor processor = new ODSToBitmapProcessor(settings.getVideoWidth(), settings.getVideoHeight(), settings.getSphericalFovX());
        boolean iris = LoadingModList.get().getModFileById("oculus") != null;
        FrameCapturer<ODSOpenGlFrame> capturer = iris ? new IrisODSFrameCapturer(worldRenderer, renderInfo, processor.getFrameSize()) : new ODSFrameCapturer(worldRenderer, renderInfo, processor.getFrameSize());
        return new Pipeline<ODSOpenGlFrame, BitmapFrame>(worldRenderer, capturer, processor, consumer);
    }

    public static Pipeline<BitmapFrame, BitmapFrame> newBlendPipeline(RenderInfo renderInfo) {
        RenderSettings settings = renderInfo.getRenderSettings();
        EntityRendererHandler worldRenderer = new EntityRendererHandler(settings, renderInfo);
        BlendFrameCapturer capturer = new BlendFrameCapturer(worldRenderer, renderInfo);
        FrameConsumer<BitmapFrame> consumer = new FrameConsumer<BitmapFrame>(){

            @Override
            public void consume(Map<Channel, BitmapFrame> channels) {
            }

            @Override
            public void close() {
            }

            @Override
            public boolean isParallelCapable() {
                return true;
            }
        };
        return new Pipeline<BitmapFrame, BitmapFrame>(worldRenderer, capturer, new DummyProcessor(), consumer);
    }
}

