/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render.frame;

import com.replaymod.render.rendering.Frame;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.Validate;

public class BitmapFrame
implements Frame {
    private final int frameId;
    private final ReadableDimension size;
    private final int bytesPerPixel;
    private final ByteBuffer byteBuffer;

    public BitmapFrame(int frameId, ReadableDimension size, int bytesPerPixel, ByteBuffer byteBuffer) {
        Validate.isTrue((size.getWidth() * size.getHeight() * bytesPerPixel == byteBuffer.remaining() ? 1 : 0) != 0, (String)"Buffer size is %d (cap: %d) but should be %d", (Object[])new Object[]{byteBuffer.remaining(), byteBuffer.capacity(), size.getWidth() * size.getHeight() * bytesPerPixel});
        this.frameId = frameId;
        this.size = size;
        this.bytesPerPixel = bytesPerPixel;
        this.byteBuffer = byteBuffer;
    }

    @Override
    public int getFrameId() {
        return this.frameId;
    }

    public ReadableDimension getSize() {
        return this.size;
    }

    public int getBytesPerPixel() {
        return this.bytesPerPixel;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }
}

