/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render.capturer;

import com.replaymod.render.RenderSettings;
import com.replaymod.render.capturer.CubicOpenGlFrameCapturer;
import com.replaymod.render.capturer.CubicPboOpenGlFrameCapturer;
import com.replaymod.render.capturer.RenderInfo;
import com.replaymod.render.capturer.WorldRenderer;
import com.replaymod.render.frame.CubicOpenGlFrame;
import com.replaymod.render.frame.ODSOpenGlFrame;
import com.replaymod.render.frame.OpenGlFrame;
import com.replaymod.render.rendering.Channel;
import com.replaymod.render.rendering.FrameCapturer;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.config.IrisConfig;

public class IrisODSFrameCapturer
implements FrameCapturer<ODSOpenGlFrame> {
    public static final String SHADER_PACK_NAME = "assets/replaymod/iris/ods";
    public static IrisODSFrameCapturer INSTANCE;
    private final CubicPboOpenGlFrameCapturer left;
    private final CubicPboOpenGlFrameCapturer right;
    private final String prevShaderPack;
    private final boolean prevShadersEnabled;
    private int direction;
    private boolean isLeftEye;

    public IrisODSFrameCapturer(WorldRenderer worldRenderer, final RenderInfo renderInfo, int frameSize) {
        RenderInfo fakeInfo = new RenderInfo(){
            private int call;
            private float partialTicks;

            @Override
            public ReadableDimension getFrameSize() {
                return renderInfo.getFrameSize();
            }

            @Override
            public int getFramesDone() {
                return renderInfo.getFramesDone();
            }

            @Override
            public int getTotalFrames() {
                return renderInfo.getTotalFrames();
            }

            @Override
            public float updateForNextFrame() {
                if (this.call++ % 2 == 0) {
                    this.partialTicks = renderInfo.updateForNextFrame();
                }
                return this.partialTicks;
            }

            @Override
            public RenderSettings getRenderSettings() {
                return renderInfo.getRenderSettings();
            }
        };
        this.left = new CubicStereoFrameCapturer(worldRenderer, fakeInfo, frameSize);
        this.right = new CubicStereoFrameCapturer(worldRenderer, fakeInfo, frameSize);
        INSTANCE = this;
        IrisConfig irisConfig = Iris.getIrisConfig();
        this.prevShaderPack = irisConfig.getShaderPackName().orElse(null);
        this.prevShadersEnabled = irisConfig.areShadersEnabled();
        IrisODSFrameCapturer.setShaderPack(SHADER_PACK_NAME, true);
    }

    private static void setShaderPack(String name, boolean enabled) {
        IrisConfig irisConfig = Iris.getIrisConfig();
        irisConfig.setShaderPackName(name);
        irisConfig.setShadersEnabled(enabled);
        try {
            irisConfig.save();
            Iris.reload();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public boolean isLeftEye() {
        return this.isLeftEye;
    }

    @Override
    public boolean isDone() {
        return this.left.isDone() && this.right.isDone();
    }

    @Override
    public Map<Channel, ODSOpenGlFrame> process() {
        this.isLeftEye = true;
        Map leftChannels = this.left.process();
        this.isLeftEye = false;
        Map rightChannels = this.right.process();
        if (leftChannels != null && rightChannels != null) {
            HashMap<Channel, ODSOpenGlFrame> result = new HashMap<Channel, ODSOpenGlFrame>();
            for (Channel channel : Channel.values()) {
                CubicOpenGlFrame leftFrame = (CubicOpenGlFrame)leftChannels.get((Object)channel);
                CubicOpenGlFrame rightFrame = (CubicOpenGlFrame)rightChannels.get((Object)channel);
                if (leftFrame == null || rightFrame == null) continue;
                result.put(channel, new ODSOpenGlFrame(leftFrame, rightFrame));
            }
            return result;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.left.close();
        this.right.close();
        INSTANCE = null;
        IrisODSFrameCapturer.setShaderPack(this.prevShaderPack, this.prevShadersEnabled);
    }

    private class CubicStereoFrameCapturer
    extends CubicPboOpenGlFrameCapturer {
        public CubicStereoFrameCapturer(WorldRenderer worldRenderer, RenderInfo renderInfo, int frameSize) {
            super(worldRenderer, renderInfo, frameSize);
        }

        @Override
        protected OpenGlFrame renderFrame(int frameId, float partialTicks, CubicOpenGlFrameCapturer.Data captureData) {
            IrisODSFrameCapturer.this.direction = captureData.ordinal();
            return super.renderFrame(frameId, partialTicks, captureData);
        }
    }
}

