/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.recording.handler;

import com.mojang.datafixers.util.Pair;
import com.replaymod.core.events.PreRenderCallback;
import com.replaymod.core.versions.MCVer;
import com.replaymod.recording.mixin.IntegratedServerAccessor;
import com.replaymod.recording.packet.PacketListener;
import de.johni0702.minecraft.gui.utils.EventRegistrations;
import de.johni0702.minecraft.gui.versions.callbacks.PreTickCallback;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddPlayerPacket;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class RecordingEventHandler
extends EventRegistrations {
    private final Minecraft mc = MCVer.getMinecraft();
    private final PacketListener packetListener;
    private Double lastX;
    private Double lastY;
    private Double lastZ;
    private final List<ItemStack> playerItems = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);
    private int ticksSinceLastCorrection;
    private boolean wasSleeping;
    private int lastRiding = -1;
    private Integer rotationYawHeadBefore;

    public RecordingEventHandler(PacketListener packetListener) {
        this.on(PreTickCallback.EVENT, this::onPlayerTick);
        this.on(PreRenderCallback.EVENT, this::checkForGamePaused);
        this.packetListener = packetListener;
    }

    @Override
    public void register() {
        super.register();
        ((RecordingEventSender)this.mc.f_91060_).setRecordingEventHandler(this);
    }

    @Override
    public void unregister() {
        super.unregister();
        RecordingEventSender recordingEventSender = (RecordingEventSender)this.mc.f_91060_;
        if (recordingEventSender.getRecordingEventHandler() == this) {
            recordingEventSender.setRecordingEventHandler(null);
        }
    }

    public void onPacket(Packet<?> packet) {
        this.packetListener.save(packet);
    }

    public void spawnRecordingPlayer() {
        try {
            LocalPlayer player = this.mc.f_91074_;
            assert (player != null);
            this.packetListener.save((Packet)new ClientboundAddPlayerPacket((Player)player));
            this.packetListener.save((Packet)new ClientboundSetEntityDataPacket(player.m_19879_(), player.m_20088_().m_252804_()));
            this.lastZ = null;
            this.lastY = null;
            this.lastX = null;
            this.playerItems.clear();
            this.lastRiding = -1;
            this.wasSleeping = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onClientEffect(int type, BlockPos pos, int data) {
        try {
            this.packetListener.save((Packet)new ClientboundLevelEventPacket(type, pos, data, false));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onPlayerTick() {
        if (this.mc.f_91074_ == null) {
            return;
        }
        LocalPlayer player = this.mc.f_91074_;
        try {
            int vehicleId;
            ClientboundTeleportEntityPacket packet;
            boolean force = false;
            if (this.lastX == null || this.lastY == null || this.lastZ == null) {
                force = true;
                this.lastX = player.m_20185_();
                this.lastY = player.m_20186_();
                this.lastZ = player.m_20189_();
            }
            ++this.ticksSinceLastCorrection;
            if (this.ticksSinceLastCorrection >= 100) {
                this.ticksSinceLastCorrection = 0;
                force = true;
            }
            double dx = player.m_20185_() - this.lastX;
            double dy = player.m_20186_() - this.lastY;
            double dz = player.m_20189_() - this.lastZ;
            this.lastX = player.m_20185_();
            this.lastY = player.m_20186_();
            this.lastZ = player.m_20189_();
            double maxRelDist = 8.0;
            if (force || Math.abs(dx) > 8.0 || Math.abs(dy) > 8.0 || Math.abs(dz) > 8.0) {
                packet = new ClientboundTeleportEntityPacket((Entity)player);
            } else {
                byte newYaw = (byte)(player.m_146908_() * 256.0f / 360.0f);
                byte newPitch = (byte)(player.m_146909_() * 256.0f / 360.0f);
                packet = new ClientboundMoveEntityPacket.PosRot(player.m_19879_(), (short)Math.round(dx * 4096.0), (short)Math.round(dy * 4096.0), (short)Math.round(dz * 4096.0), newYaw, newPitch, player.m_20096_());
            }
            this.packetListener.save((Packet)packet);
            int rotationYawHead = (int)(player.f_20885_ * 256.0f / 360.0f);
            if (!Objects.equals(rotationYawHead, this.rotationYawHeadBefore)) {
                this.packetListener.save((Packet)new ClientboundRotateHeadPacket((Entity)player, (byte)rotationYawHead));
                this.rotationYawHeadBefore = rotationYawHead;
            }
            this.packetListener.save((Packet)new ClientboundSetEntityMotionPacket(player.m_19879_(), player.m_20184_()));
            if (player.f_20911_ && player.f_20913_ == 0) {
                this.packetListener.save((Packet)new ClientboundAnimatePacket((Entity)player, player.f_20912_ == InteractionHand.MAIN_HAND ? 0 : 3));
            }
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack = player.m_6844_(slot);
                int index = slot.ordinal();
                if (ItemStack.m_41728_((ItemStack)this.playerItems.get(index), (ItemStack)stack)) continue;
                stack = stack != null ? stack.m_41777_() : null;
                this.playerItems.set(index, stack);
                this.packetListener.save((Packet)new ClientboundSetEquipmentPacket(player.m_19879_(), Collections.singletonList(Pair.of((Object)slot, (Object)stack))));
            }
            Entity vehicle = player.m_20202_();
            int n = vehicleId = vehicle == null ? -1 : vehicle.m_19879_();
            if (this.lastRiding != vehicleId) {
                this.lastRiding = vehicleId;
                this.packetListener.save((Packet)new ClientboundSetEntityLinkPacket((Entity)player, vehicle));
            }
            if (!player.m_5803_() && this.wasSleeping) {
                this.packetListener.save((Packet)new ClientboundAnimatePacket((Entity)player, 2));
                this.wasSleeping = false;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void onBlockBreakAnim(int breakerId, BlockPos pos, int progress) {
        LocalPlayer thePlayer = this.mc.f_91074_;
        if (thePlayer != null && breakerId == thePlayer.m_19879_()) {
            this.packetListener.save((Packet)new ClientboundBlockDestructionPacket(breakerId, pos, progress));
        }
    }

    private void checkForGamePaused() {
        IntegratedServer server;
        if (this.mc.m_91091_() && (server = this.mc.m_91092_()) != null && ((IntegratedServerAccessor)server).isGamePaused()) {
            this.packetListener.setServerWasPaused();
        }
    }

    public static interface RecordingEventSender {
        public void setRecordingEventHandler(RecordingEventHandler var1);

        public RecordingEventHandler getRecordingEventHandler();
    }
}

