/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.extras.advancedscreenshots;

import com.replaymod.core.ReplayMod;
import com.replaymod.core.SettingsRegistry;
import com.replaymod.core.versions.MCVer;
import com.replaymod.extras.Setting;
import com.replaymod.render.RenderSettings;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.container.GuiPanel;
import de.johni0702.minecraft.gui.element.GuiButton;
import de.johni0702.minecraft.gui.element.GuiCheckbox;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.element.GuiLabel;
import de.johni0702.minecraft.gui.layout.HorizontalLayout;
import de.johni0702.minecraft.gui.layout.VerticalLayout;
import de.johni0702.minecraft.gui.popup.AbstractGuiPopup;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableColor;
import java.net.URI;

public class GuiUploadScreenshot
extends AbstractGuiPopup<GuiUploadScreenshot> {
    public final ReplayMod mod;
    public final RenderSettings renderSettings;
    public final GuiLabel successLabel = (GuiLabel)((GuiLabel)new GuiLabel().setI18nText("replaymod.gui.advancedscreenshots.finished.description", new Object[0])).setColor(ReadableColor.BLACK);
    public final GuiLabel veerLabel = (GuiLabel)((GuiLabel)new GuiLabel().setI18nText("replaymod.gui.advancedscreenshots.finished.description.veer", new Object[0])).setColor(ReadableColor.BLACK);
    public final GuiButton veerUploadButton = (GuiButton)((GuiButton)new GuiButton().setSize(150, 20)).setI18nLabel("replaymod.gui.advancedscreenshots.finished.upload.veer", new Object[0]);
    public final GuiButton showOnDiskButton = (GuiButton)((GuiButton)new GuiButton().setSize(150, 20)).setI18nLabel("replaymod.gui.advancedscreenshots.finished.showfile", new Object[0]);
    public final GuiButton closeButton = (GuiButton)((GuiButton)new GuiButton().setSize(150, 20)).setI18nLabel("replaymod.gui.close", new Object[0]);
    public final GuiCheckbox neverOpenCheckbox = new GuiCheckbox();
    public final GuiLabel neverOpenLabel = (GuiLabel)((GuiLabel)new GuiLabel().setI18nText("replaymod.gui.notagain", new Object[0])).setColor(ReadableColor.BLACK);
    public final GuiPanel checkboxPanel = GuiPanel.builder().layout(new HorizontalLayout(HorizontalLayout.Alignment.RIGHT).setSpacing(5)).with(this.neverOpenCheckbox, new HorizontalLayout.Data(0.5)).with(this.neverOpenLabel, new HorizontalLayout.Data(0.5)).build();

    public GuiUploadScreenshot(GuiContainer container, ReplayMod mod, RenderSettings renderSettings) {
        super(container);
        boolean veer;
        this.mod = mod;
        this.renderSettings = renderSettings;
        boolean bl = veer = renderSettings.getRenderMethod() == RenderSettings.RenderMethod.EQUIRECTANGULAR;
        if (renderSettings.getRenderMethod() == RenderSettings.RenderMethod.EQUIRECTANGULAR) {
            this.successLabel.setI18nText("replaymod.gui.advancedscreenshots.finished.description.360", new Object[0]);
        }
        if (veer) {
            this.veerUploadButton.onClick(() -> MCVer.openURL(URI.create("https://veer.tv/upload")));
        }
        this.showOnDiskButton.onClick(() -> MCVer.openFile(renderSettings.getOutputFile().getParentFile()));
        this.closeButton.onClick(() -> {
            if (this.neverOpenCheckbox.isChecked()) {
                SettingsRegistry settingsRegistry = mod.getSettingsRegistry();
                settingsRegistry.set(Setting.SKIP_POST_SCREENSHOT_GUI, true);
                settingsRegistry.save();
            }
            this.close();
        });
        this.popup.addElements(new VerticalLayout.Data(0.5), new GuiElement[]{this.successLabel});
        if (veer) {
            this.popup.addElements(new VerticalLayout.Data(0.5), new GuiElement[]{this.veerLabel, this.veerUploadButton});
        }
        this.popup.addElements(new VerticalLayout.Data(0.5), new GuiElement[]{this.successLabel, this.showOnDiskButton, this.closeButton});
        this.popup.addElements(new VerticalLayout.Data(1.0), new GuiElement[]{this.checkboxPanel});
        this.popup.setLayout(new VerticalLayout().setSpacing(5));
    }

    @Override
    protected void open() {
        if (this.mod.getSettingsRegistry().get(Setting.SKIP_POST_SCREENSHOT_GUI).booleanValue()) {
            return;
        }
        super.open();
    }

    @Override
    protected GuiUploadScreenshot getThis() {
        return this;
    }
}

