/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.extras;

import com.replaymod.core.ReplayMod;
import com.replaymod.extras.Extra;
import com.replaymod.replay.ReplayHandler;
import com.replaymod.replay.ReplayModReplay;
import com.replaymod.replay.events.ReplayOpenedCallback;
import com.replaymod.replay.gui.overlay.GuiReplayOverlay;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.element.GuiImage;
import de.johni0702.minecraft.gui.layout.HorizontalLayout;
import de.johni0702.minecraft.gui.utils.EventRegistrations;

public class QuickMode
extends EventRegistrations
implements Extra {
    private ReplayModReplay module;
    private final GuiImage indicator = (GuiImage)((GuiImage)new GuiImage().setTexture(ReplayMod.TEXTURE, 40, 100, 16, 16)).setSize(16, 16);

    public QuickMode() {
        this.on(ReplayOpenedCallback.EVENT, replayHandler -> this.updateIndicator(replayHandler.getOverlay(), replayHandler.isQuickMode()));
    }

    @Override
    public void register(ReplayMod mod) {
        this.module = ReplayModReplay.instance;
        mod.getKeyBindingRegistry().registerKeyBinding("replaymod.input.quickmode", 81, () -> {
            ReplayHandler replayHandler = this.module.getReplayHandler();
            if (replayHandler == null) {
                return;
            }
            replayHandler.getReplaySender().setSyncModeAndWait();
            mod.runLaterWithoutLock(() -> replayHandler.ensureQuickModeInitialized(() -> {
                boolean enabled = !replayHandler.isQuickMode();
                this.updateIndicator(replayHandler.getOverlay(), enabled);
                replayHandler.setQuickMode(enabled);
                replayHandler.getReplaySender().setAsyncMode(true);
            }));
        }, true);
        this.register();
    }

    private void updateIndicator(GuiReplayOverlay overlay, boolean enabled) {
        if (enabled) {
            overlay.statusIndicatorPanel.addElements(new HorizontalLayout.Data(1.0), new GuiElement[]{this.indicator});
        } else {
            overlay.statusIndicatorPanel.removeElement(this.indicator);
        }
    }
}

