/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.core.files;

import com.replaymod.core.ReplayMod;
import com.replaymod.core.files.ManagedReplayFile;
import com.replaymod.core.files.ReplayFoldersService;
import com.replaymod.core.gui.RestoreReplayGui;
import com.replaymod.replaystudio.replay.ReplayFile;
import com.replaymod.replaystudio.replay.ZipReplayFile;
import com.replaymod.replaystudio.studio.ReplayStudio;
import de.johni0702.minecraft.gui.container.GuiScreen;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class ReplayFilesService {
    private final ReplayFoldersService folders;
    private final Set<Path> lockedPaths = Collections.newSetFromMap(new ConcurrentHashMap());

    public ReplayFilesService(ReplayFoldersService folders) {
        this.folders = folders;
    }

    public ReplayFile open(Path path) throws IOException {
        return this.open(path, path);
    }

    public ReplayFile open(Path input, Path output) throws IOException {
        ZipReplayFile replayFile;
        Path realInput = input != null ? input.toAbsolutePath().normalize() : null;
        Path realOutput = output.toAbsolutePath().normalize();
        if (realInput != null && !this.lockedPaths.add(realInput)) {
            throw new FileLockedException(realInput);
        }
        if (!Objects.equals(realInput, realOutput) && !this.lockedPaths.add(realOutput)) {
            if (realInput != null) {
                this.lockedPaths.remove(realInput);
            }
            throw new FileLockedException(realOutput);
        }
        Runnable onClose = () -> {
            if (realInput != null) {
                this.lockedPaths.remove(realInput);
            }
            this.lockedPaths.remove(realOutput);
        };
        try {
            replayFile = new ZipReplayFile(new ReplayStudio(), realInput != null ? realInput.toFile() : null, realOutput.toFile(), this.folders.getCachePathForReplay(realOutput).toFile());
        }
        catch (IOException e) {
            onClose.run();
            throw e;
        }
        return new ManagedReplayFile(replayFile, onClose);
    }

    public void initialScan(ReplayMod core) {
        DirectoryStream<Path> paths;
        try {
            paths = Files.newDirectoryStream(this.folders.getRecordingFolder());
            try {
                for (Path path : paths) {
                    Path destination = this.folders.getReplayFolder().resolve(path.getFileName());
                    if (Files.exists(destination, new LinkOption[0])) continue;
                    Files.move(path, destination, new CopyOption[0]);
                }
            }
            finally {
                if (paths != null) {
                    paths.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            paths = Files.newDirectoryStream(this.folders.getReplayFolder());
            try {
                for (Path path : paths) {
                    String name = path.getFileName().toString();
                    if (!name.endsWith(".mcpr.tmp") || !Files.isDirectory(path, new LinkOption[0])) continue;
                    Path original = path.resolveSibling(FilenameUtils.getBaseName((String)name));
                    Path noRecoverMarker = original.resolveSibling(original.getFileName() + ".no_recover");
                    if (Files.exists(noRecoverMarker, new LinkOption[0])) {
                        FileUtils.deleteDirectory((File)path.toFile());
                        Files.delete(noRecoverMarker);
                        continue;
                    }
                    new RestoreReplayGui(core, GuiScreen.wrap(core.getMinecraft().f_91080_), original.toFile()).display();
                }
            }
            finally {
                if (paths != null) {
                    paths.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        new Thread(this::cleanup, "replaymod-cleanup").start();
    }

    private void cleanup() {
        String name;
        long lastModified;
        DirectoryStream<Path> paths;
        long DAYS = 86400000L;
        try {
            Files.walkFileTree(this.folders.getReplayFolder(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    String name = dir.getFileName().toString();
                    if (name.endsWith(".mcpr.cache")) {
                        FileUtils.deleteDirectory((File)dir.toFile());
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return super.preVisitDirectory(dir, attrs);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            paths = Files.newDirectoryStream(this.folders.getRawReplayFolder());
            try {
                for (Path path : paths) {
                    if (Files.getLastModifiedTime(path, new LinkOption[0]).toMillis() + 1814400000L >= System.currentTimeMillis()) continue;
                    Files.delete(path);
                }
            }
            finally {
                if (paths != null) {
                    paths.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            paths = Files.newDirectoryStream(this.folders.getCacheFolder());
            try {
                for (Path path : paths) {
                    if (!Files.isDirectory(path, new LinkOption[0])) continue;
                    Path replay = this.folders.getReplayPathForCache(path);
                    lastModified = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
                    if (lastModified + 604800000L >= System.currentTimeMillis() && Files.exists(replay, new LinkOption[0])) continue;
                    FileUtils.deleteDirectory((File)path.toFile());
                }
            }
            finally {
                if (paths != null) {
                    paths.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            paths = Files.newDirectoryStream(this.folders.getReplayFolder());
            try {
                for (Path path : paths) {
                    name = path.getFileName().toString();
                    if (!name.endsWith(".mcpr.del") || !Files.isDirectory(path, new LinkOption[0]) || (lastModified = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis()) + 172800000L >= System.currentTimeMillis()) continue;
                    FileUtils.deleteDirectory((File)path.toFile());
                }
            }
            finally {
                if (paths != null) {
                    paths.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            paths = Files.newDirectoryStream(this.folders.getReplayFolder());
            try {
                for (Path path : paths) {
                    name = path.getFileName().toString();
                    if (!name.endsWith(".no_recover")) continue;
                    Files.delete(path);
                }
            }
            finally {
                if (paths != null) {
                    paths.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class FileLockedException
    extends IOException {
        public FileLockedException(Path path) {
            super(path.toString());
        }
    }
}

