/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.netty.handler.ipfilter;

import com.github.steveice10.netty.channel.ChannelHandler;
import com.github.steveice10.netty.channel.ChannelHandlerContext;
import com.github.steveice10.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import com.github.steveice10.netty.handler.ipfilter.IpFilterRule;
import com.github.steveice10.netty.handler.ipfilter.IpFilterRuleType;
import com.github.steveice10.netty.util.internal.ObjectUtil;
import java.net.InetSocketAddress;

@ChannelHandler.Sharable
public class RuleBasedIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final IpFilterRule[] rules;

    public RuleBasedIpFilter(IpFilterRule ... rules) {
        this.rules = ObjectUtil.checkNotNull(rules, "rules");
    }

    @Override
    protected boolean accept(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) throws Exception {
        for (IpFilterRule rule : this.rules) {
            if (rule == null) break;
            if (!rule.matches(remoteAddress)) continue;
            return rule.ruleType() == IpFilterRuleType.ACCEPT;
        }
        return true;
    }
}

