/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.equipment.gas_mask;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import rbasamoyai.createbigcannons.CBCTags;
import rbasamoyai.createbigcannons.index.CBCItems;

public class GasMaskItem
extends Item {
    private static final List<Predicate<LivingEntity>> IS_WEARING_PREDICATES = new ArrayList<Predicate<LivingEntity>>();
    private static final List<Predicate<Player>> OVERLAY_DISPLAY_PREDICATES = new ArrayList<Predicate<Player>>();

    public GasMaskItem(Item.Properties properties) {
        super(properties);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)ArmorItem.f_40376_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.m_21120_(usedHand);
        ItemStack itemStack2 = player.m_6844_(EquipmentSlot.HEAD);
        if (itemStack2.m_41619_()) {
            player.m_8061_(EquipmentSlot.HEAD, itemStack.m_41777_());
            if (!level.m_5776_()) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
            itemStack.m_41764_(0);
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public static boolean isWearingWorkingMask(LivingEntity entity) {
        for (Predicate<LivingEntity> predicate : IS_WEARING_PREDICATES) {
            if (!predicate.test(entity)) continue;
            return true;
        }
        return false;
    }

    public static boolean canShowGasMaskOverlay(Player player) {
        for (Predicate<Player> predicate : OVERLAY_DISPLAY_PREDICATES) {
            if (!predicate.test(player)) continue;
            return true;
        }
        return false;
    }

    public static void addIsWearingPredicate(Predicate<LivingEntity> predicate) {
        IS_WEARING_PREDICATES.add(predicate);
    }

    public static void addOverlayDisplayPredicate(Predicate<Player> predicate) {
        OVERLAY_DISPLAY_PREDICATES.add(predicate);
    }

    public static void registerDefaultHandlers() {
        GasMaskItem.addIsWearingPredicate(GasMaskItem::defaultHandler);
        GasMaskItem.addOverlayDisplayPredicate(GasMaskItem::defaultOverlayHandler);
    }

    private static boolean defaultHandler(LivingEntity entity) {
        return entity.m_6844_(EquipmentSlot.HEAD).m_204117_(CBCTags.CBCItemTags.GAS_MASKS);
    }

    private static boolean defaultOverlayHandler(Player player) {
        return player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)CBCItems.GAS_MASK.get());
    }
}

