/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.effects.particles.smoke;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.foundation.particle.ICustomParticleDataWithSprite;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import rbasamoyai.createbigcannons.effects.particles.smoke.CannonSmokeParticleData;
import rbasamoyai.createbigcannons.effects.particles.smoke.FallbackCannonSmokeParticle;
import rbasamoyai.createbigcannons.index.CBCParticleTypes;

public class FallbackCannonSmokeParticleData
implements ParticleOptions,
ICustomParticleDataWithSprite<FallbackCannonSmokeParticleData> {
    public static final Codec<FallbackCannonSmokeParticleData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.FLOAT.fieldOf("power").forGetter(data -> Float.valueOf(data.power)), (App)Codec.FLOAT.fieldOf("size").forGetter(data -> Float.valueOf(data.size)), (App)Codec.INT.fieldOf("lifetime").forGetter(data -> data.lifetime), (App)Codec.FLOAT.fieldOf("friction").forGetter(data -> Float.valueOf(data.friction))).apply((Applicative)i, FallbackCannonSmokeParticleData::new));
    public static final ParticleOptions.Deserializer<FallbackCannonSmokeParticleData> DESERIALIZER = new ParticleOptions.Deserializer<FallbackCannonSmokeParticleData>(){

        public FallbackCannonSmokeParticleData fromNetwork(ParticleType<FallbackCannonSmokeParticleData> type, FriendlyByteBuf buf) {
            float power = buf.readFloat();
            float size = buf.readFloat();
            int lifetime = buf.m_130242_();
            float friction = buf.readFloat();
            return new FallbackCannonSmokeParticleData(power, size, lifetime, friction);
        }

        public FallbackCannonSmokeParticleData fromCommand(ParticleType<FallbackCannonSmokeParticleData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float power = reader.readFloat();
            reader.expect(' ');
            float size = reader.readFloat();
            reader.expect(' ');
            int lifetime = reader.readInt();
            reader.expect(' ');
            float friction = reader.readFloat();
            return new FallbackCannonSmokeParticleData(power, size, lifetime, friction);
        }
    };
    private final float power;
    private final float size;
    private final int lifetime;
    private final float friction;

    public FallbackCannonSmokeParticleData(float power, float size, int lifetime, float friction) {
        this.power = power;
        this.size = size;
        this.lifetime = lifetime;
        this.friction = friction;
    }

    public FallbackCannonSmokeParticleData() {
        this(0.0f, 1.0f, 1, 1.0f);
    }

    public FallbackCannonSmokeParticleData(CannonSmokeParticleData source) {
        this(source.power(), source.size(), source.lifetime(), source.friction());
    }

    public float power() {
        return this.power;
    }

    public float size() {
        return this.size;
    }

    public int lifetime() {
        return this.lifetime;
    }

    public float friction() {
        return this.friction;
    }

    public ParticleType<?> m_6012_() {
        return CBCParticleTypes.CANNON_SMOKE_FALLBACK.get();
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeFloat(this.power).writeFloat(this.size);
        buf.m_130130_(this.lifetime).writeFloat(this.friction);
    }

    public String m_5942_() {
        return String.format("%f %f %d %f", Float.valueOf(this.power), Float.valueOf(this.size), this.lifetime, Float.valueOf(this.friction));
    }

    public ParticleOptions.Deserializer<FallbackCannonSmokeParticleData> getDeserializer() {
        return DESERIALIZER;
    }

    public Codec<FallbackCannonSmokeParticleData> getCodec(ParticleType<FallbackCannonSmokeParticleData> type) {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ParticleEngine.SpriteParticleRegistration<FallbackCannonSmokeParticleData> getMetaFactory() {
        return FallbackCannonSmokeParticle.Provider::new;
    }
}

