/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.boring;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.api.contraption.ContraptionType;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.piston.PistonExtensionPoleBlock;
import java.util.ArrayList;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import rbasamoyai.createbigcannons.base.PoleContraption;
import rbasamoyai.createbigcannons.crafting.boring.AbstractCannonDrillBlockEntity;
import rbasamoyai.createbigcannons.crafting.boring.CannonDrillBlock;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.index.CBCContraptionTypes;

public class CannonDrillingContraption
extends PoleContraption {
    private static final DirectionProperty FACING = BlockStateProperties.f_61372_;

    public CannonDrillingContraption() {
    }

    public CannonDrillingContraption(Direction orientation, boolean retract) {
        super(orientation, retract);
    }

    @Override
    protected boolean collectExtensions(Level level, BlockPos pos, Direction direction) throws AssemblyException {
        if (!CBCBlocks.CANNON_DRILL.has(level.m_8055_(pos))) {
            return false;
        }
        ArrayList<StructureTemplate.StructureBlockInfo> poles = new ArrayList<StructureTemplate.StructureBlockInfo>();
        BlockPos start = pos;
        BlockState nextBlock = level.m_8055_(start.m_121945_(direction));
        int extensionsInFront = 0;
        Direction.Axis blockAxis = direction.m_122434_();
        int maxPoles = CannonDrillBlock.maxAllowedDrillLength();
        PistonExtensionPoleBlock.PlacementHelper matcher = PistonExtensionPoleBlock.PlacementHelper.get();
        if (level.m_8055_(pos).m_61143_(CannonDrillBlock.STATE) == MechanicalPistonBlock.PistonState.EXTENDED) {
            while (matcher.matchesAxis(nextBlock, blockAxis) || CannonDrillingContraption.isDrillBit(nextBlock) && nextBlock.m_61143_((Property)FACING) == direction) {
                start = start.m_121945_(direction);
                poles.add(new StructureTemplate.StructureBlockInfo(start, (BlockState)nextBlock.m_61124_((Property)FACING, (Comparable)direction), null));
                ++extensionsInFront;
                if (CannonDrillingContraption.isDrillBit(nextBlock)) break;
                nextBlock = level.m_8055_(start.m_121945_(direction));
                if (extensionsInFront <= maxPoles) continue;
                throw new AssemblyException("tooManyPistonPoles", new Object[]{maxPoles});
            }
        }
        if (extensionsInFront == 0) {
            poles.add(new StructureTemplate.StructureBlockInfo(pos, (BlockState)CBCBlocks.CANNON_DRILL_BIT.getDefaultState().m_61124_((Property)FACING, (Comparable)direction), null));
        } else {
            poles.add(new StructureTemplate.StructureBlockInfo(pos, (BlockState)AllBlocks.PISTON_EXTENSION_POLE.getDefaultState().m_61124_((Property)FACING, (Comparable)direction), null));
        }
        BlockPos end = pos;
        int extensionsInBack = 0;
        Direction opposite = direction.m_122424_();
        nextBlock = level.m_8055_(end.m_121945_(opposite));
        while (matcher.matchesAxis(nextBlock, blockAxis)) {
            end = end.m_121945_(opposite);
            poles.add(new StructureTemplate.StructureBlockInfo(end, (BlockState)nextBlock.m_61124_((Property)FACING, (Comparable)direction), null));
            nextBlock = level.m_8055_(end.m_121945_(opposite));
            if (extensionsInFront + ++extensionsInBack <= maxPoles) continue;
            throw new AssemblyException("tooManyPistonPoles", new Object[]{maxPoles});
        }
        this.extensionLength = extensionsInFront + extensionsInBack;
        if (this.extensionLength == 0) {
            throw AssemblyException.noPistonPoles();
        }
        this.anchor = pos.m_5484_(direction, this.initialExtensionProgress + 1);
        this.initialExtensionProgress = extensionsInFront;
        this.pistonContraptionHitbox = new AABB(BlockPos.f_121853_, BlockPos.f_121853_.m_5484_(direction, -this.extensionLength - 1)).m_82363_(1.0, 1.0, 1.0);
        this.bounds = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        for (StructureTemplate.StructureBlockInfo pole : poles) {
            BlockPos relPos = pole.f_74675_().m_5484_(direction, -extensionsInFront);
            BlockPos localPos = relPos.m_121996_((Vec3i)this.anchor);
            this.getBlocks().put(localPos, new StructureTemplate.StructureBlockInfo(localPos, pole.f_74676_(), null));
        }
        return true;
    }

    private static boolean isDrillBit(BlockState state) {
        return CBCBlocks.CANNON_DRILL_BIT.has(state);
    }

    protected boolean addToInitialFrontier(Level world, BlockPos pos, Direction forcedDirection, Queue<BlockPos> frontier) throws AssemblyException {
        frontier.clear();
        return true;
    }

    protected boolean customBlockPlacement(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockPos levelPos = this.anchor.m_5484_(this.orientation, -1);
        BlockState drillState = level.m_8055_(levelPos);
        BlockEntity blockEntity = level.m_7702_(levelPos);
        if (pos.equals((Object)levelPos)) {
            if (!(blockEntity instanceof AbstractCannonDrillBlockEntity) || blockEntity.m_58901_()) {
                return true;
            }
            if (!AllBlocks.PISTON_EXTENSION_POLE.has(state)) {
                level.m_7731_(levelPos, (BlockState)drillState.m_61124_(CannonDrillBlock.STATE, (Comparable)MechanicalPistonBlock.PistonState.RETRACTED), 19);
            }
            return true;
        }
        return false;
    }

    protected boolean customBlockRemoval(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockPos drillPos = this.anchor.m_5484_(this.orientation, -1);
        BlockState drillState = level.m_8055_(drillPos);
        if (pos.equals((Object)drillPos) && CBCBlocks.CANNON_DRILL.has(drillState)) {
            level.m_7731_(drillPos, (BlockState)drillState.m_61124_(CannonDrillBlock.STATE, (Comparable)MechanicalPistonBlock.PistonState.MOVING), 82);
            return true;
        }
        return false;
    }

    public ContraptionType getType() {
        return (ContraptionType)CBCContraptionTypes.CANNON_DRILL.m_203334_();
    }
}

