/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.midi.client;

import com.finchy.pipeorgans.PipeOrgans;
import com.finchy.pipeorgans.network.PacketHandler;
import com.finchy.pipeorgans.network.packet.MidiMessageC2SPacket;
import com.finchy.pipeorgans.util.MidiUtils;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;

public class MidiDeviceInputReceiver
implements Receiver {
    private volatile boolean open = true;

    @Override
    public void send(MidiMessage message, long timeStamp) {
        if (this.open && message instanceof ShortMessage) {
            ShortMessage sm = (ShortMessage)message;
            this.handleMessage(sm);
        }
    }

    @Override
    public void close() {
        this.open = false;
    }

    protected void handleMessage(ShortMessage sm) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && PipeOrgans.getProxy().isClient()) {
            if (MidiUtils.isNoteOn(sm)) {
                this.sendNotePacket(Integer.valueOf(sm.getChannel()).byteValue(), sm.getMessage()[1], sm.getMessage()[2], (Player)player);
            } else if (MidiUtils.isNoteOff(sm)) {
                this.sendNotePacket(Integer.valueOf(sm.getChannel()).byteValue(), sm.getMessage()[1], Integer.valueOf(0).byteValue(), (Player)player);
            }
        }
    }

    public void sendNotePacket(Byte channel, Byte note, Byte velocity, Player player) {
        MidiMessageC2SPacket packet = MidiMessageC2SPacket.createNotePacket(channel, note, velocity, player.m_20148_(), player.m_20097_());
        PacketHandler.sendToServer(packet);
    }
}

