/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.midi.keyboardRelay;

import com.finchy.pipeorgans.PipeOrgans;
import com.finchy.pipeorgans.content.midi.stopMaster.StopMasterBlockEntity;
import com.finchy.pipeorgans.init.AllBlockEntities;
import com.finchy.pipeorgans.midi.server.MidiMessageServerObject;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class KeyboardRelayBlockEntity
extends SmartBlockEntity {
    private UUID user = null;
    private boolean deactivatedThisTick;
    private final List<BlockPos> linkedCoords = new ArrayList<BlockPos>();
    private int activeNotes;

    public KeyboardRelayBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)AllBlockEntities.KEYBOARD_RELAY_BLOCK_ENTITY.get(), pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        ListTag coordsList = new ListTag();
        for (BlockPos pos : this.linkedCoords) {
            CompoundTag posTag = new CompoundTag();
            posTag.m_128405_("x", pos.m_123341_());
            posTag.m_128405_("y", pos.m_123342_());
            posTag.m_128405_("z", pos.m_123343_());
            coordsList.add((Object)posTag);
        }
        tag.m_128365_("linked_coords", (Tag)coordsList);
        super.write(tag, clientPacket);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        ListTag coordsList = tag.m_128437_("linked_coords", 10);
        this.linkedCoords.clear();
        for (int i = 0; i < coordsList.size(); ++i) {
            CompoundTag posTag = coordsList.m_128728_(i);
            int x = posTag.m_128451_("x");
            int y = posTag.m_128451_("y");
            int z = posTag.m_128451_("z");
            this.linkedCoords.add(new BlockPos(x, y, z));
        }
        super.read(tag, clientPacket);
    }

    public void handleMidiObject(MidiMessageServerObject mm) {
        for (BlockPos pos : this.linkedCoords) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (!(blockEntity instanceof StopMasterBlockEntity)) continue;
            StopMasterBlockEntity sm = (StopMasterBlockEntity)blockEntity;
            sm.receiveMidiSignal(mm);
        }
        if (mm.velocity > 0) {
            if (this.activeNotes == 0) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)), 3);
            }
            ++this.activeNotes;
        } else if (this.activeNotes > 0) {
            --this.activeNotes;
            if (this.activeNotes == 0) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    public void linkStopMaster(StopMasterBlockEntity be) {
        BlockPos pos = be.m_58899_();
        if (!this.linkedCoords.contains(pos)) {
            this.linkedCoords.add(pos);
        }
        this.notifyUpdate();
    }

    public void removeStopMaster(StopMasterBlockEntity be) {
        this.linkedCoords.remove(be.m_58899_());
        this.notifyUpdate();
    }

    public void removeFromAllStopMasters() {
        for (BlockPos pos : this.linkedCoords) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (!(blockEntity instanceof StopMasterBlockEntity)) continue;
            StopMasterBlockEntity sm = (StopMasterBlockEntity)blockEntity;
            sm.removeSource();
        }
    }

    public void onBlockRemoved() {
        Entity playerEntity = ((ServerLevel)this.f_58857_).m_8791_(this.user);
        if (playerEntity instanceof Player) {
            this.tryStopUsing((Player)playerEntity);
        }
        this.removeFromAllStopMasters();
    }

    public void tryStartUsing(Player player) {
        PipeOrgans.LOGGER.info("TRY START USING");
        if (!this.deactivatedThisTick && !this.hasUser() && !KeyboardRelayBlockEntity.playerIsUsing(player) && KeyboardRelayBlockEntity.playerInRange(player, this.f_58857_, this.f_58858_)) {
            this.startUsing(player);
        }
    }

    public void tryStopUsing(Player player) {
        PipeOrgans.LOGGER.info("TRY STOP USING");
        if (this.isUsedBy(player)) {
            this.stopUsing(player);
        }
    }

    private void startUsing(Player player) {
        this.user = player.m_20148_();
        player.getPersistentData().m_128385_("UsingKBRelayPos", new int[]{this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_()});
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)), 3);
        this.notifyUpdate();
    }

    private void stopUsing(Player player) {
        PipeOrgans.LOGGER.info("STOP USING");
        this.user = null;
        if (player != null) {
            player.getPersistentData().m_128473_("UsingKBRelayPos");
        }
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)), 3);
        this.deactivatedThisTick = true;
        this.notifyUpdate();
    }

    public static boolean playerIsUsing(Player player) {
        return player.getPersistentData().m_128441_("UsingKBRelayPos");
    }

    public static BlockPos playerUsingKBRPos(Player player) {
        if (player.getPersistentData().m_128441_("UsingKBRelayPos")) {
            int[] pos = player.getPersistentData().m_128465_("UsingKBRelayPos");
            return new BlockPos(pos[0], pos[1], pos[2]);
        }
        return null;
    }

    public boolean isUsedBy(Player player) {
        return this.hasUser() && this.user.equals(player.m_20148_());
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public void tick() {
        if (!this.f_58857_.f_46443_) {
            this.deactivatedThisTick = false;
            if (!(this.f_58857_ instanceof ServerLevel) || this.user == null) {
                return;
            }
            Entity entity = ((ServerLevel)this.f_58857_).m_8791_(this.user);
            if (!(entity instanceof Player)) {
                this.stopUsing(null);
                return;
            }
            Player player = (Player)entity;
            if (!KeyboardRelayBlockEntity.playerInRange(player, this.f_58857_, this.f_58858_) || !KeyboardRelayBlockEntity.playerIsUsing(player)) {
                this.stopUsing(player);
            }
        }
    }

    public static boolean playerInRange(Player player, Level world, BlockPos pos) {
        if (player.m_9236_() != world) {
            return false;
        }
        double reach = 0.4 * player.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get());
        return player.m_20238_(Vec3.m_82512_((Vec3i)pos)) < reach * reach;
    }
}

