/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_power_loader.content.brasschunkloader;

import com.hlysine.create_power_loader.CPLIcons;
import com.hlysine.create_power_loader.content.AbstractChunkLoaderBlock;
import com.hlysine.create_power_loader.content.AbstractChunkLoaderBlockEntity;
import com.hlysine.create_power_loader.content.LoaderType;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.gui.AllIcons;
import java.util.List;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
public class BrassChunkLoaderBlockEntity
extends AbstractChunkLoaderBlockEntity {
    protected ScrollOptionBehaviour<LoadingRange> loadingRange;

    public BrassChunkLoaderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, LoaderType.BRASS);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.loadingRange = new ScrollOptionBehaviour(LoadingRange.class, (Component)Component.m_237115_((String)"create_power_loader.brass_chunk_loader.loading_range"), (SmartBlockEntity)this, (ValueBoxTransform)new LoadingRangeValueBox());
        this.loadingRange.value = 0;
        this.loadingRange.withCallback(i -> {
            boolean server;
            boolean bl = server = (!this.f_58857_.f_46443_ || this.isVirtual()) && this.f_58857_ instanceof ServerLevel;
            if (server) {
                this.updateForcedChunks();
            }
        });
        this.loadingRange.onlyActiveWhen(() -> (Boolean)this.m_58900_().m_61143_((Property)AbstractChunkLoaderBlock.ATTACHED) == false);
        behaviours.add((BlockEntityBehaviour)this.loadingRange);
    }

    @Override
    public int getLoadingRange() {
        return this.loadingRange.getValue() + 1;
    }

    public void setLoadingRange(int range) {
        this.loadingRange.setValue(range - 1);
    }

    public static enum LoadingRange implements INamedIconOptions
    {
        LOAD_1x1(CPLIcons.I_1x1),
        LOAD_3x3(CPLIcons.I_3x3),
        LOAD_5x5(CPLIcons.I_5x5);

        private final String translationKey;
        private final AllIcons icon;

        private LoadingRange(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "create_power_loader.brass_chunk_loader." + Lang.asId((String)this.name());
        }

        public AllIcons getIcon() {
            return this.icon;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }
    }

    private static class LoadingRangeValueBox
    extends CenteredSideValueBoxTransform {
        public LoadingRangeValueBox() {
            super((blockState, direction) -> {
                Direction facing = (Direction)blockState.m_61143_((Property)AbstractChunkLoaderBlock.FACING);
                return facing.m_122434_() != direction.m_122434_();
            });
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)15.5);
        }

        public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
            Direction facing = (Direction)state.m_61143_((Property)AbstractChunkLoaderBlock.FACING);
            return super.getLocalOffset(level, pos, state).m_82549_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(-0.25));
        }

        public float getScale() {
            return super.getScale();
        }
    }
}

