/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.bulk_fermenter;

import com.jesz.createdieselgenerators.CDGBlockEntityTypes;
import com.jesz.createdieselgenerators.CDGRecipes;
import com.jesz.createdieselgenerators.content.bulk_fermenter.BulkFermentingRecipe;
import com.jesz.createdieselgenerators.content.bulk_fermenter.IMultiBlockEntityContainerFluidItem;
import com.jesz.createdieselgenerators.content.distillation.DistillationRecipe;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryWrapper;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class BulkFermenterBlockEntity
extends SmartBlockEntity
implements IMultiBlockEntityContainerFluidItem,
IHaveGoggleInformation {
    private static final int MAX_SIZE = 3;
    LazyOptional<IItemHandler> itemCapability;
    public ItemStackHandler inventory;
    LazyOptional<IFluidHandler> fluidCapability;
    BulkFermenterFluidHandler tankInventory;
    BlockPos controller;
    BlockPos lastKnownPos;
    boolean updateConnectivity = false;
    int width = 1;
    int height = 1;
    private static final int SYNC_RATE = 8;
    int syncCooldown;
    boolean queuedSync;
    public int processingTime = -1;
    BulkFermentingRecipe currentRecipe;
    BlazeBurnerBlock.HeatLevel lowestHeatLevel = BlazeBurnerBlock.HeatLevel.NONE;
    static final Object RECIPE_CACHE_KEY = new Object();

    public BulkFermenterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tankInventory = this.createInventory();
        this.fluidCapability = LazyOptional.of(() -> this.tankInventory);
        this.inventory = new ItemStackHandler(5){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                List<Recipe<?>> r = BulkFermenterBlockEntity.this.getMatchingRecipes();
                if (!r.contains((Object)BulkFermenterBlockEntity.this.currentRecipe)) {
                    BulkFermenterBlockEntity.this.processingTime = -1;
                }
                if (BulkFermenterBlockEntity.this.processingTime == -1 && !r.isEmpty()) {
                    BulkFermenterBlockEntity.this.currentRecipe = (BulkFermentingRecipe)r.get(0);
                    BulkFermenterBlockEntity.this.startProcessing();
                }
                if (!((BulkFermenterBlockEntity)BulkFermenterBlockEntity.this).f_58857_.f_46443_) {
                    BulkFermenterBlockEntity.this.m_6596_();
                    BulkFermenterBlockEntity.this.sendData();
                }
            }
        };
        this.itemCapability = LazyOptional.of(() -> this.inventory);
        LazyOptional<IFluidHandler> oldCap = this.fluidCapability;
        this.fluidCapability = LazyOptional.of(() -> this.handlerForCapability());
        oldCap.invalidate();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected BulkFermenterFluidHandler createInventory() {
        return new BulkFermenterFluidHandler(6, BulkFermenterBlockEntity.getCapacityMultiplier(), f -> this.onFluidStackChanged());
    }

    public void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    private void startProcessing() {
        if (this.currentRecipe == null) {
            return;
        }
        this.processingTime = this.currentRecipe.getProcessingDuration();
        this.sendData();
    }

    public void tick() {
        if (this.isController()) {
            List<Recipe<?>> r;
            if (this.processingTime >= 0) {
                if (!this.f_58857_.f_46443_ && this.processingTime % 20 == 0 && new Random().nextInt() % 4 == 0) {
                    this.f_58857_.m_5594_(null, this.f_58858_.m_7918_(this.width / 2, this.height / 2, this.width / 2), SoundEvents.f_11774_, SoundSource.BLOCKS, 0.15f, 0.75f);
                }
                if (this.processingTime == 1) {
                    this.f_58857_.m_5594_(null, this.f_58858_.m_7918_(this.width / 2, this.height / 2, this.width / 2), SoundEvents.f_11772_, SoundSource.BLOCKS, 0.15f, 0.75f);
                }
                if (this.currentRecipe == null) {
                    r = this.getMatchingRecipes();
                    if (r.isEmpty()) {
                        this.processingTime = -1;
                    } else {
                        this.currentRecipe = (BulkFermentingRecipe)r.get(0);
                    }
                } else if (this.processingTime == 0 && !this.f_58857_.f_46443_) {
                    this.currentRecipe.apply(this, false);
                    this.processingTime = -1;
                } else {
                    this.processingTime = (int)Math.max(0.0, (double)this.processingTime - Math.sqrt(this.width * this.height));
                }
            }
            if (this.processingTime == -1 && this.currentRecipe != null) {
                r = this.getMatchingRecipes();
                this.currentRecipe = null;
                if (!r.contains((Object)this.currentRecipe)) {
                    this.processingTime = -1;
                }
                if (this.processingTime == -1 && !r.isEmpty()) {
                    this.currentRecipe = (BulkFermentingRecipe)r.get(0);
                    this.startProcessing();
                }
                if (!this.f_58857_.f_46443_) {
                    this.m_6596_();
                    this.sendData();
                }
            }
        }
        super.tick();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.m_58899_();
        } else if (!this.lastKnownPos.equals((Object)this.f_58858_) && this.f_58858_ != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
    }

    protected List<Recipe<?>> getMatchingRecipes() {
        List list = RecipeFinder.get((Object)RECIPE_CACHE_KEY, (Level)this.f_58857_, recipe -> recipe.m_6671_() == CDGRecipes.BULK_FERMENTING.getType());
        return list.stream().sorted((r1, r2) -> {
            if (r1 instanceof DistillationRecipe) {
                DistillationRecipe recipe1 = (DistillationRecipe)((Object)r1);
                if (r2 instanceof DistillationRecipe) {
                    DistillationRecipe recipe2 = (DistillationRecipe)((Object)r2);
                    return recipe2.getRequiredHeat().ordinal() - recipe1.getRequiredHeat().ordinal();
                }
            }
            return 0;
        }).filter(r -> ((BulkFermentingRecipe)((Object)r)).apply(this, true)).collect(Collectors.toList());
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.f_58858_.m_123341_() == this.controller.m_123341_() && this.f_58858_.m_123342_() == this.controller.m_123342_() && this.f_58858_.m_123343_() == this.controller.m_123343_();
    }

    public void initialize() {
        super.initialize();
        this.sendData();
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.f_58858_;
    }

    protected void onFluidStackChanged() {
        if (!this.m_58898_()) {
            return;
        }
        List<Recipe<?>> r = this.getMatchingRecipes();
        if (!r.contains((Object)this.currentRecipe)) {
            this.processingTime = -1;
        }
        if (this.processingTime == -1 && !r.isEmpty()) {
            this.currentRecipe = (BulkFermentingRecipe)r.get(0);
            this.startProcessing();
        }
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.f_58858_.m_7918_(xOffset, yOffset, zOffset);
                    BulkFermenterBlockEntity tankAt = (BulkFermenterBlockEntity)ConnectivityHandler.partAt((BlockEntityType)this.m_58903_(), (BlockGetter)this.f_58857_, (BlockPos)pos);
                    if (tankAt == null) continue;
                    this.f_58857_.m_46717_(pos, tankAt.m_58900_().m_60734_());
                }
            }
        }
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
            this.sendData();
        }
    }

    public BulkFermenterBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof BulkFermenterBlockEntity) {
            return (BulkFermenterBlockEntity)blockEntity;
        }
        return null;
    }

    public void applyFluidTankSize(int blocks) {
        this.tankInventory.setCapacity(blocks * BulkFermenterBlockEntity.getCapacityMultiplier());
    }

    public void removeController(boolean keepContents) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepContents) {
            this.applyFluidTankSize(1);
        }
        this.controller = null;
        this.width = 1;
        this.height = 1;
        this.onFluidStackChanged();
        this.refreshCapability();
        this.m_6596_();
        this.sendData();
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void setController(BlockPos controller) {
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.m_6596_();
        this.sendData();
    }

    private void refreshCapability() {
        LazyOptional<IFluidHandler> oldCap = this.fluidCapability;
        this.fluidCapability = LazyOptional.of(() -> this.handlerForCapability());
        oldCap.invalidate();
    }

    void initCapability() {
        if (!this.isController()) {
            BulkFermenterBlockEntity controllerBE = this.getControllerBE();
            if (controllerBE == null) {
                return;
            }
            controllerBE.initCapability();
            this.itemCapability.invalidate();
            this.itemCapability = controllerBE.itemCapability;
            return;
        }
        IItemHandlerModifiable[] inventories = new IItemHandlerModifiable[this.height * this.width * this.width];
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos vaultPos = this.f_58858_.m_7918_(xOffset, yOffset, zOffset);
                    BulkFermenterBlockEntity tankAt = (BulkFermenterBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)CDGBlockEntityTypes.BULK_FERMENTER.get()), (BlockGetter)this.f_58857_, (BlockPos)vaultPos);
                    inventories[yOffset * this.width * this.width + xOffset * this.width + zOffset] = tankAt != null ? tankAt.inventory : new ItemStackHandler();
                }
            }
        }
        VersionedInventoryWrapper itemHandler = new VersionedInventoryWrapper((IItemHandlerModifiable)new CombinedInvWrapper(inventories){

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                int i;
                for (i = 0; i < this.getSlots(); ++i) {
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)this.getStackInSlot(i), (ItemStack)stack)) continue;
                    int space = this.getSlotLimit(i) - this.getStackInSlot(i).m_41613_();
                    if (space == 0) {
                        return stack;
                    }
                    return super.insertItem(i, stack, simulate).m_255036_(stack.m_41613_() - Math.min(stack.m_41613_(), space));
                }
                for (i = 0; i < this.getSlots(); ++i) {
                    if (!this.getStackInSlot(i).m_41619_()) continue;
                    return super.insertItem(i, stack, simulate);
                }
                return stack;
            }
        });
        this.itemCapability.invalidate();
        this.itemCapability = LazyOptional.of(() -> BulkFermenterBlockEntity.lambda$initCapability$8((IItemHandler)itemHandler));
    }

    private IFluidHandler handlerForCapability() {
        return this.isController() ? this.tankInventory : (this.getControllerBE() != null ? this.getControllerBE().handlerForCapability() : new BulkFermenterFluidHandler(0, 0, fs -> {}));
    }

    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controller;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.width;
        int prevHeight = this.height;
        this.updateConnectivity = compound.m_128441_("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("LastKnownPos"));
        }
        if (compound.m_128441_("Controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
        }
        if (this.isController()) {
            this.width = compound.m_128451_("Size");
            this.height = compound.m_128451_("Height");
            this.lowestHeatLevel = BlazeBurnerBlock.HeatLevel.values()[compound.m_128451_("Heat")];
            this.tankInventory.setCapacity(this.getTotalTankSize() * BulkFermenterBlockEntity.getCapacityMultiplier());
            this.tankInventory.readFromNBT(compound.m_128469_("TankContent"));
            this.processingTime = compound.m_128451_("ProcessingTime");
        }
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        if (!clientPacket) {
            return;
        }
        boolean bl = changeOfController = !Objects.equals(controllerBefore, this.controller);
        if (this.m_58898_() && (changeOfController || prevSize != this.width || prevHeight != this.height)) {
            this.f_58857_.m_6550_(this.m_58899_(), Blocks.f_50016_.m_49966_(), this.m_58900_());
            if (this.isController()) {
                this.tankInventory.setCapacity(BulkFermenterBlockEntity.getCapacityMultiplier() * this.getTotalTankSize());
            }
        }
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        if (this.updateConnectivity) {
            compound.m_128379_("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.m_128365_("TankContent", (Tag)this.tankInventory.writeToNBT(new CompoundTag()));
            compound.m_128405_("Size", this.width);
            compound.m_128405_("Height", this.height);
            compound.m_128405_("ProcessingTime", this.processingTime);
            compound.m_128405_("Heat", this.lowestHeatLevel.ordinal());
        }
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        if (!clientPacket) {
            return;
        }
        if (this.queuedSync) {
            compound.m_128379_("LazySync", true);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.fluidCapability.isPresent()) {
            this.refreshCapability();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            this.initCapability();
            return this.itemCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public int getTotalTankSize() {
        return this.width * this.width * this.height;
    }

    public static int getCapacityMultiplier() {
        return (Integer)AllConfigs.server().fluids.fluidTankCapacity.get() * 1000;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        this.itemCapability.invalidate();
        this.onFluidStackChanged();
        this.m_6596_();
    }

    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        return (Integer)AllConfigs.server().fluids.fluidTankCapacity.get();
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean hasTank() {
        return true;
    }

    public int getTankSize(int tank) {
        return BulkFermenterBlockEntity.getCapacityMultiplier();
    }

    public void setTankSize(int tank, int blocks) {
        this.applyFluidTankSize(blocks);
    }

    public IFluidTank getTank(int tank) {
        return (IFluidTank)this.tankInventory.tanks.get(tank);
    }

    public FluidStack getFluid(int tank) {
        return this.tankInventory.getFluidInTank(tank).copy();
    }

    public BulkFermentingRecipe getRecipe() {
        return this.currentRecipe;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        BulkFermenterBlockEntity controller = this.getControllerBE();
        if (controller == null) {
            return false;
        }
        IItemHandler items = (IItemHandler)controller.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        IFluidHandler fluids = (IFluidHandler)controller.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (items == null || fluids == null) {
            return false;
        }
        boolean isEmpty = true;
        CreateLang.translate((String)"gui.goggles.basin_contents", (Object[])new Object[0]).forGoggles(tooltip);
        HashMap<Item, Integer> allItems = new HashMap<Item, Integer>();
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack stackInSlot = items.getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            if (allItems.containsKey(stackInSlot.m_41720_())) {
                allItems.replace(stackInSlot.m_41720_(), stackInSlot.m_41613_() + (Integer)allItems.get(stackInSlot.m_41720_()));
            } else {
                allItems.put(stackInSlot.m_41720_(), stackInSlot.m_41613_());
            }
            isEmpty = false;
        }
        for (Map.Entry e : allItems.entrySet()) {
            CreateLang.text((String)"").add(Component.m_237115_((String)((Item)e.getKey()).m_5524_()).m_130940_(ChatFormatting.GRAY)).add(CreateLang.text((String)(" x" + e.getValue())).style(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
        }
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        for (int i = 0; i < fluids.getTanks(); ++i) {
            FluidStack fluidStack = fluids.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            CreateLang.text((String)"").add(CreateLang.fluidName((FluidStack)fluidStack).add(CreateLang.text((String)" ")).style(ChatFormatting.GRAY).add(CreateLang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.BLUE))).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (isEmpty) {
            tooltip.remove(0);
        }
        return true;
    }

    public void updateHeat() {
        BulkFermenterBlockEntity controller = this.getControllerBE();
        int width = controller == null ? 1 : controller.width;
        BlazeBurnerBlock.HeatLevel lowestHeat = BlazeBurnerBlock.HeatLevel.SEETHING;
        for (int xOffset = 0; xOffset < width; ++xOffset) {
            for (int zOffset = 0; zOffset < width; ++zOffset) {
                BlockPos pos = this.getController().m_7918_(xOffset, -1, zOffset);
                BlockState blockState = this.f_58857_.m_8055_(pos);
                BlazeBurnerBlock.HeatLevel heat = BasinBlockEntity.getHeatLevelOf((BlockState)blockState);
                if (heat.isAtLeast(lowestHeat)) continue;
                lowestHeat = heat;
            }
        }
        this.lowestHeatLevel = lowestHeat;
        List<Recipe<?>> r = this.getMatchingRecipes();
        if (!r.contains((Object)this.currentRecipe)) {
            this.processingTime = -1;
        }
        if (this.processingTime == -1 && !r.isEmpty()) {
            this.currentRecipe = (BulkFermentingRecipe)r.get(0);
            this.startProcessing();
        }
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
            this.sendData();
        }
    }

    private static /* synthetic */ IItemHandler lambda$initCapability$8(IItemHandler itemHandler) {
        return itemHandler;
    }

    public static class BulkFermenterFluidHandler
    implements IFluidHandler {
        int tankCount;
        NonNullList<FluidTank> tanks = NonNullList.m_122779_();
        Consumer<FluidStack> updateCallback;

        public BulkFermenterFluidHandler(int tankCount, int capacity, Consumer<FluidStack> updateCallback) {
            for (int i = 0; i < tankCount; ++i) {
                this.tanks.add((Object)new FluidTank(capacity));
            }
            this.tankCount = tankCount;
            this.updateCallback = updateCallback;
        }

        public int getTanks() {
            return this.tankCount;
        }

        public FluidStack getFluidInTank(int tank) {
            return ((FluidTank)this.tanks.get(tank)).getFluid();
        }

        public int getTankCapacity(int tank) {
            return ((FluidTank)this.tanks.get(tank)).getCapacity();
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return true;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            for (FluidTank tank : this.tanks) {
                if (!tank.getFluid().isFluidEqual(resource)) continue;
                int result = tank.fill(resource, action);
                if (action.execute()) {
                    this.updateCallback.accept(tank.getFluid());
                }
                return result;
            }
            for (FluidTank tank : this.tanks) {
                if (!tank.getFluid().isEmpty()) continue;
                int result = tank.fill(resource, action);
                if (action.execute()) {
                    this.updateCallback.accept(tank.getFluid());
                }
                return result;
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            for (FluidTank tank : this.tanks) {
                if (!tank.getFluid().isFluidEqual(resource)) continue;
                FluidStack result = tank.drain(resource, action);
                if (action.execute()) {
                    this.updateCallback.accept(tank.getFluid());
                }
                return result;
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            for (FluidTank tank : this.tanks) {
                if (tank.getFluid().isEmpty()) continue;
                FluidStack result = tank.drain(maxDrain, action);
                if (action.execute()) {
                    this.updateCallback.accept(tank.getFluid());
                }
                return result;
            }
            return FluidStack.EMPTY;
        }

        public CompoundTag writeToNBT(CompoundTag compound) {
            ListTag list = new ListTag();
            for (FluidTank tank : this.tanks) {
                list.add((Object)tank.writeToNBT(new CompoundTag()));
            }
            compound.m_128365_("Tanks", (Tag)list);
            return compound;
        }

        public void readFromNBT(CompoundTag compound) {
            for (int i = 0; i < this.tanks.size(); ++i) {
                FluidTank tank = (FluidTank)this.tanks.get(i);
                tank.setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)compound.m_128437_("Tanks", 10).m_128728_(i)));
            }
        }

        public void setCapacity(int capacity) {
            for (FluidTank tank : this.tanks) {
                tank.setCapacity(capacity);
                tank.drain(Math.max(0, tank.getFluidAmount() - capacity), IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }
}

