/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.modules.forge.stone_chest;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.api.EntrySet;
import net.mehvahdjukaar.every_compat.api.ItemOnlyEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.stone_zone.StoneZone;
import net.mehvahdjukaar.stone_zone.api.StoneZoneEntrySet;
import net.mehvahdjukaar.stone_zone.api.StoneZoneModule;
import net.mehvahdjukaar.stone_zone.api.set.StoneType;
import net.mehvahdjukaar.stone_zone.api.set.StoneTypeRegistry;
import net.mehvahdjukaar.stone_zone.common_classes.CompatChestBlock;
import net.mehvahdjukaar.stone_zone.common_classes.CompatChestBlockEntity;
import net.mehvahdjukaar.stone_zone.common_classes.CompatChestBlockRenderer;
import net.mehvahdjukaar.stone_zone.common_classes.CompatChestItem;
import net.mehvahdjukaar.stone_zone.common_classes.CompatChestTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;

public class StoneChestModule
extends StoneZoneModule {
    public final SimpleEntrySet<StoneType, Block> chests;
    public final ItemOnlyEntrySet<StoneType, Item> parts;

    public StoneChestModule(String modId) {
        super(modId, "sc");
        ResourceKey tab = CreativeModeTabs.f_256791_;
        this.chests = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)StoneZoneEntrySet.of(StoneType.class, "", "chest", this.getModBlock("chest_stone"), StoneTypeRegistry::getStoneType, stoneType -> new CompatChestBlock(this::getTile, Utils.copyPropertySafe((Block)stoneType.stone))).addTile((x$0, x$1) -> new VariantChestBlockEntity((BlockPos)x$0, (BlockState)x$1)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(BlockTags.f_13088_, Registries.f_256747_)).addTag(Tags.Blocks.CHESTS, Registries.f_256747_)).addTag(Tags.Items.CHESTS, Registries.f_256913_)).setTabKey(tab)).defaultRecipe().addCustomItem((stoneType, block, properties) -> new CompatChestItem((Block)block, (Item.Properties)properties)).build();
        this.addEntry((EntrySet)this.chests);
        this.parts = ((ItemOnlyEntrySet.Builder)((ItemOnlyEntrySet.Builder)((ItemOnlyEntrySet.Builder)((ItemOnlyEntrySet.Builder)((ItemOnlyEntrySet.Builder)ItemOnlyEntrySet.builder(StoneType.class, (String)"", (String)"part", (Supplier)this.getModItem("part_stone"), StoneTypeRegistry::getStoneType, stoneType -> new Item(new Item.Properties())).copyParentTint()).createPaletteFromChild(p -> {
            while (p.size() > 4) {
                p.reduceUp();
            }
        }, "stone")).addTextureM(this.modRes("item/part_stone"), StoneZone.res("item/sc/part_stone_m"))).addModelTransform(m -> m.addModifier((s, blockId, stoneType) -> s.replace("\"stonechest:item/part_stone\"", "\"" + String.valueOf(StoneZone.res("item/" + this.shortenedId() + "/" + stoneType.getAppendableIdWith("part", ""))) + "\"")))).setTabKey(tab)).defaultRecipe().build();
        this.addEntry((EntrySet)this.parts);
    }

    private BlockEntityType<? extends ChestBlockEntity> getTile() {
        return this.chests.getTile(CompatChestBlockEntity.class);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        super.registerBlockEntityRenderers(event);
        CompatChestBlockRenderer.register(event, (BlockEntityType<CompatChestBlockEntity>)this.chests.getTile(CompatChestBlockEntity.class), this.shortenedId());
    }

    @Override
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept((manager, sink) -> this.chests.blocks.forEach((stoneType, block) -> {
            CompatChestTexture.generateChestTexture(sink, manager, this.shortenedId(), stoneType, block, this.modRes("entity/chest/stone"), StoneZone.res("entity/sc/stone_m"), StoneZone.res("entity/sc/stone_o"), null);
            CompatChestTexture.generateChestTexture(sink, manager, this.shortenedId(), stoneType, block, this.modRes("entity/chest/stone_left"), StoneZone.res("entity/sc/stone_left_m"), StoneZone.res("entity/sc/stone_left_o"), null);
            CompatChestTexture.generateChestTexture(sink, manager, this.shortenedId(), stoneType, block, this.modRes("entity/chest/stone_right"), StoneZone.res("entity/sc/stone_right_m"), StoneZone.res("entity/sc/stone_right_o"), null);
        }));
    }

    private class VariantChestBlockEntity
    extends CompatChestBlockEntity {
        public VariantChestBlockEntity(BlockPos pos, BlockState state) {
            super(StoneChestModule.this.chests.getTile(), pos, state);
        }
    }
}

