/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.misc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.stone_zone.StoneZone;
import net.mehvahdjukaar.stone_zone.api.StoneZoneModule;
import net.mehvahdjukaar.stone_zone.misc.TintConfiguration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.Nullable;

public final class ModelUtils {
    private static final Pattern PATH_PATTERN = Pattern.compile("(?<folder>.*?)(?<path>/.*$)");
    private static final Set<ResourceLocation> RESOLVED_PARENTS = new HashSet<ResourceLocation>();

    public static void reset() {
        RESOLVED_PARENTS.clear();
    }

    public static ResourceLocation transformModelID(ResourceLocation id) {
        Matcher matcher = PATH_PATTERN.matcher(id.m_135815_());
        if (!matcher.find() || id.m_135827_().contains("stonezone")) {
            return id;
        }
        return StoneZone.res(matcher.group("folder") + "/" + id.m_135827_() + matcher.group("path"));
    }

    public static void addTintIndexToModelAndReplaceParent(ResourceLocation oldRes, JsonObject jsonObject, @Nullable SimpleModule module, @Nullable String ignoreIfFromStone, TintConfiguration config) {
        ModelUtils.replaceParent(jsonObject, module, ignoreIfFromStone, config);
        ModelUtils.addTintIndexToModel(oldRes, jsonObject, 0, config);
    }

    private static void replaceParent(JsonObject jsonObject, @Nullable SimpleModule module, @Nullable String ignoreIfFromStone, TintConfiguration config) {
        if (jsonObject.has("parent")) {
            ResourceLocation oldRes = new ResourceLocation(jsonObject.get("parent").getAsString());
            String path = oldRes.m_135815_();
            int idx = path.lastIndexOf("/");
            if (ignoreIfFromStone != null && idx != -1 && path.substring(idx + 1).contains(ignoreIfFromStone) && !path.contains("/parent/") && !path.contains("template")) {
                return;
            }
            if (!oldRes.toString().matches("minecraft:(?:item/generated|builtin/generated|item/chest)")) {
                ResourceLocation newRes = ModelUtils.transformModelID(oldRes);
                jsonObject.addProperty("parent", newRes.toString());
                if (module instanceof StoneZoneModule) {
                    StoneZoneModule stonezoneModule = (StoneZoneModule)module;
                    if (!RESOLVED_PARENTS.contains(oldRes) && !oldRes.m_135827_().matches("stonezone")) {
                        stonezoneModule.markModelForModification(oldRes, config);
                        RESOLVED_PARENTS.add(oldRes);
                    }
                }
            }
        }
    }

    private static void addTintIndexToModel(ResourceLocation oldRes, JsonObject jsonObject, int tintIndex, TintConfiguration config) {
        JsonElement elements = jsonObject.get("elements");
        if (elements != null) {
            for (JsonElement element : elements.getAsJsonArray()) {
                JsonObject elementObject;
                JsonObject faces;
                if (!(element instanceof JsonObject) || (faces = (elementObject = (JsonObject)element).getAsJsonObject("faces")) == null) continue;
                for (String keyFaces : faces.keySet()) {
                    JsonObject face = faces.getAsJsonObject(keyFaces);
                    String textureValue = face.get("texture").getAsString();
                    if (!face.has("tintindex")) {
                        if (!config.isExcluded(textureValue) || !config.isTextureExcludedFor(oldRes, textureValue)) continue;
                        face.addProperty("tintindex", (Number)tintIndex);
                        continue;
                    }
                    if (!face.get("tintindex").getAsString().equals(String.valueOf(tintIndex)) || config.isExcluded(textureValue) && config.isTextureExcludedFor(oldRes, textureValue)) continue;
                    face.remove("tintindex");
                }
            }
        }
    }

    public static Map<ResourceLocation, JsonObject> readAllModelsAndParents(ResourceManager manager, Collection<ResourceLocation> models) {
        HashMap<ResourceLocation, JsonObject> jsonObjects = new HashMap<ResourceLocation, JsonObject>();
        for (ResourceLocation res : models) {
            if (res.m_135827_().matches("stonezone")) continue;
            ModelUtils.readJsonsRecursive(manager, res, jsonObjects);
        }
        return jsonObjects;
    }

    private static void readJsonsRecursive(ResourceManager manager, ResourceLocation res, Map<ResourceLocation, JsonObject> jsonObjects) {
        StaticResource resource = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.MODELS.getPath(res));
        if (resource != null) {
            JsonObject json = GsonHelper.m_13864_((String)new String(resource.data)).getAsJsonObject();
            jsonObjects.put(res, json);
            if (json.has("parent")) {
                ResourceLocation parent = new ResourceLocation(json.get("parent").getAsString());
                if (RESOLVED_PARENTS.contains(parent)) {
                    return;
                }
                RESOLVED_PARENTS.add(parent);
                ModelUtils.readJsonsRecursive(manager, parent, jsonObjects);
            }
        }
    }
}

