/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.common_classes;

import net.mehvahdjukaar.stone_zone.api.set.StoneType;
import net.mehvahdjukaar.stone_zone.api.set.StoneTypeRegistry;
import net.mehvahdjukaar.stone_zone.common_classes.CompatTrappedChestBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class CompatChestBlockEntity
extends ChestBlockEntity {
    private final StoneType stoneType;
    private final boolean trapped;
    private float[] tint = null;

    public CompatChestBlockEntity(BlockEntityType<?> arg, BlockPos pos, BlockState state) {
        super(arg, pos, state);
        StoneType stone = (StoneType)StoneTypeRegistry.INSTANCE.getBlockTypeOf((ItemLike)state.m_60734_());
        this.stoneType = stone == null ? StoneTypeRegistry.getStoneType() : stone;
        this.trapped = state.m_60734_() instanceof CompatTrappedChestBlock;
    }

    public float[] getTint() {
        if (this.tint == null) {
            int color = Minecraft.m_91087_().m_91298_().m_92577_(this.stoneType.stone.m_49966_(), (BlockAndTintGetter)this.f_58857_, this.f_58858_, 0);
            this.tint = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f};
        }
        return this.tint;
    }

    public StoneType getStoneType() {
        return this.stoneType;
    }

    protected void m_142151_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, int eventId, int eventParam) {
        super.m_142151_(level, pos, state, eventId, eventParam);
        if (this.trapped && eventId != eventParam) {
            Block block = state.m_60734_();
            level.m_46672_(pos, block);
            level.m_46672_(pos.m_7495_(), block);
        }
    }

    public boolean isTrapped() {
        return this.trapped;
    }
}

