/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.stone_zone.SZRegistry;
import net.mehvahdjukaar.stone_zone.api.StoneZoneEntrySet;
import net.mehvahdjukaar.stone_zone.api.set.StoneType;
import net.mehvahdjukaar.stone_zone.misc.HardcodedBlockType;
import net.mehvahdjukaar.stone_zone.misc.ModelUtils;
import net.mehvahdjukaar.stone_zone.misc.TintConfiguration;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;

public class StoneZoneModule
extends SimpleModule {
    private final Map<ResourceLocation, TintConfiguration> modelsToModify = new HashMap<ResourceLocation, TintConfiguration>();

    public StoneZoneModule(String modId, String shortId) {
        super(modId, shortId, "stonezone");
    }

    public ResourceKey<CreativeModeTab> getDedicatedTab() {
        return SZRegistry.MOD_TAB.getKey();
    }

    public String toString() {
        return "StoneZone " + LangBuilder.getReadableName((String)this.modId) + " Module";
    }

    public ResourceLocation makeMyRes(String name) {
        return super.makeMyRes(name);
    }

    public boolean isEntryAlreadyRegistered(String blockId, BlockType blockType, Registry<?> registry) {
        StoneType stoneType;
        Boolean hardcoded;
        String blockName = blockId.substring(blockId.lastIndexOf("/") + 1);
        if (blockType instanceof StoneType && (hardcoded = HardcodedBlockType.isStoneBlockAlreadyRegistered(blockName, stoneType = (StoneType)blockType, this.modId)) != null) {
            return hardcoded;
        }
        boolean isAlreadyRegistered = super.isEntryAlreadyRegistered(blockId, blockType, registry);
        if (isAlreadyRegistered) {
            return isAlreadyRegistered;
        }
        return false;
    }

    public void registerItems(Registrator<Item> registry) {
        super.registerItems(registry);
    }

    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept((resourceManager, resourceSink) -> {
            this.getEntries().forEach(entrySetParent -> {
                if (entrySetParent instanceof StoneZoneEntrySet) {
                    StoneZoneEntrySet entrySet = (StoneZoneEntrySet)((Object)((Object)entrySetParent));
                    entrySet.generateModels(this, resourceManager, resourceSink);
                }
            });
            Map<ResourceLocation, JsonObject> models = ModelUtils.readAllModelsAndParents(resourceManager, this.modelsToModify.keySet());
            for (Map.Entry<ResourceLocation, JsonObject> e : models.entrySet()) {
                JsonObject json = e.getValue();
                ResourceLocation oldRes = e.getKey();
                TintConfiguration tintConfig = this.modelsToModify.getOrDefault(oldRes, TintConfiguration.EMPTY);
                ModelUtils.addTintIndexToModelAndReplaceParent(oldRes, json, null, null, tintConfig);
                ResourceLocation newRes = ModelUtils.transformModelID(e.getKey());
                resourceSink.addJson(newRes, (JsonElement)json, ResType.MODELS);
            }
        });
    }

    public void markModelForModification(ResourceLocation oldRes, TintConfiguration config) {
        this.modelsToModify.put(oldRes, config);
    }
}

