/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.stone_zone.SZRegistry;
import net.mehvahdjukaar.stone_zone.api.intergration.CompatStoneType;
import net.mehvahdjukaar.stone_zone.api.set.MudTypeRegistry;
import net.mehvahdjukaar.stone_zone.api.set.StoneTypeRegistry;
import net.mehvahdjukaar.stone_zone.configs.SZConfigs;
import net.mehvahdjukaar.stone_zone.misc.ModelUtils;
import net.mehvahdjukaar.stone_zone.misc.SpriteHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StoneZone
extends EveryCompat {
    public static final String MOD_ID = "stonezone";
    public static final Logger LOGGER = LogManager.getLogger((String)"Stone Zone");

    public static void init() {
        SZConfigs.init();
        SZRegistry.init();
        SpriteHelper.initHardcodedSprite();
        BlockSetAPI.registerBlockSetDefinition((BlockTypeRegistry)StoneTypeRegistry.INSTANCE);
        BlockSetAPI.registerBlockSetDefinition((BlockTypeRegistry)MudTypeRegistry.INSTANCE);
        CompatStoneType.init();
        PlatHelper.addCommonSetup(SpriteHelper::addHardcodedModel);
        if (PlatHelper.getPhysicalSide().isClient()) {
            ClientHelper.addClientReloadListener(() -> (preparationBarrier, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor) -> ((CompletableFuture)CompletableFuture.completedFuture(null).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).m_6769_(arg_0))).thenAcceptAsync(object -> ModelUtils.reset(), gameExecutor), (ResourceLocation)StoneZone.res("stonezone_reloader"));
        }
        StoneZone.addModToDynamicPack("caverns_and_chasms");
        StoneZone.addModToDynamicPack("architects_palette");
        StoneZone.addModToDynamicPack("tconstruct");
    }

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static void addModToDynamicPack(String modId) {
        if (PlatHelper.isModLoaded((String)modId)) {
            ((DynamicDataPack)ServerDynamicResourcesHandler.INSTANCE.dynamicPack).addNamespaces(new String[]{modId});
        }
    }

    @SafeVarargs
    public static void addMultipleIfLoaded(String modId, Supplier<Function<String, CompatModule>> ... moduleFactories) {
        if (PlatHelper.isModLoaded((String)modId)) {
            for (Supplier<Function<String, CompatModule>> moduleFactory : moduleFactories) {
                CompatModule module = moduleFactory.get().apply(modId);
                StoneZone.addModule((CompatModule)module);
            }
        }
    }
}

