/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Arrays;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.GenericProjectileBehavior;
import net.mehvahdjukaar.supplementaries.common.utils.fake_level.IEntityInterceptFakeLevel;
import net.mehvahdjukaar.supplementaries.common.utils.forge.VibeCheckerImpl;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class VibeChecker {
    private static boolean checkedOnce = false;
    private static StackTraceElement[] stackTraceElements;

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void checkVibe() {
        VibeCheckerImpl.checkVibe();
    }

    public static void checkVibe(ServerPlayer player) {
        if (checkedOnce) {
            return;
        }
        checkedOnce = true;
        Level level = player.m_9236_();
        VibeChecker.testCannonStuff(player);
        if (PlatHelper.getPhysicalSide().isClient()) {
            VibeChecker.clientStuff();
        }
    }

    private static void testCannonStuff(ServerPlayer pl) {
        if (!CommonConfigs.General.SANITY_CHECKS_MESSAGES.get().booleanValue()) {
            return;
        }
        try {
            Level level = pl.m_9236_();
            GenericProjectileBehavior b = new GenericProjectileBehavior();
            Object pt = IEntityInterceptFakeLevel.get(level);
            b.createEntity(Items.f_42415_.m_7968_(), (IEntityInterceptFakeLevel)pt, new Vec3(0.0, 1.0, 0.0));
        }
        catch (Exception e) {
            pl.m_213846_((Component)Component.m_237113_((String)"Supplementaries detected a possible crash caused by another mod. Check the logs.").m_130940_(ChatFormatting.DARK_RED));
            Supplementaries.LOGGER.error("An error caused by other mods has occurred. Supplementaries might not work as intended. Check the log to find the culprit mod and report there.", (Throwable)e);
        }
    }

    private static void clientStuff() {
        for (ResourceKey v : BuiltInRegistries.f_256878_.m_214010_()) {
            if (Sheets.f_173376_.containsKey(v)) continue;
            ArrayList a = new ArrayList(BuiltInRegistries.f_256878_.m_214010_());
            a.removeAll(Sheets.f_173376_.keySet());
            throw new BadModError("Some OTHER mod loaded the Sheets class to early, causing modded banner patterns and sherds textures to not include modded ones.\nRefusing to proceed further.\nMissing entries: " + String.valueOf(a) + " (mods listed here are NOT the cause of this, merely the ones that got broken because of it)\nCheck previous forge log lines to find the offending mod. " + Arrays.toString(stackTraceElements));
        }
        for (ResourceKey v : BuiltInRegistries.f_271353_.m_214010_()) {
            if (Sheets.f_271486_.containsKey(v)) continue;
            ArrayList a = new ArrayList(BuiltInRegistries.f_271353_.m_214010_());
            a.removeAll(Sheets.f_271486_.keySet());
            throw new BadModError("Some OTHER mod loaded the Sheets class to early, causing modded banner patterns and sherds textures to not include modded ones.\nRefusing to proceed further.\nMissing entries: " + String.valueOf(a) + " (mods listed here are NOT the cause of this, merely the ones that got broken because of it)\nCheck previous forge log lines to find the offending mod. " + Arrays.toString(stackTraceElements));
        }
    }

    private static void crashWhenStolenMod() {
        String s = "creaturesfromthesnow";
        if (PlatHelper.isModLoaded((String)s)) {
            Supplementaries.LOGGER.error("[!!!] The mod {} contains stolen assets and code from Frozen Up which is ARR.", (Object)s);
        }
    }

    public static void setSusStackTrace(StackTraceElement[] s) {
        stackTraceElements = s;
    }

    public static class BadModError
    extends Error {
        public BadModError(String s) {
            super(s);
        }

        public BadModError(String s, Exception e) {
            super(s, e);
        }
    }
}

