/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.world.item;

import galena.nirvana.NirvanaConstants;
import galena.nirvana.index.NirvanaSounds;
import galena.nirvana.platform.Services;
import galena.nirvana.world.item.SmokingItem;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PotionBongItem
extends SmokingItem {
    public static final String PATTERN_TRANSLATION_KEY = "nirvana.pattern.potion";

    private static MobEffectInstance modify(MobEffectInstance instance) {
        return new MobEffectInstance(instance.m_19544_(), instance.m_19557_() / Services.CONFIG.common().getBongHits(), instance.m_19564_(), instance.m_19571_(), instance.m_19572_(), instance.m_19575_(), null, instance.m_216895_());
    }

    public PotionBongItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    Stream<MobEffectInstance> getEffects(ItemStack stack, @Nullable Level level, @Nullable LivingEntity entity) {
        return PotionUtils.m_43547_((ItemStack)stack).stream().map(PotionBongItem::modify);
    }

    @Override
    double getRadius(ItemStack stack, @Nullable Level level, @Nullable LivingEntity entity) {
        return Services.CONFIG.common().bongRadius();
    }

    public Component m_7626_(ItemStack stack) {
        if (!Services.CONFIG.common().generateBongTranslations()) {
            return super.m_7626_(stack);
        }
        Language language = Language.m_128107_();
        if (language.m_6722_(PATTERN_TRANSLATION_KEY)) {
            try {
                Potion potion = PotionUtils.m_43579_((ItemStack)stack);
                Pattern pattern = Pattern.compile(language.m_6834_(PATTERN_TRANSLATION_KEY));
                String potionTranslation = language.m_6834_(potion.m_43492_(Items.f_42589_.m_5524_() + ".effect."));
                Matcher matcher = pattern.matcher(potionTranslation);
                if (matcher.find()) {
                    String translation = matcher.group(1);
                    return Component.m_237110_((String)this.m_5524_(), (Object[])new Object[]{translation});
                }
            }
            catch (IllegalStateException | IndexOutOfBoundsException | PatternSyntaxException ex) {
                NirvanaConstants.LOGGER.debug("Unable to translation potion bong automatically", (Throwable)ex);
            }
        }
        return super.m_7626_(stack);
    }

    public String m_5671_(ItemStack stack) {
        return PotionUtils.m_43579_((ItemStack)stack).m_43492_(this.m_5524_() + ".effect.");
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        PotionUtils.m_43555_((ItemStack)stack, tooltip, (float)1.0f);
    }

    @Override
    @Nullable
    protected SoundEvent getUseSound() {
        return (SoundEvent)NirvanaSounds.BONG.get();
    }
}

