/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.config;

import galena.nirvana.config.NirvanaCommonConfig;
import net.minecraftforge.common.ForgeConfigSpec;

public class ForgeCommonConfig
implements NirvanaCommonConfig {
    private final ForgeConfigSpec.DoubleValue jointRadius;
    private final ForgeConfigSpec.IntValue nauseaAfterHits;
    private final ForgeConfigSpec.IntValue reeferAfterHits;
    private final ForgeConfigSpec.DoubleValue reeferChance;
    private final ForgeConfigSpec.IntValue jointPeaceSeconds;
    private final ForgeConfigSpec.DoubleValue bongRadius;
    private final ForgeConfigSpec.IntValue bongPeaceSeconds;
    private final ForgeConfigSpec.IntValue browniesPeaceSeconds;
    private final ForgeConfigSpec.IntValue herbalSalveFactor;
    private final ForgeConfigSpec.IntValue suspiciousPipeFactor;
    private final ForgeConfigSpec.BooleanValue allowFakePlayerSmoking;
    private final ForgeConfigSpec.BooleanValue generateBongTranslations;

    public ForgeCommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("nirvana");
        builder.push("smoking");
        this.nauseaAfterHits = builder.comment("number of uses after which smoking causes nausea").defineInRange("nauseaAfterHits", 3, -1, 256);
        this.reeferAfterHits = builder.comment("number of uses after which smoking causes reefers to spawn").defineInRange("reeferAfterHits", 3, -1, 256);
        this.reeferChance = builder.comment("chance of a reefer spawning").defineInRange("reeferSpawnChance", 0.5, 0.0, 1.0);
        builder.comment("Joint");
        builder.push("joint");
        this.jointRadius = builder.comment("radius around the user within entities will also get the peace effect").defineInRange("radius", 15.0, 0.0, 32.0);
        this.jointPeaceSeconds = builder.comment("number of seconds the peace effect from a joint lasts").defineInRange("peaceSeconds", 20, 1, 3600);
        builder.pop();
        builder.comment("Bong");
        builder.push("bong");
        this.bongRadius = builder.comment("radius around the user within entities will also get the effect from a bong").defineInRange("radius", 15.0, 0.0, 32.0);
        this.bongPeaceSeconds = builder.comment("number of seconds the peace effect from a normal bong lasts").defineInRange("peaceSeconds", 30, 1, 3600);
        this.generateBongTranslations = builder.comment(new String[]{"(ADVANCED) when on, translations for potion bongs are dynamically generated, allowing support for modded potions.", "If disabled, falls back to the default translations as provided in the language file (for example en_us.json)."}).define("generateTranslations", true);
        builder.pop();
        this.allowFakePlayerSmoking = builder.comment("whether fake players like dispensers or create's deployers are allowed to smoke joint & co.").define("allowFakePlayers", true);
        builder.pop();
        this.browniesPeaceSeconds = builder.comment("number of seconds the peace effect from a brownie lasts").defineInRange("brownies.peaceSeconds", 40, 1, 3600);
        this.herbalSalveFactor = builder.comment("how much longer herbal salve effects last in comparison to the suspicious soup equivalent (3 => 3x times)").defineInRange("herbal_salve.factor", 3, 1, 10);
        this.suspiciousPipeFactor = builder.comment("how much longer suspicious pipe effects last in comparison to the suspicious soup equivalent (4 => 4x times)").defineInRange("suspicious_pipe.factor", 4, 1, 10);
        builder.pop();
    }

    @Override
    public double jointRadius() {
        return (Double)this.jointRadius.get();
    }

    @Override
    public double bongRadius() {
        return (Double)this.bongRadius.get();
    }

    @Override
    public int nauseaAfterHits() {
        return (Integer)this.nauseaAfterHits.get();
    }

    @Override
    public int reeferAfterHits() {
        return (Integer)this.reeferAfterHits.get();
    }

    @Override
    public double reeferChance() {
        return (Double)this.reeferChance.get();
    }

    @Override
    public int jointPeaceSeconds() {
        return (Integer)this.jointPeaceSeconds.get();
    }

    @Override
    public int bongPeaceSeconds() {
        return (Integer)this.bongPeaceSeconds.get();
    }

    @Override
    public int browniesPeaceSeconds() {
        return (Integer)this.browniesPeaceSeconds.get();
    }

    @Override
    public int herbalSalveFactor() {
        return (Integer)this.herbalSalveFactor.get();
    }

    @Override
    public int suspiciousPipeFactor() {
        return (Integer)this.suspiciousPipeFactor.get();
    }

    @Override
    public boolean allowFakePlayerSmoking() {
        return (Boolean)this.allowFakePlayerSmoking.get();
    }

    @Override
    public boolean generateBongTranslations() {
        return (Boolean)this.generateBongTranslations.get();
    }
}

