/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.block;

import galena.oreganized.index.OTags;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public interface IMeltableBlock {
    public static final IntegerProperty GOOPYNESS_3 = IntegerProperty.m_61631_((String)"goopyness", (int)0, (int)2);
    public static final List<BlockPos> OFFSET = List.of(new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 1, 0), new BlockPos(0, -1, 0), new BlockPos(0, 0, 1), new BlockPos(0, 0, -1));

    default public IntegerProperty getGoopynessProperty() {
        return GOOPYNESS_3;
    }

    default public int getGoopyness(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getGoopynessProperty());
    }

    public static int getLightLevel(BlockState state) {
        return switch ((Integer)state.m_61143_((Property)GOOPYNESS_3)) {
            case 2 -> 6;
            case 1 -> 3;
            default -> 0;
        };
    }

    default public int getInducedGoopyness(BlockGetter world, BlockState state, BlockPos pos, BlockState selfState, BlockPos selfPos) {
        IMeltableBlock meltable;
        if (state.m_204336_(OTags.Blocks.MELTS_LEAD)) {
            return 2;
        }
        Block block = state.m_60734_();
        if (block instanceof IMeltableBlock && (meltable = (IMeltableBlock)block).getGoopyness(state) == 2) {
            return 1;
        }
        if (state.getLightEmission(world, pos) >= 15) {
            return 1;
        }
        return 0;
    }

    default public int goopynessAt(BlockGetter world, BlockState selfState, BlockPos selfPos) {
        OptionalInt touching = OFFSET.stream().map(arg_0 -> ((BlockPos)selfPos).m_121955_(arg_0)).mapToInt(pos -> this.getInducedGoopyness(world, world.m_8055_(pos), (BlockPos)pos, selfState, selfPos)).max();
        return touching.orElse(0);
    }

    default public int getNextGoopyness(BlockGetter world, BlockState selfState, BlockPos selfPos) {
        return this.goopynessAt(world, selfState, selfPos);
    }

    default public boolean onGoopynessChange(Level world, BlockState state, BlockPos pos, RandomSource random, int from, int to) {
        return true;
    }

    default public void tickMelting(BlockState state, Level world, BlockPos pos, RandomSource random) {
        int goopyness;
        int currentGoopyness = (Integer)state.m_61143_((Property)this.getGoopynessProperty());
        if (currentGoopyness != (goopyness = this.getNextGoopyness((BlockGetter)world, state, pos)) && this.onGoopynessChange(world, state, pos, random, currentGoopyness, goopyness)) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)this.getGoopynessProperty(), (Comparable)Integer.valueOf(goopyness)));
        }
        this.scheduleUpdate(world, pos, state.m_60734_());
    }

    default public void hurt(BlockState state, Level world, Entity entity) {
        LivingEntity le;
        if (this.getGoopyness(state) < 2) {
            return;
        }
        if (!entity.m_20161_() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)(le = (LivingEntity)entity))) {
            entity.m_6469_(world.m_269111_().m_269047_(), 1.0f);
        }
    }

    default public void scheduleUpdate(Level level, BlockPos pos, Block block) {
        level.m_186460_(pos, block, level.f_46441_.m_216339_(30, 60));
    }
}

