/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.block;

import galena.oreganized.content.block.IMeltableBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BulbBlock
extends Block
implements IMeltableBlock {
    public static final IntegerProperty GOOPYNESS_4 = IntegerProperty.m_61631_((String)"goopyness", (int)0, (int)3);

    public static int getLightLevel(BlockState state) {
        return switch ((Integer)state.m_61143_((Property)GOOPYNESS_4)) {
            case 0 -> 13;
            case 1 -> 8;
            case 2 -> 3;
            default -> 6;
        };
    }

    public BulbBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)GOOPYNESS_4, (Comparable)Integer.valueOf(0)));
    }

    public void m_7926_(StateDefinition.Builder<Block, BlockState> definition) {
        super.m_7926_(definition);
        definition.m_61104_(new Property[]{GOOPYNESS_4});
    }

    @Override
    public int getGoopyness(BlockState state) {
        return Math.max(0, (Integer)state.m_61143_((Property)GOOPYNESS_4) - 1);
    }

    @Override
    public IntegerProperty getGoopynessProperty() {
        return GOOPYNESS_4;
    }

    @Override
    public int getInducedGoopyness(BlockGetter world, BlockState state, BlockPos pos, BlockState selfState, BlockPos selfPos) {
        IMeltableBlock meltable;
        Block block = state.m_60734_();
        if (block instanceof IMeltableBlock && (meltable = (IMeltableBlock)block).getGoopyness(state) == 1) {
            return 1;
        }
        int defaultGoopyness = IMeltableBlock.super.getInducedGoopyness(world, state, pos, selfState, selfPos);
        if (defaultGoopyness == 0) {
            return 0;
        }
        return defaultGoopyness + 1;
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.tickMelting(state, (Level)world, pos, random);
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        this.hurt(state, world, entity);
        super.m_141947_(world, pos, state, entity);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        this.scheduleUpdate(level, pos, block);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        this.scheduleUpdate(level, pos, state.m_60734_());
    }
}

