/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.content.contraptions.enchanting.printer;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.clipboard.ClipboardBlock;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import plus.dragons.createenchantmentindustry.EnchantmentIndustry;
import plus.dragons.createenchantmentindustry.api.PrintEntryRegisterEvent;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.EnchantmentLevelUtil;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.Enchanting;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.printer.PrintEntry;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.printer.Printing;
import plus.dragons.createenchantmentindustry.dragonLibLegacy.lang.LangBuilder;
import plus.dragons.createenchantmentindustry.entry.CeiFluids;
import plus.dragons.createenchantmentindustry.foundation.config.CeiConfigs;

public class PrintEntries {
    public static Map<ResourceLocation, PrintEntry> ENTRIES = new HashMap<ResourceLocation, PrintEntry>();

    static {
        EnchantedBook e1 = new EnchantedBook();
        WrittenBook e2 = new WrittenBook();
        NameTag e3 = new NameTag();
        Schedule e4 = new Schedule();
        ClipBoard e5 = new ClipBoard();
        ENTRIES.put(e1.id(), e1);
        ENTRIES.put(e2.id(), e2);
        ENTRIES.put(e3.id(), e3);
        ENTRIES.put(e4.id(), e4);
        ENTRIES.put(e5.id(), e5);
        PrintEntryRegisterEvent event = new PrintEntryRegisterEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    static class EnchantedBook
    implements PrintEntry {
        EnchantedBook() {
        }

        @Override
        public ResourceLocation id() {
            return EnchantmentIndustry.genRL("enchanted_book");
        }

        @Override
        public boolean match(ItemStack toPrint) {
            return toPrint.m_150930_(Items.f_42690_);
        }

        @Override
        public boolean valid(ItemStack target, ItemStack tested) {
            return tested.m_150930_(Items.f_42517_);
        }

        @Override
        public int requiredInkAmount(ItemStack target) {
            return (int)((double)EnchantedBook.getExperienceFromItem(target) * (this.requiredInkType(target).m_6212_((Fluid)CeiFluids.HYPER_EXPERIENCE.get()) ? (Double)CeiConfigs.SERVER.copyEnchantedBookWithHyperExperienceCostCoefficient.get() : (Double)CeiConfigs.SERVER.copyEnchantedBookCostCoefficient.get()));
        }

        @Override
        public Fluid requiredInkType(ItemStack target) {
            return EnchantmentHelper.m_44831_((ItemStack)target).entrySet().stream().map(entry -> (Integer)entry.getValue() > EnchantmentLevelUtil.getMaxLevel((Enchantment)entry.getKey())).reduce(false, (a, b) -> a != false || b != false) != false ? (Fluid)CeiFluids.HYPER_EXPERIENCE.get() : (Fluid)CeiFluids.EXPERIENCE.get();
        }

        @Override
        public boolean isTooExpensive(ItemStack target, int limit) {
            return (int)((double)EnchantedBook.getExperienceFromItem(target) * (this.requiredInkType(target).m_6212_((Fluid)CeiFluids.HYPER_EXPERIENCE.get()) ? (Double)CeiConfigs.SERVER.copyEnchantedBookWithHyperExperienceCostCoefficient.get() : (Double)CeiConfigs.SERVER.copyEnchantedBookCostCoefficient.get())) > limit;
        }

        @Override
        public void addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking, ItemStack target) {
            LangBuilder b = EnchantmentIndustry.LANG.itemName(target).style(ChatFormatting.LIGHT_PURPLE);
            b.forGoggles(tooltip, 1);
            boolean tooExpensive = Printing.isTooExpensive(this, target, (Integer)CeiConfigs.SERVER.copierTankCapacity.get());
            if (tooExpensive) {
                tooltip.add((Component)Component.m_237113_((String)"     ").m_7220_((Component)EnchantmentIndustry.LANG.translate("gui.goggles.too_expensive", new Object[0]).component()).m_130940_(ChatFormatting.RED));
            } else {
                Boolean hyper = EnchantmentHelper.m_44831_((ItemStack)target).entrySet().stream().map(entry -> (Integer)entry.getValue() > EnchantmentLevelUtil.getMaxLevel((Enchantment)entry.getKey())).reduce(false, (a, a2) -> a != false || a2 != false);
                tooltip.add((Component)Component.m_237113_((String)"     ").m_7220_((Component)EnchantmentIndustry.LANG.translate(hyper != false ? "gui.goggles.hyper_xp_consumption" : "gui.goggles.xp_consumption", String.valueOf((int)((double)EnchantedBook.getExperienceFromItem(target) * (this.requiredInkType(target).m_6212_((Fluid)CeiFluids.HYPER_EXPERIENCE.get()) ? (Double)CeiConfigs.SERVER.copyEnchantedBookWithHyperExperienceCostCoefficient.get() : (Double)CeiConfigs.SERVER.copyEnchantedBookCostCoefficient.get())))).component()).m_130940_(hyper != false ? ChatFormatting.AQUA : ChatFormatting.GREEN));
            }
            Map map = EnchantmentHelper.m_44831_((ItemStack)target);
            for (Map.Entry e : map.entrySet()) {
                Component name = ((Enchantment)e.getKey()).m_44700_(((Integer)e.getValue()).intValue());
                tooltip.add((Component)Component.m_237113_((String)"     ").m_7220_(name).m_130948_(name.m_7383_()));
            }
        }

        @Override
        public MutableComponent getDisplaySourceContent(ItemStack target) {
            LangBuilder ret = EnchantmentIndustry.LANG.itemName(target).text(" / ");
            Map map = EnchantmentHelper.m_44831_((ItemStack)target);
            for (Map.Entry e : map.entrySet()) {
                Component name = ((Enchantment)e.getKey()).m_44700_(((Integer)e.getValue()).intValue());
                ret.add(name.m_6881_()).text(" ");
            }
            return ret.component();
        }

        public static int getExperienceFromItem(ItemStack itemStack) {
            return EnchantmentHelper.m_44831_((ItemStack)itemStack).entrySet().stream().map(entry -> Enchanting.getExperienceConsumption((Enchantment)entry.getKey(), (Integer)entry.getValue())).reduce(0, Integer::sum);
        }
    }

    static class WrittenBook
    implements PrintEntry {
        WrittenBook() {
        }

        @Override
        public ResourceLocation id() {
            return EnchantmentIndustry.genRL("written_book");
        }

        @Override
        public boolean match(ItemStack toPrint) {
            return toPrint.m_150930_(Items.f_42615_);
        }

        @Override
        public boolean valid(ItemStack target, ItemStack tested) {
            return tested.m_150930_(Items.f_42517_);
        }

        @Override
        public int requiredInkAmount(ItemStack target) {
            return WrittenBookItem.m_43477_((ItemStack)target) * (Integer)CeiConfigs.SERVER.copyWrittenBookCostPerPage.get();
        }

        @Override
        public Fluid requiredInkType(ItemStack target) {
            return (Fluid)CeiFluids.INK.get();
        }

        @Override
        public ItemStack print(ItemStack target, ItemStack material) {
            CompoundTag tag;
            int generation;
            ItemStack ret = target.m_41777_();
            if (!((Boolean)CeiConfigs.SERVER.copyingWrittenBookAlwaysGetOriginalVersion.get()).booleanValue() && (generation = (tag = ret.m_41784_()).m_128451_("generation")) <= 1) {
                tag.m_128405_("generation", generation + 1);
            }
            return ret;
        }

        @Override
        public boolean isTooExpensive(ItemStack target, int limit) {
            return WrittenBookItem.m_43477_((ItemStack)target) * (Integer)CeiConfigs.SERVER.copyWrittenBookCostPerPage.get() > limit;
        }

        @Override
        public void addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking, ItemStack target) {
            int page = WrittenBookItem.m_43477_((ItemStack)target);
            LangBuilder b = EnchantmentIndustry.LANG.builder().add(EnchantmentIndustry.LANG.itemName(target).style(ChatFormatting.BLUE)).text(ChatFormatting.GRAY, " / ").add(EnchantmentIndustry.LANG.number(page).text(" ").add(page == 1 ? EnchantmentIndustry.LANG.translate("generic.unit.page", new Object[0]) : EnchantmentIndustry.LANG.translate("generic.unit.pages", new Object[0])).style(ChatFormatting.DARK_GRAY));
            b.forGoggles(tooltip, 1);
            if (Printing.isTooExpensive(this, target, (Integer)CeiConfigs.SERVER.copierTankCapacity.get())) {
                tooltip.add((Component)Component.m_237113_((String)"     ").m_7220_((Component)EnchantmentIndustry.LANG.translate("gui.goggles.too_expensive", new Object[0]).component()).m_130940_(ChatFormatting.RED));
            } else {
                tooltip.add((Component)Component.m_237113_((String)"     ").m_7220_((Component)EnchantmentIndustry.LANG.translate("gui.goggles.ink_consumption", String.valueOf((Integer)CeiConfigs.SERVER.copyWrittenBookCostPerPage.get() * page)).component()).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }

        @Override
        public MutableComponent getDisplaySourceContent(ItemStack target) {
            int page = WrittenBookItem.m_43477_((ItemStack)target);
            return EnchantmentIndustry.LANG.builder().add(EnchantmentIndustry.LANG.itemName(target)).text(" / ").add(EnchantmentIndustry.LANG.number(page).text(" ").add(page == 1 ? EnchantmentIndustry.LANG.translate("generic.unit.page", new Object[0]) : EnchantmentIndustry.LANG.translate("generic.unit.pages", new Object[0]))).component();
        }
    }

    static class NameTag
    implements PrintEntry {
        NameTag() {
        }

        @Override
        public ResourceLocation id() {
            return EnchantmentIndustry.genRL("name_tag");
        }

        @Override
        public boolean match(ItemStack toPrint) {
            return toPrint.m_150930_(Items.f_42656_);
        }

        @Override
        public boolean valid(ItemStack target, ItemStack tested) {
            return !target.m_41786_().equals(tested.m_41786_());
        }

        @Override
        public int requiredInkAmount(ItemStack target) {
            return (Integer)CeiConfigs.SERVER.copyNameTagCost.get();
        }

        @Override
        public ItemStack print(ItemStack target, ItemStack material) {
            if (material.m_150930_(Items.f_42656_)) {
                return target.m_41777_();
            }
            material.m_41714_(target.m_41786_());
            return material;
        }

        @Override
        public boolean isTooExpensive(ItemStack target, int limit) {
            return (Integer)CeiConfigs.SERVER.copyNameTagCost.get() > limit;
        }

        @Override
        public void addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking, ItemStack target) {
            LangBuilder b = EnchantmentIndustry.LANG.builder().add(Component.m_237115_((String)target.m_41778_()).m_130940_(ChatFormatting.LIGHT_PURPLE)).text(ChatFormatting.GREEN, " / ").add(EnchantmentIndustry.LANG.itemName(target).style(ChatFormatting.GREEN));
            b.forGoggles(tooltip, 1);
            boolean tooExpensive = Printing.isTooExpensive(this, target, (Integer)CeiConfigs.SERVER.copierTankCapacity.get());
            if (tooExpensive) {
                tooltip.add((Component)Component.m_237113_((String)"     ").m_7220_((Component)EnchantmentIndustry.LANG.translate("gui.goggles.too_expensive", new Object[0]).component()).m_130940_(ChatFormatting.RED));
            } else {
                tooltip.add((Component)Component.m_237113_((String)"     ").m_7220_((Component)EnchantmentIndustry.LANG.translate("gui.goggles.xp_consumption", String.valueOf(CeiConfigs.SERVER.copyNameTagCost.get())).component()).m_130940_(ChatFormatting.GREEN));
            }
        }

        @Override
        public MutableComponent getDisplaySourceContent(ItemStack target) {
            return EnchantmentIndustry.LANG.builder().add(Component.m_237115_((String)target.m_41778_())).text(" / ").add(EnchantmentIndustry.LANG.itemName(target)).component();
        }
    }

    static class Schedule
    implements PrintEntry {
        Schedule() {
        }

        @Override
        public ResourceLocation id() {
            return EnchantmentIndustry.genRL("schedule");
        }

        @Override
        public boolean match(ItemStack toPrint) {
            return toPrint.m_150930_((Item)AllItems.SCHEDULE.get());
        }

        @Override
        public boolean valid(ItemStack target, ItemStack tested) {
            return tested.m_150930_(target.m_41720_()) && !ItemStack.m_150942_((ItemStack)target, (ItemStack)tested);
        }

        @Override
        public int requiredInkAmount(ItemStack target) {
            return (Integer)CeiConfigs.SERVER.copyTrainScheduleCost.get();
        }

        @Override
        public Fluid requiredInkType(ItemStack target) {
            return (Fluid)CeiFluids.INK.get();
        }

        @Override
        public boolean isTooExpensive(ItemStack target, int limit) {
            return (Integer)CeiConfigs.SERVER.copyTrainScheduleCost.get() > limit;
        }

        @Override
        public void addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking, ItemStack target) {
            LangBuilder b = EnchantmentIndustry.LANG.itemName(target).style(ChatFormatting.BLUE);
            b.forGoggles(tooltip, 1);
            boolean tooExpensive = Printing.isTooExpensive(this, target, (Integer)CeiConfigs.SERVER.copierTankCapacity.get());
            if (tooExpensive) {
                tooltip.add((Component)Component.m_237113_((String)"     ").m_7220_((Component)EnchantmentIndustry.LANG.translate("gui.goggles.too_expensive", new Object[0]).component()).m_130940_(ChatFormatting.RED));
            } else {
                tooltip.add((Component)Component.m_237113_((String)"     ").m_7220_((Component)EnchantmentIndustry.LANG.translate("gui.goggles.ink_consumption", String.valueOf(CeiConfigs.SERVER.copyTrainScheduleCost.get())).component()).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }

        @Override
        public MutableComponent getDisplaySourceContent(ItemStack target) {
            return EnchantmentIndustry.LANG.itemName(target).component();
        }
    }

    static class ClipBoard
    implements PrintEntry {
        ClipBoard() {
        }

        @Override
        public ResourceLocation id() {
            return EnchantmentIndustry.genRL("clipboard");
        }

        @Override
        public boolean match(ItemStack toPrint) {
            return toPrint.m_150930_(((ClipboardBlock)AllBlocks.CLIPBOARD.get()).m_5456_());
        }

        @Override
        public boolean valid(ItemStack target, ItemStack tested) {
            return tested.m_150930_(target.m_41720_()) && !ItemStack.m_150942_((ItemStack)target, (ItemStack)tested);
        }

        @Override
        public int requiredInkAmount(ItemStack target) {
            return (Integer)CeiConfigs.SERVER.copyClipboardCost.get();
        }

        @Override
        public Fluid requiredInkType(ItemStack target) {
            return (Fluid)CeiFluids.INK.get();
        }

        @Override
        public boolean isTooExpensive(ItemStack target, int limit) {
            return (Integer)CeiConfigs.SERVER.copyClipboardCost.get() > limit;
        }

        @Override
        public void addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking, ItemStack target) {
            LangBuilder b = EnchantmentIndustry.LANG.itemName(target).style(ChatFormatting.BLUE);
            b.forGoggles(tooltip, 1);
            boolean tooExpensive = Printing.isTooExpensive(this, target, (Integer)CeiConfigs.SERVER.copierTankCapacity.get());
            if (tooExpensive) {
                tooltip.add((Component)Component.m_237113_((String)"     ").m_7220_((Component)EnchantmentIndustry.LANG.translate("gui.goggles.too_expensive", new Object[0]).component()).m_130940_(ChatFormatting.RED));
            } else {
                tooltip.add((Component)Component.m_237113_((String)"     ").m_7220_((Component)EnchantmentIndustry.LANG.translate("gui.goggles.ink_consumption", String.valueOf(CeiConfigs.SERVER.copyClipboardCost.get())).component()).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }

        @Override
        public MutableComponent getDisplaySourceContent(ItemStack target) {
            return EnchantmentIndustry.LANG.itemName(target).component();
        }
    }
}

