/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class EmiBannerShieldRecipe
extends EmiPatternCraftingRecipe {
    public static final List<Item> BANNERS = List.of(Items.f_42660_, Items.f_42661_, Items.f_42662_, Items.f_42663_, Items.f_42664_, Items.f_42665_, Items.f_42666_, Items.f_42667_, Items.f_42668_, Items.f_42669_, Items.f_42670_, Items.f_42671_, Items.f_42672_, Items.f_42673_, Items.f_42727_, Items.f_42728_);
    private static final List<EmiStack> EMI_BANNERS = BANNERS.stream().map(i -> EmiStack.of((ItemLike)i)).collect(Collectors.toList());
    public static final EmiStack SHIELD = EmiStack.of((ItemLike)Items.f_42740_);

    public EmiBannerShieldRecipe(ResourceLocation id) {
        super(Stream.concat(Stream.of(SHIELD), EMI_BANNERS.stream()).toList(), EmiStack.of((ItemLike)Items.f_42740_), id);
    }

    @Override
    public SlotWidget getInputWidget(int slot, int x, int y) {
        if (slot == 0) {
            return new SlotWidget(SHIELD, x, y);
        }
        if (slot == 1) {
            return new GeneratedSlotWidget(r -> this.getPattern((Random)r, null), this.unique, x, y);
        }
        return new SlotWidget(EmiStack.EMPTY, x, y);
    }

    @Override
    public SlotWidget getOutputWidget(int x, int y) {
        return new GeneratedSlotWidget(r -> this.getPattern((Random)r, Items.f_42740_), this.unique, x, y);
    }

    public EmiStack getPattern(Random random, Item item) {
        int base = random.nextInt(BANNERS.size());
        if (item == null) {
            item = BANNERS.get(base);
        }
        ItemStack stack = new ItemStack((ItemLike)item);
        int patterns = 1 + Math.max(random.nextInt(5), random.nextInt(3));
        BannerPattern.Builder pattern = new BannerPattern.Builder();
        for (int i = 0; i < patterns; ++i) {
            pattern = EmiPort.addRandomBanner(pattern, random);
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Patterns", (Tag)pattern.m_58587_());
        if (item == Items.f_42740_) {
            tag.m_128405_("Base", ((BannerItem)BANNERS.get(base)).m_40545_().m_41060_());
        }
        BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)BlockEntityType.f_58935_, (CompoundTag)tag);
        return EmiStack.of(stack);
    }
}

