/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.blocks;

import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.common.level.blockentities.CreakingHeartBlockEntity;
import com.blackgear.vanillabackport.common.level.blocks.blockstates.CreakingHeartState;
import com.blackgear.vanillabackport.common.registries.ModBlockEntities;
import com.blackgear.vanillabackport.common.registries.ModBlockStateProperties;
import com.blackgear.vanillabackport.core.data.tags.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class CreakingHeartBlock
extends BaseEntityBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final EnumProperty<CreakingHeartState> STATE = ModBlockStateProperties.CREAKING_HEART_STATE;
    public static final BooleanProperty NATURAL = ModBlockStateProperties.NATURAL;

    public CreakingHeartBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)Direction.Axis.Y)).m_61124_(STATE, (Comparable)((Object)CreakingHeartState.UPROOTED))).m_61124_((Property)NATURAL, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CreakingHeartBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.m_5776_()) {
            return null;
        }
        return state.m_61143_(STATE) != CreakingHeartState.UPROOTED ? CreakingHeartBlock.m_152132_(blockEntityType, ModBlockEntities.CREAKING_HEART.get(), CreakingHeartBlockEntity::serverTick) : null;
    }

    public static boolean isNaturalNight(Level level) {
        if (!level.m_6042_().f_63858_()) {
            return false;
        }
        int ticks = (int)(level.m_46468_() % 24000L);
        return ticks >= 12600 && ticks <= 23400;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (CreakingHeartBlock.isNaturalNight(level) && state.m_61143_(STATE) != CreakingHeartState.UPROOTED && random.m_188503_(16) == 0 && CreakingHeartBlock.isSurroundedByLogs((LevelAccessor)level, pos)) {
            level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), ModSoundEvents.CREAKING_HEART_IDLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        level.m_186460_(pos, (Block)this, 1);
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState updatedState = CreakingHeartBlock.updateState(state, (Level)level, pos);
        if (updatedState != state) {
            level.m_7731_(pos, updatedState, 3);
        }
    }

    private static BlockState updateState(BlockState state, Level level, BlockPos pos) {
        boolean isUprooted;
        boolean hasRequiredLogs = CreakingHeartBlock.hasRequiredLogs(state, (LevelReader)level, pos);
        boolean bl = isUprooted = state.m_61143_(STATE) == CreakingHeartState.UPROOTED;
        return hasRequiredLogs && isUprooted ? (BlockState)state.m_61124_(STATE, (Comparable)((Object)(CreakingHeartBlock.isNaturalNight(level) ? CreakingHeartState.AWAKE : CreakingHeartState.DORMANT))) : state;
    }

    public static boolean hasRequiredLogs(BlockState state, LevelReader level, BlockPos pos) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        for (Direction direction : CreakingHeartBlock.directions(axis)) {
            BlockPos neighborPos = pos.m_121945_(direction);
            BlockState neighborState = level.m_8055_(neighborPos);
            if (neighborState.m_204336_(ModBlockTags.PALE_OAK_LOGS) && neighborState.m_61143_(AXIS) == axis) continue;
            return false;
        }
        return true;
    }

    private static Direction[] directions(Direction.Axis axis) {
        Direction[] directionArray;
        switch (axis) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case X: {
                Direction[] directionArray2 = new Direction[2];
                directionArray2[0] = Direction.NORTH;
                directionArray = directionArray2;
                directionArray2[1] = Direction.SOUTH;
                break;
            }
            case Y: {
                Direction[] directionArray3 = new Direction[2];
                directionArray3[0] = Direction.UP;
                directionArray = directionArray3;
                directionArray3[1] = Direction.DOWN;
                break;
            }
            case Z: {
                Direction[] directionArray4 = new Direction[2];
                directionArray4[0] = Direction.EAST;
                directionArray = directionArray4;
                directionArray4[1] = Direction.WEST;
            }
        }
        return directionArray;
    }

    private static boolean isSurroundedByLogs(LevelAccessor level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.m_121945_(direction);
            BlockState neighborState = level.m_8055_(neighborPos);
            if (neighborState.m_204336_(ModBlockTags.PALE_OAK_LOGS)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return CreakingHeartBlock.updateState((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)context.m_43719_().m_122434_()), context.m_43725_(), context.m_8083_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return RotatedPillarBlock.m_154376_((BlockState)state, (Rotation)rotation);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS, STATE, NATURAL});
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CreakingHeartBlockEntity) {
            CreakingHeartBlockEntity heart = (CreakingHeartBlockEntity)blockEntity;
            heart.removeProtector(player.m_269291_().m_269075_(player));
            this.tryAwardExperience(player, state, level, pos);
        }
        super.m_5707_(level, pos, state, player);
    }

    private void tryAwardExperience(Player player, BlockState state, Level level, BlockPos pos) {
        if (!player.m_150110_().f_35937_ && !player.m_5833_() && ((Boolean)state.m_61143_((Property)NATURAL)).booleanValue() && level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            this.m_49805_(server, pos, level.f_46441_.m_216332_(20, 24));
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        int n;
        if (state.m_61143_(STATE) == CreakingHeartState.UPROOTED) {
            return 0;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CreakingHeartBlockEntity) {
            CreakingHeartBlockEntity heart = (CreakingHeartBlockEntity)blockEntity;
            n = heart.getAnalogOutputSignal();
        } else {
            n = 0;
        }
        return n;
    }
}

