/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.helpers.compatibility;

import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.MirrorModifier;
import dev.kosmx.playerAnim.api.layered.modifier.SpeedModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationFactory;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class PlayerAnimationHelper {
    public static final ResourceLocation ANIMATION = ResourceLocation.m_214293_((String)"ntgl", (String)"animation");
    public static final ResourceLocation MIRROR_ANIMATION = ResourceLocation.m_214293_((String)"ntgl", (String)"mirror_animation");
    public static final SpeedModifier SPEED_NORMAL = new SpeedModifier(1.0f);
    public static final SpeedModifier SPEED_MIRROR = new SpeedModifier(1.0f);
    public static ModifierLayer<IAnimation> normalLayer;
    public static ModifierLayer<IAnimation> mirrorLayer;

    @OnlyIn(value=Dist.CLIENT)
    public static void playAnim(Player player, ResourceLocation name, int length, boolean mirror) {
        if (player == null) {
            return;
        }
        if (mirrorLayer == null) {
            mirrorLayer = PlayerAnimationHelper.getAnimationLayer((AbstractClientPlayer)player, MIRROR_ANIMATION);
            mirrorLayer.addModifier((AbstractModifier)SPEED_MIRROR, 0);
            mirrorLayer.addModifier((AbstractModifier)new MirrorModifier(), 1);
        }
        if (normalLayer == null) {
            normalLayer = PlayerAnimationHelper.getAnimationLayer((AbstractClientPlayer)player, ANIMATION);
            normalLayer.addModifier((AbstractModifier)SPEED_NORMAL, 0);
        }
        ModifierLayer<IAnimation> animationLayer = mirror ? mirrorLayer : normalLayer;
        SpeedModifier speedModifier = mirror ? SPEED_MIRROR : SPEED_NORMAL;
        KeyframeAnimation animation = PlayerAnimationRegistry.getAnimation((ResourceLocation)name);
        if (animationLayer != null && animation != null) {
            int duration = animation.getLength();
            speedModifier.speed = (float)duration / (float)length;
            animationLayer.setAnimation((IAnimation)new KeyframeAnimationPlayer(animation));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void stopAnim(Player player, boolean mirror) {
        if (player == null) {
            return;
        }
        ModifierLayer<IAnimation> animationLayer = PlayerAnimationHelper.getAnimationLayer((AbstractClientPlayer)player, ANIMATION);
        ModifierLayer<IAnimation> mirrorLayer = PlayerAnimationHelper.getAnimationLayer((AbstractClientPlayer)player, MIRROR_ANIMATION);
        if (animationLayer != null && mirrorLayer != null) {
            if (mirror) {
                mirrorLayer.setAnimation(null);
            } else {
                animationLayer.setAnimation(null);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private static ModifierLayer<IAnimation> getAnimationLayer(AbstractClientPlayer player, ResourceLocation resourceLocation) {
        return (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)player).get(resourceLocation);
    }

    public static void register() {
        PlayerAnimationFactory.ANIMATION_DATA_FACTORY.registerFactory(ANIMATION, 42, PlayerAnimationHelper::registerPlayerAnimation);
        PlayerAnimationFactory.ANIMATION_DATA_FACTORY.registerFactory(MIRROR_ANIMATION, 43, PlayerAnimationHelper::registerPlayerAnimation);
    }

    private static IAnimation registerPlayerAnimation(AbstractClientPlayer player) {
        return new ModifierLayer();
    }
}

