/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.network;

import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.mrcrayfish.framework.network.message.IMessage;
import com.nukateam.ntgl.Config;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.common.base.utils.ProjectileManager;
import com.nukateam.ntgl.common.base.utils.ShootTracker;
import com.nukateam.ntgl.common.base.utils.SpreadTracker;
import com.nukateam.ntgl.common.data.config.Ammo;
import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.event.GunFireEvent;
import com.nukateam.ntgl.common.event.GunReloadEvent;
import com.nukateam.ntgl.common.foundation.blockentity.WorkbenchBlockEntity;
import com.nukateam.ntgl.common.foundation.container.AttachmentContainer;
import com.nukateam.ntgl.common.foundation.container.WorkbenchContainer;
import com.nukateam.ntgl.common.foundation.crafting.WorkbenchRecipe;
import com.nukateam.ntgl.common.foundation.crafting.WorkbenchRecipes;
import com.nukateam.ntgl.common.foundation.entity.ProjectileEntity;
import com.nukateam.ntgl.common.foundation.init.ModSounds;
import com.nukateam.ntgl.common.foundation.init.ModSyncedDataKeys;
import com.nukateam.ntgl.common.foundation.item.GunItem;
import com.nukateam.ntgl.common.foundation.item.interfaces.IColored;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.C2SMessagePreFireSound;
import com.nukateam.ntgl.common.network.message.C2SMessageReload;
import com.nukateam.ntgl.common.network.message.C2SMessageShoot;
import com.nukateam.ntgl.common.network.message.S2CMessageBulletTrail;
import com.nukateam.ntgl.common.network.message.S2CMessageGunSound;
import com.nukateam.ntgl.common.network.message.S2CMessageHandAction;
import com.nukateam.ntgl.common.util.helpers.PlayerHelper;
import com.nukateam.ntgl.common.util.interfaces.IProjectileFactory;
import com.nukateam.ntgl.common.util.util.GunData;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import com.nukateam.ntgl.common.util.util.StackUtils;
import com.nukateam.ntgl.modules.enchantment.GunEnchantmentHelper;
import com.nukateam.ntgl.modules.enchantment.ModEnchantments;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class ServerPlayHandler {
    private static final Predicate<LivingEntity> HOSTILE_ENTITIES = entity -> entity.m_5720_() == SoundSource.HOSTILE && !(entity instanceof NeutralMob) && !((List)Config.COMMON.aggroMobs.exemptEntities.get()).contains(EntityType.m_20613_((EntityType)entity.m_6095_()).toString());

    /*
     * Enabled aggressive block sorting
     */
    public static void handleShoot(C2SMessageShoot message, LivingEntity shooter) {
        int level;
        Player player;
        ResourceLocation fireSound;
        GunData data;
        Gun modifiedGun;
        GunItem gunItem;
        ItemStack heldItem;
        Level world;
        block14: {
            Iterator iterator;
            double z;
            double y;
            double x;
            double radius;
            block15: {
                block13: {
                    Player player2;
                    SyncedDataKey<LivingEntity, Boolean> reloadKey;
                    if (shooter.m_5833_()) {
                        return;
                    }
                    if (shooter.m_21211_().m_41720_() == Items.f_42740_) {
                        return;
                    }
                    world = shooter.m_9236_();
                    InteractionHand hand = message.isMainHand() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                    SyncedDataKey<LivingEntity, Boolean> syncedDataKey = reloadKey = message.isMainHand() ? ModSyncedDataKeys.RELOADING_RIGHT : ModSyncedDataKeys.RELOADING_LEFT;
                    if (((Boolean)reloadKey.getValue((Entity)shooter)).booleanValue()) {
                        return;
                    }
                    heldItem = shooter.m_21120_(hand);
                    Item item = heldItem.m_41720_();
                    if (!(item instanceof GunItem)) break block13;
                    gunItem = (GunItem)item;
                    if (!Gun.hasAmmo(heldItem) && (!(shooter instanceof Player) || !(player2 = (Player)shooter).m_7500_())) break block13;
                    modifiedGun = gunItem.getModifiedGun(heldItem);
                    CompoundTag tag = heldItem.m_41784_();
                    if (modifiedGun == null) return;
                    if (MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Pre(shooter, heldItem, PlayerHelper.convertHand(hand)))) {
                        return;
                    }
                    shooter.m_146922_(Mth.m_14177_((float)message.getRotationYaw()));
                    shooter.m_146926_(Mth.m_14036_((float)message.getRotationPitch(), (float)-90.0f, (float)90.0f));
                    ShootTracker tracker = ShootTracker.getShootTracker(shooter, hand);
                    if (tracker.hasCooldown() && tracker.getRemaining() > (long)((Integer)Config.SERVER.cooldownThreshold.get()).intValue()) {
                        Ntgl.LOGGER.warn(String.valueOf(shooter.m_7755_().m_214077_()) + "(" + String.valueOf(shooter.m_20148_()) + ") tried to fire before cooldown finished or server is lagging? Remaining milliseconds: " + tracker.getRemaining());
                        return;
                    }
                    tracker.putCooldown(heldItem, shooter);
                    if (((Boolean)ModSyncedDataKeys.RELOADING_RIGHT.getValue((Entity)shooter)).booleanValue()) {
                        ModSyncedDataKeys.RELOADING_RIGHT.setValue((Entity)shooter, (Object)false);
                    }
                    if (((Boolean)ModSyncedDataKeys.RELOADING_LEFT.getValue((Entity)shooter)).booleanValue()) {
                        ModSyncedDataKeys.RELOADING_LEFT.setValue((Entity)shooter, (Object)false);
                    }
                    data = new GunData(heldItem, shooter);
                    float gunSpread = GunModifierHelper.getModifiedSpread(data);
                    if (!GunModifierHelper.isAlwaysSpread(data) && gunSpread > 0.0f) {
                        SpreadTracker.get(shooter).update(shooter, gunItem);
                    }
                    int count = GunModifierHelper.getProjectileAmount(data);
                    Ammo projectileProps = GunStateHelper.getAmmoConfig(data);
                    ProjectileEntity[] spawnedProjectiles = new ProjectileEntity[count];
                    for (int i = 0; i < count; ++i) {
                        IProjectileFactory factory = ProjectileManager.getInstance().getFactory(data);
                        ProjectileEntity projectileEntity = factory.create(world, shooter, heldItem, gunItem, modifiedGun);
                        projectileEntity.setWeapon(heldItem);
                        projectileEntity.setAdditionalDamage(Gun.getAdditionalDamage(heldItem));
                        world.m_7967_((Entity)projectileEntity);
                        spawnedProjectiles[i] = projectileEntity;
                        projectileEntity.m_8119_();
                    }
                    if (!projectileProps.isVisible()) {
                        double spawnX = shooter.m_20185_();
                        double spawnY = shooter.m_20186_() + 1.0;
                        double spawnZ = shooter.m_20189_();
                        Double radius2 = (Double)Config.COMMON.network.projectileTrackingRange.get();
                        ParticleOptions particleOptions = GunEnchantmentHelper.getParticle(heldItem);
                        S2CMessageBulletTrail messageBulletTrail = new S2CMessageBulletTrail(spawnedProjectiles, projectileProps, shooter.m_19879_(), particleOptions);
                        PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)shooter.m_9236_(), (double)spawnX, (double)spawnY, (double)spawnZ, (double)radius2), (IMessage)messageBulletTrail);
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Post(shooter, heldItem, PlayerHelper.convertHand(hand)));
                    if (!((Boolean)Config.COMMON.aggroMobs.enabled.get()).booleanValue()) break block14;
                    radius = GunModifierHelper.getModifiedFireSoundRadius(data, (Double)Config.COMMON.aggroMobs.unsilencedRange.get());
                    x = shooter.m_20185_();
                    y = shooter.m_20186_() + 0.5;
                    z = shooter.m_20189_();
                    AABB box = new AABB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
                    radius *= radius;
                    iterator = world.m_6443_(LivingEntity.class, box, HOSTILE_ENTITIES).iterator();
                    break block15;
                }
                world.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, 0.8f);
                return;
            }
            while (iterator.hasNext()) {
                double dz;
                double dy;
                LivingEntity hostile = (LivingEntity)iterator.next();
                double dx = x - hostile.m_20185_();
                if (!(dx * dx + (dy = y - hostile.m_20186_()) * dy + (dz = z - hostile.m_20189_()) * dz <= radius)) continue;
                hostile.m_6703_((Boolean)Config.COMMON.aggroMobs.angerHostileMobs.get() != false ? hostile : hostile);
            }
        }
        if ((fireSound = ServerPlayHandler.getFireSound(data, modifiedGun)) != null) {
            double posX = shooter.m_20185_();
            double posY = shooter.m_20186_() + (double)shooter.m_20192_();
            double posZ = shooter.m_20189_();
            float volume = GunModifierHelper.getFireSoundVolume(data);
            float pitch = 0.9f + world.f_46441_.m_188501_() * 0.2f;
            double radius = GunModifierHelper.getModifiedFireSoundRadius(data, (Double)Config.SERVER.gunShotMaxDistance.get());
            boolean muzzle = modifiedGun.getDisplay().getFlash() != null;
            S2CMessageGunSound messageSound = new S2CMessageGunSound(fireSound, SoundSource.PLAYERS, (float)posX, (float)posY, (float)posZ, volume, pitch, shooter.m_19879_(), muzzle, false);
            PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)shooter.m_9236_(), (double)posX, (double)posY, (double)posZ, (double)radius), (IMessage)messageSound);
        }
        if (!(shooter instanceof Player && (player = (Player)shooter).m_7500_() || Gun.isAmmoIgnored(heldItem) || (level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.RECLAIMED.get()), (ItemStack)heldItem)) != 0 && shooter.m_9236_().f_46441_.m_188503_(4 - Mth.m_14045_((int)level, (int)1, (int)2)) == 0)) {
            gunItem.getGunHandler().handleAmmoAfterShoot(data);
        }
        if (!(shooter instanceof Player)) return;
        Player player3 = (Player)shooter;
        player3.m_36246_(Stats.f_12982_.m_12902_((Object)gunItem));
    }

    public static void handlePreFireSound(C2SMessagePreFireSound message, ServerPlayer player) {
        Level world = player.m_9236_();
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem) {
            Gun modifiedGun;
            ResourceLocation fireSound;
            GunItem item2 = (GunItem)item;
            if ((Gun.hasAmmo(heldItem) || player.m_7500_()) && (fireSound = ServerPlayHandler.getPreFireSound(heldItem, modifiedGun = item2.getModifiedGun(heldItem))) != null) {
                double posX = player.m_20185_();
                double posY = player.m_20186_() + (double)player.m_20192_();
                double posZ = player.m_20189_();
                GunData data = new GunData(heldItem, (LivingEntity)player);
                float volume = GunModifierHelper.getFireSoundVolume(data);
                float pitch = 0.9f + world.f_46441_.m_188501_() * 0.2f;
                double radius = GunModifierHelper.getModifiedFireSoundRadius(data, (Double)Config.SERVER.gunShotMaxDistance.get());
                S2CMessageGunSound messageSound = new S2CMessageGunSound(fireSound, SoundSource.PLAYERS, (float)posX, (float)posY, (float)posZ, volume, pitch, player.m_19879_(), false, false);
                PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.m_9236_(), (double)posX, (double)posY, (double)posZ, (double)radius), (IMessage)messageSound);
            }
        }
    }

    private static ResourceLocation getFireSound(GunData data, Gun modifiedGun) {
        ResourceLocation fireSound = null;
        if (GunModifierHelper.isSilencedFire(data)) {
            fireSound = modifiedGun.getSounds().getSilencedFire();
        } else if (data.gun.m_41793_()) {
            fireSound = modifiedGun.getSounds().getEnchantedFire();
        }
        if (fireSound != null) {
            return fireSound;
        }
        return GunModifierHelper.getFireSound(data);
    }

    private static ResourceLocation getPreFireSound(ItemStack stack, Gun modifiedGun) {
        return modifiedGun.getSounds().getPreFire();
    }

    public static void handleCraft(ServerPlayer player, ResourceLocation id, BlockPos pos) {
        WorkbenchContainer workbench;
        Level world = player.m_9236_();
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof WorkbenchContainer && (workbench = (WorkbenchContainer)abstractContainerMenu).getPos().equals((Object)pos)) {
            WorkbenchRecipe recipe = WorkbenchRecipes.getRecipeById(world, id);
            if (recipe == null || !recipe.hasMaterials((Player)player)) {
                return;
            }
            recipe.consumeMaterials((Player)player);
            WorkbenchBlockEntity workbenchBlockEntity = workbench.getWorkbench();
            ItemStack stack = recipe.getItem();
            ItemStack dyeStack = (ItemStack)workbenchBlockEntity.getInventory().get(0);
            if (dyeStack.m_41720_() instanceof DyeItem) {
                DyeItem dyeItem = (DyeItem)dyeStack.m_41720_();
                int color = dyeItem.m_41089_().m_41071_();
                if (IColored.isDyeable(stack)) {
                    IColored colored = (IColored)stack.m_41720_();
                    colored.setColor(stack, color);
                    workbenchBlockEntity.getInventory().set(0, (Object)ItemStack.f_41583_);
                }
            }
            Containers.m_18992_((Level)world, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 1.125), (double)((double)pos.m_123343_() + 0.5), (ItemStack)stack);
        }
    }

    public static void handleUnload(ServerPlayer player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof GunItem) {
            ServerPlayHandler.unloadGun(player, stack);
        }
    }

    public static void unloadGun(ServerPlayer player, ItemStack stack) {
        GunData data = new GunData(stack, (LivingEntity)player);
        if (GunStateHelper.getAmmoConfig(data).isMagazineMode()) {
            ServerPlayHandler.unloadMagazine(player, stack);
        } else {
            ServerPlayHandler.unloadAmmo(player, stack);
        }
    }

    private static void unloadAmmo(ServerPlayer player, ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41720_() instanceof GunItem && (tag = stack.m_41783_()) != null && tag.m_128425_("AmmoCount", 3)) {
            int count = tag.m_128451_("AmmoCount");
            tag.m_128405_("AmmoCount", 0);
            GunData data = new GunData(stack, (LivingEntity)player);
            ResourceLocation id = GunStateHelper.getAmmoId(data);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
            if (item != null && !player.m_7500_()) {
                ServerPlayHandler.givePlayerAmmo(player, item, count);
            }
        }
    }

    private static void unloadMagazine(ServerPlayer player, ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41720_() instanceof GunItem && (tag = stack.m_41783_()) != null && tag.m_128425_("AmmoCount", 3)) {
            int count = tag.m_128451_("AmmoCount");
            if (count == 0) {
                return;
            }
            tag.m_128405_("AmmoCount", 0);
            GunData data = new GunData(stack, (LivingEntity)player);
            ResourceLocation id = GunStateHelper.getAmmoId(data);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
            if (item != null && !player.m_7500_()) {
                ItemStack usedMagazine = new ItemStack((ItemLike)item);
                StackUtils.setDurability(usedMagazine, count);
                ServerPlayHandler.spawnAmmo(player, usedMagazine);
            }
        }
    }

    private static void givePlayerAmmo(ServerPlayer player, Item item, int count) {
        int maxStackSize = item.m_41459_();
        int stacks = count / maxStackSize;
        for (int i = 0; i < stacks; ++i) {
            ServerPlayHandler.spawnAmmo(player, new ItemStack((ItemLike)item, maxStackSize));
        }
        int remaining = count % maxStackSize;
        if (remaining > 0) {
            ServerPlayHandler.spawnAmmo(player, new ItemStack((ItemLike)item, remaining));
        }
    }

    private static void spawnAmmo(ServerPlayer player, ItemStack stack) {
        player.m_150109_().m_36054_(stack);
        if (stack.m_41613_() > 0) {
            player.m_9236_().m_7967_((Entity)new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), stack.m_41777_()));
        }
    }

    public static void handleAttachments(ServerPlayer player) {
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() instanceof GunItem && ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem).getModules().attachmentScreen()) {
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, player1) -> new AttachmentContainer(windowId, playerInventory, heldItem), (Component)Component.m_237115_((String)"container.ntgl.attachments")));
        }
    }

    public static void handleReload(C2SMessageReload message, ServerPlayer player) {
        SyncedDataKey<LivingEntity, Boolean> dataKey = message.getHand() == InteractionHand.MAIN_HAND ? ModSyncedDataKeys.RELOADING_RIGHT : ModSyncedDataKeys.RELOADING_LEFT;
        dataKey.setValue((Entity)player, (Object)message.isReload());
        if (!message.isReload()) {
            return;
        }
        ItemStack gun = player.m_21120_(message.getHand());
        if (MinecraftForge.EVENT_BUS.post((Event)new GunReloadEvent.Pre((Player)player, gun))) {
            dataKey.setValue((Entity)player, (Object)false);
            return;
        }
        MinecraftForge.EVENT_BUS.post((Event)new GunReloadEvent.Post((Player)player, gun));
    }

    public static void handleHandAction(S2CMessageHandAction message, ServerPlayer player) {
        ItemStack stack = player.m_21120_(message.getHand());
        if (stack.m_41720_() instanceof GunItem) {
            switch (message.getHandAction()) {
                case SWITCH_FIRE_MODE: {
                    ServerPlayHandler.handleFireModeSwitch(player, stack);
                    break;
                }
                case SWITCH_AMMO: {
                    ServerPlayHandler.handleAmmoSwitch(message.getHand(), player, stack);
                }
            }
        }
    }

    public static void handleFireModeSwitch(ServerPlayer player, ItemStack stack) {
        GunData data = new GunData(stack, (LivingEntity)player);
        GunStateHelper.switchFireMode(data);
        player.m_5496_((SoundEvent)ModSounds.ITEM_PISTOL_COCK.get(), 1.0f, 1.0f);
    }

    public static void handleAmmoSwitch(InteractionHand hand, ServerPlayer player, ItemStack weapon) {
        SyncedDataKey<LivingEntity, Boolean> isReloading = ModSyncedDataKeys.getReloadKey(hand);
        GunData data = new GunData(weapon, (LivingEntity)player);
        if (!((Boolean)isReloading.getValue((Entity)player)).booleanValue() && GunModifierHelper.getAmmoItems(data).size() > 1) {
            ServerPlayHandler.handleUnload(player, hand);
            ServerPlayHandler.reloadGun(hand, player);
            GunStateHelper.switchAmmo(data);
            player.m_5496_((SoundEvent)ModSounds.ITEM_PISTOL_COCK.get(), 1.0f, 1.0f);
        }
    }

    public static void reloadGun(InteractionHand hand, ServerPlayer player) {
        ServerPlayHandler.handleReload(new C2SMessageReload(true, hand), player);
    }
}

