/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.foundation.item;

import com.nukateam.geo.interfaces.DynamicGeoItem;
import com.nukateam.geo.interfaces.IResourceProvider;
import com.nukateam.geo.render.DynamicGeoItemRenderer;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.client.animators.GunAnimator;
import com.nukateam.ntgl.client.render.renderers.gun.DefaultGunRendererGeo;
import com.nukateam.ntgl.common.base.NetworkManager;
import com.nukateam.ntgl.common.base.handlers.GunHandler;
import com.nukateam.ntgl.common.base.holders.FuelType;
import com.nukateam.ntgl.common.base.utils.FuelUtils;
import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.debug.Debug;
import com.nukateam.ntgl.common.foundation.item.IConfigConsumer;
import com.nukateam.ntgl.common.foundation.item.interfaces.IColored;
import com.nukateam.ntgl.common.foundation.item.interfaces.IMeta;
import com.nukateam.ntgl.common.util.interfaces.IConfigProvider;
import com.nukateam.ntgl.common.util.interfaces.IGunModifier;
import com.nukateam.ntgl.common.util.util.GunData;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import com.nukateam.ntgl.common.util.util.ResourceUtils;
import com.nukateam.ntgl.modules.enchantment.EnchantmentTypes;
import com.nukateam.ntgl.modules.enchantment.GunEnchantmentHelper;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mod.azure.azurelib.animatable.GeoItem;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.util.AzureLibUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;

public class GunItem
extends Item
implements DynamicGeoItem,
IColored,
IMeta,
IResourceProvider,
IConfigConsumer<Gun>,
IConfigProvider<Gun> {
    public static final String VARIANT = "variant";
    private final Lazy<String> name = Lazy.of(() -> ResourceUtils.getResourceName(this.getRegistryName()));
    private final WeakHashMap<CompoundTag, Gun> modifiedGunCache = new WeakHashMap();
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);
    private final Lazy<DefaultGunRendererGeo> GUN_RENDERER = Lazy.of(() -> new DefaultGunRendererGeo());
    private Gun gun = new Gun();
    private GunHandler gunHandler = new GunHandler();
    protected final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    protected IGunModifier[] modifiers;

    public GunItem(Item.Properties properties, IGunModifier ... modifiers) {
        super(properties);
        this.modifiers = modifiers;
    }

    @Nullable
    public IGunModifier[] getGunModifiers() {
        return this.modifiers;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public DynamicGeoItemRenderer getRenderer() {
        return (DynamicGeoItemRenderer)((Object)this.GUN_RENDERER.get());
    }

    public BiFunction<ItemDisplayContext, DynamicGeoItemRenderer<GunAnimator>, GunAnimator> getAnimatorFactory() {
        return GunAnimator::new;
    }

    @Override
    public void setConfig(NetworkManager.Supplier<Gun> supplier) {
        this.gun = supplier.getConfig();
        this.gun.onCreated(this.getName());
    }

    @Override
    public Gun getConfig() {
        return this.getGun();
    }

    @Override
    public String getName() {
        return (String)this.name.get();
    }

    @Override
    public String getNamespace() {
        return this.getRegistryName().m_135827_();
    }

    public Gun getGun() {
        return this.gun;
    }

    public GunHandler getGunHandler() {
        return this.gunHandler;
    }

    public GunItem setGunHandler(GunHandler gunHandler) {
        this.gunHandler = gunHandler;
        return this;
    }

    public static String getVariant(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128425_(VARIANT, 8)) {
            tag.m_128359_(VARIANT, "default");
        }
        return tag.m_128461_(VARIANT);
    }

    public void setDefaultTag(CompoundTag tag) {
        tag.m_128405_("AmmoCount", this.getGun().getGeneral().getMaxAmmo());
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flag) {
        GunData data = new GunData(stack, null);
        Item ammo = (Item)ForgeRegistries.ITEMS.getValue(GunStateHelper.getAmmoId(data));
        if (ammo != null) {
            tooltip.add((Component)Component.m_237110_((String)"info.ntgl.ammo_type", (Object[])new Object[]{Component.m_237115_((String)ammo.m_5524_()).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GRAY));
        }
        CompoundTag tagCompound = stack.m_41784_();
        GunItem.addAditionalDamage(tooltip, tagCompound, data);
        GunItem.addAmmo(tooltip, tagCompound, data);
        GunItem.addFuel(tooltip, tagCompound, data);
    }

    private static void addFuel(List<Component> tooltip, CompoundTag tagCompound, GunData gunData) {
        Set<FuelType> allFuel = GunModifierHelper.getFuelTypes(gunData);
        for (FuelType fuelType : allFuel) {
            int fuelAmount = FuelUtils.getFuel(gunData.gun, fuelType);
            tooltip.add((Component)Component.m_237110_((String)fuelType.getDescriptionId(), (Object[])new Object[]{ChatFormatting.WHITE.toString() + fuelAmount + "/" + GunModifierHelper.getMaxFuel(gunData, fuelType)}).m_130940_(ChatFormatting.GRAY));
        }
    }

    private static void addAmmo(List<Component> tooltip, CompoundTag tagCompound, GunData gunData) {
        if (tagCompound.m_128471_("IgnoreAmmo")) {
            tooltip.add((Component)Component.m_237115_((String)"info.ntgl.ignore_ammo").m_130940_(ChatFormatting.AQUA));
        } else {
            int ammoCount = tagCompound.m_128451_("AmmoCount");
            tooltip.add((Component)Component.m_237110_((String)"info.ntgl.projectile", (Object[])new Object[]{ChatFormatting.WHITE.toString() + ammoCount + "/" + GunEnchantmentHelper.getAmmoCapacity(gunData)}).m_130940_(ChatFormatting.GRAY));
        }
    }

    private static void addAditionalDamage(List<Component> tooltip, CompoundTag tagCompound, GunData gunData) {
        Object additionalDamageText = "";
        if (tagCompound.m_128425_("AdditionalDamage", 99)) {
            float additionalDamage = tagCompound.m_128457_("AdditionalDamage");
            if ((additionalDamage += GunModifierHelper.getAdditionalDamage(gunData)) > 0.0f) {
                additionalDamageText = String.valueOf(ChatFormatting.GREEN) + " +" + ItemStack.f_41584_.format(additionalDamage);
            } else if (additionalDamage < 0.0f) {
                additionalDamageText = String.valueOf(ChatFormatting.RED) + " " + ItemStack.f_41584_.format(additionalDamage);
            }
        }
        float damage = GunModifierHelper.getModifiedDamage(gunData);
        damage = GunEnchantmentHelper.getAcceleratorDamage(gunData.gun, damage);
        tooltip.add((Component)Component.m_237110_((String)"info.ntgl.damage", (Object[])new Object[]{String.valueOf(ChatFormatting.WHITE) + ItemStack.f_41584_.format(damage) + (String)additionalDamageText}).m_130940_(ChatFormatting.GRAY));
    }

    public Gun getModifiedGun(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound != null && tagCompound.m_128425_("Gun", 10)) {
            return this.modifiedGunCache.computeIfAbsent(tagCompound, item -> {
                if (tagCompound.m_128471_("Custom")) {
                    ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
                    return Gun.create(key, tagCompound.m_128469_("Gun"));
                }
                Gun gunCopy = this.gun.copy();
                gunCopy.deserializeNBT(tagCompound.m_128469_("Gun"));
                return gunCopy;
            });
        }
        if (Ntgl.isDebugging()) {
            return Debug.getGun(this);
        }
        return this.gun;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return this.gun.getGeneral().isEnchantable() && super.isBookEnchantable(stack, book);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (this.gun.getGeneral().isEnchantable()) {
            GunData data = new GunData(stack, null);
            if (enchantment.f_44672_ == EnchantmentTypes.SEMI_AUTO_GUN) {
                return GunModifierHelper.isAuto(data);
            }
            return super.canApplyAtEnchantingTable(stack, enchantment);
        }
        return false;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean m_8120_(ItemStack stack) {
        return this.gun.getGeneral().isEnchantable() && this.getMaxStackSize(stack) == 1;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return this.gun.getGeneral().isEnchantable() ? 5 : 0;
    }

    public int m_6473_() {
        return this.gun.getGeneral().isEnchantable() ? 5 : 0;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private ResourceLocation getRegistryName() {
        return ForgeRegistries.ITEMS.getKey((Object)this);
    }
}

