/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.config.gun;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.network.message.IMessage;
import com.nukateam.ntgl.Config;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.client.handlers.ClientHandler;
import com.nukateam.ntgl.common.base.holders.AttachmentType;
import com.nukateam.ntgl.common.base.holders.FuelType;
import com.nukateam.ntgl.common.base.holders.GripType;
import com.nukateam.ntgl.common.base.holders.LoadingType;
import com.nukateam.ntgl.common.base.utils.NbtUtils;
import com.nukateam.ntgl.common.data.attachment.IAttachment;
import com.nukateam.ntgl.common.data.attachment.impl.Scope;
import com.nukateam.ntgl.common.data.config.Ammo;
import com.nukateam.ntgl.common.data.config.Fuel;
import com.nukateam.ntgl.common.data.config.gun.Display;
import com.nukateam.ntgl.common.data.config.gun.General;
import com.nukateam.ntgl.common.data.config.gun.Modules;
import com.nukateam.ntgl.common.data.config.gun.Sounds;
import com.nukateam.ntgl.common.debug.Debug;
import com.nukateam.ntgl.common.debug.IDebugWidget;
import com.nukateam.ntgl.common.debug.IEditorMenu;
import com.nukateam.ntgl.common.debug.screen.widget.DebugButton;
import com.nukateam.ntgl.common.foundation.init.ModSounds;
import com.nukateam.ntgl.common.foundation.item.GunItem;
import com.nukateam.ntgl.common.foundation.item.attachment.ScopeItem;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.S2CMessageGunSound;
import com.nukateam.ntgl.common.util.annotation.Ignored;
import com.nukateam.ntgl.common.util.helpers.compatibility.BackpackHelper;
import com.nukateam.ntgl.common.util.helpers.context.AmmoContext;
import com.nukateam.ntgl.common.util.helpers.context.IAmmoContext;
import com.nukateam.ntgl.common.util.util.GunData;
import com.nukateam.ntgl.common.util.util.GunJsonUtil;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Gun
implements INBTSerializable<CompoundTag>,
IEditorMenu {
    public static final String ATTACHMENTS = "Attachments";
    protected General general = new General();
    protected HashMap<String, ResourceLocation> sounds = new HashMap();
    protected Display display = new Display();
    protected Modules modules = new Modules();
    protected HashMap<String, ResourceLocation> textures = new HashMap();
    @Ignored
    protected HashMap<String, ResourceLocation> preparedTextures = new HashMap();
    protected HashMap<ResourceLocation, Ammo> projectiles = new HashMap();
    protected HashMap<FuelType, Fuel> fuel = new HashMap();

    public static boolean isAmmoIgnored(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128425_("IgnoreAmmo", 1);
    }

    public static void saveAttachments(ItemStack weapon, Iterable<ItemStack> attachments) {
        CompoundTag attachmentsTag = new CompoundTag();
        for (ItemStack itemStack : attachments) {
            Item item = itemStack.m_41720_();
            if (!(item instanceof IAttachment)) continue;
            IAttachment attachment = (IAttachment)item;
            AttachmentType tagKey = attachment.getType();
            attachmentsTag.m_128365_(tagKey.toString(), (Tag)itemStack.m_41739_(new CompoundTag()));
        }
        CompoundTag tag = weapon.m_41784_();
        tag.m_128365_(ATTACHMENTS, (Tag)attachmentsTag);
    }

    public HashMap<ResourceLocation, Ammo> getProjectiles() {
        return this.projectiles;
    }

    public HashMap<FuelType, Fuel> getFuel() {
        return this.fuel;
    }

    public Fuel getFuelConfig(FuelType type) {
        return this.fuel.get(type);
    }

    public General getGeneral() {
        return this.general;
    }

    public Sounds getSounds() {
        return new Sounds(this);
    }

    public HashMap<String, ResourceLocation> getSoundsMap() {
        return this.sounds;
    }

    public Display getDisplay() {
        return this.display;
    }

    public Modules getModules() {
        return this.modules;
    }

    public Map<String, ResourceLocation> getTextures() {
        return this.preparedTextures;
    }

    @Override
    public Component getEditorLabel() {
        return Component.m_237113_((String)"Gun");
    }

    @Override
    public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ItemStack heldItem = Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_21205_();
            ItemStack scope = Gun.getScopeStack(heldItem);
            Item patt5329$temp = scope.m_41720_();
            if (patt5329$temp instanceof ScopeItem) {
                ScopeItem scopeItem = (ScopeItem)patt5329$temp;
                widgets.add(Pair.of((Object)scope.m_41720_().m_7626_(scope), () -> new DebugButton((Component)Component.m_237113_((String)"Edit"), btn -> Minecraft.m_91087_().m_91152_(ClientHandler.createEditorScreen(Debug.getScope(scopeItem))))));
            }
            widgets.add(Pair.of((Object)this.modules.getEditorLabel(), () -> new DebugButton((Component)Component.m_237113_((String)">"), btn -> Minecraft.m_91087_().m_91152_(ClientHandler.createEditorScreen(this.modules)))));
        });
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("General", (Tag)this.general.serializeNBT());
        tag.m_128365_("Sounds", (Tag)NbtUtils.serializeStringMap(this.sounds));
        tag.m_128365_("Display", (Tag)this.display.serializeNBT());
        tag.m_128365_("Modules", (Tag)this.modules.serializeNBT());
        tag.m_128365_("Textures", (Tag)NbtUtils.serializeStringMap(this.textures));
        tag.m_128365_("Projectiles", (Tag)NbtUtils.serializeMap(this.projectiles));
        tag.m_128365_("SecondaryAmmo", (Tag)NbtUtils.serializeMap(this.fuel));
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("General", 10)) {
            this.general.deserializeNBT(tag.m_128469_("General"));
        }
        if (tag.m_128425_("Sounds", 10)) {
            this.sounds = this.deserializeSounds(tag.m_128469_("Sounds"));
        }
        if (tag.m_128425_("Display", 10)) {
            this.display.deserializeNBT(tag.m_128469_("Display"));
        }
        if (tag.m_128425_("Modules", 10)) {
            this.modules.deserializeNBT(tag.m_128469_("Modules"));
        }
        if (tag.m_128425_("Textures", 10)) {
            this.textures = NbtUtils.deserializeRLMap(tag.m_128469_("Textures"));
        }
        if (tag.m_128425_("Projectiles", 10)) {
            this.projectiles = NbtUtils.deserializeProjectileMap(tag.m_128469_("Projectiles"));
        }
        if (tag.m_128425_("SecondaryAmmo", 10)) {
            this.fuel = NbtUtils.deserializeFuelMap(tag.m_128469_("SecondaryAmmo"));
        }
    }

    public JsonObject toJsonObject() {
        Gson gson = new Gson();
        JsonObject object = new JsonObject();
        object.add("general", (JsonElement)this.general.toJsonObject());
        GunJsonUtil.addObjectIfNotEmpty(object, "sounds", gson.toJsonTree((Object)this).getAsJsonObject());
        GunJsonUtil.addObjectIfNotEmpty(object, "display", this.display.toJsonObject());
        GunJsonUtil.addObjectIfNotEmpty(object, "modules", this.modules.toJsonObject());
        return object;
    }

    private HashMap<String, ResourceLocation> deserializeSounds(CompoundTag tag) {
        HashMap<String, ResourceLocation> result = new HashMap<String, ResourceLocation>();
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 8)) continue;
            result.put(key, this.createSound(tag, key));
        }
        return result;
    }

    private ResourceLocation createSound(CompoundTag tag, String key) {
        String sound = tag.m_128461_(key);
        return sound.isEmpty() ? null : new ResourceLocation(sound);
    }

    public static Gun create(ResourceLocation id, CompoundTag tag) {
        Gun gun = new Gun();
        gun.deserializeNBT(tag);
        Gun.prepareTextures(id.m_135815_(), gun);
        return gun;
    }

    public void onCreated(String id) {
        Gun.prepareTextures(id, this);
    }

    private static void prepareTextures(String itemId, Gun gun) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            CompletableFuture.runAsync(() -> gun.textures.forEach((variant, path) -> {
                ResourceLocation texture = Gun.getTexture(itemId, path);
                gun.preparedTextures.put((String)variant, texture);
            }));
        }
    }

    @NotNull
    private static ResourceLocation getTexture(String itemId, ResourceLocation path) {
        return new ResourceLocation(path.m_135827_(), "textures/guns/" + itemId + "/" + path.m_135815_() + ".png");
    }

    public Gun copy() {
        Gun gun = new Gun();
        gun.general = this.general.copy();
        gun.sounds = (HashMap)this.sounds.clone();
        gun.textures = (HashMap)this.textures.clone();
        gun.projectiles = (HashMap)this.projectiles.clone();
        gun.fuel = (HashMap)this.fuel.clone();
        gun.display = this.display.copy();
        gun.modules = this.modules.copy();
        return gun;
    }

    public boolean canAttachType(@javax.annotation.Nullable AttachmentType type, Gun gun) {
        Map<AttachmentType, ArrayList<Modules.Attachment>> attachments = gun.getModules().getAttachments();
        if (attachments == null) {
            return false;
        }
        return attachments.containsKey(type);
    }

    public boolean canAimDownSight() {
        return this.modules.zoom != null;
    }

    public static boolean hasScopeOverlay(ItemStack gun) {
        ScopeItem scope = Gun.getScopeItem(gun);
        return scope != null && ((Scope)scope.getProperties()).hasOverlay();
    }

    @Nullable
    public static ScopeItem getScopeItem(ItemStack gun) {
        ItemStack attachment = Gun.getAttachmentItem(AttachmentType.SCOPE, gun);
        if (!attachment.m_41619_()) {
            return (ScopeItem)attachment.m_41720_();
        }
        return null;
    }

    @Deprecated
    public static boolean hasAttachmentEquipped(ItemStack stack, Gun gun, AttachmentType type) {
        return Gun.hasAttachmentEquipped(stack, type);
    }

    public static boolean hasAttachmentEquipped(ItemStack stack, AttachmentType type) {
        Gun gun = GunModifierHelper.getGun(stack);
        if (!gun.canAttachType(type, gun)) {
            return false;
        }
        CompoundTag compound = stack.m_41783_();
        if (compound != null && compound.m_128425_(ATTACHMENTS, 10)) {
            CompoundTag attachment = compound.m_128469_(ATTACHMENTS);
            return attachment.m_128425_(type.toString(), 10);
        }
        return false;
    }

    public static ItemStack getScopeStack(ItemStack gun) {
        return Gun.getAttachmentItem(AttachmentType.SCOPE, gun);
    }

    @javax.annotation.Nullable
    public static Scope getScope(ItemStack gun) {
        ItemStack scopeStack = Gun.getScopeStack(gun);
        Item item = scopeStack.m_41720_();
        if (item instanceof ScopeItem) {
            ScopeItem scopeItem = (ScopeItem)item;
            if (Ntgl.isDebugging()) {
                return Debug.getScope(scopeItem);
            }
            return (Scope)scopeItem.getProperties();
        }
        return null;
    }

    public ArrayList<Modules.Attachment> getAttachments(ArrayList<ItemStack> itemStacks) {
        ArrayList<Modules.Attachment> result = new ArrayList<Modules.Attachment>();
        for (ItemStack stack : itemStacks) {
            Item item = stack.m_41720_();
            Modules.Attachment attachment = this.findAttachment(item);
            if (attachment == null) continue;
            result.add(attachment);
        }
        return result;
    }

    public Modules.Attachment findAttachment(Item item) {
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)item);
        if (item instanceof IAttachment) {
            IAttachment attachmentItem = (IAttachment)item;
            AttachmentType attachmentType = attachmentItem.getType();
            if (!this.getModules().getAttachments().containsKey(attachmentType)) {
                return null;
            }
            ArrayList<Modules.Attachment> attachments = this.getModules().getAttachments().get(attachmentType);
            for (Modules.Attachment attachment : attachments) {
                if (attachment.getItemId() == null || !attachment.getItemId().equals((Object)itemId)) continue;
                return attachment;
            }
        }
        return null;
    }

    public static ArrayList<ItemStack> getAttachmentItems(ItemStack gun) {
        CompoundTag compound = gun.m_41783_();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (compound != null && compound.m_128425_(ATTACHMENTS, 10)) {
            CompoundTag attachment = compound.m_128469_(ATTACHMENTS);
            for (String slot : attachment.m_128431_()) {
                if (!attachment.m_128425_(slot, 10)) continue;
                result.add(ItemStack.m_41712_((CompoundTag)attachment.m_128469_(slot)));
            }
        }
        return result;
    }

    public static ItemStack getAttachmentItem(AttachmentType type, ItemStack gun) {
        CompoundTag attachment;
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_(ATTACHMENTS, 10) && (attachment = compound.m_128469_(ATTACHMENTS)).m_128425_(type.toString(), 10)) {
            return ItemStack.m_41712_((CompoundTag)attachment.m_128469_(type.toString()));
        }
        return ItemStack.f_41583_;
    }

    public static float getAdditionalDamage(ItemStack gunStack) {
        CompoundTag tag = gunStack.m_41784_();
        return tag.m_128457_("AdditionalDamage");
    }

    public static boolean hasNoAmmo(LivingEntity player, ItemStack weapon) {
        return Gun.findAmmo(player, weapon).stack().m_41619_();
    }

    public static IAmmoContext findAmmo(LivingEntity entity, ItemStack weapon) {
        GunData data = new GunData(weapon, entity);
        ResourceLocation id = GunStateHelper.getAmmoId(data);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            IAmmoContext context = Gun.findPlayerAmmo(player, id);
            if (context == AmmoContext.NONE) {
                Set<ResourceLocation> set = GunModifierHelper.getAmmoItems(data);
                for (ResourceLocation value : set) {
                    if (value.equals((Object)id) || Gun.getAmmo(weapon) != 0 || (context = Gun.findPlayerAmmo(player, id = value)) == AmmoContext.NONE) continue;
                    GunStateHelper.setCurrentAmmo(data, id);
                    return context;
                }
            }
            return context;
        }
        return Gun.getCreativeAmmoContext(id);
    }

    public static IAmmoContext findMagazine(LivingEntity entity, ItemStack weapon) {
        GunData data = new GunData(weapon, entity);
        ResourceLocation id = GunStateHelper.getAmmoId(data);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            IAmmoContext context = Gun.findPlayerMagazine(player, id);
            if (context == AmmoContext.NONE) {
                Set<ResourceLocation> set = GunModifierHelper.getAmmoItems(data);
                for (ResourceLocation value : set) {
                    if (value.equals((Object)id) || Gun.getAmmo(weapon) != 0 || (context = Gun.findPlayerMagazine(player, id = value)) == AmmoContext.NONE) continue;
                    GunStateHelper.setCurrentAmmo(data, id);
                    return context;
                }
            }
            return context;
        }
        return Gun.getCreativeAmmoContext(id);
    }

    public static IAmmoContext findPlayerAmmo(Player player, ResourceLocation id) {
        if (player.m_7500_()) {
            return Gun.getCreativeAmmoContext(id);
        }
        AmmoContext context = Gun.findAmmo((Container)player.m_150109_(), id);
        if (!context.equals(AmmoContext.NONE)) {
            return context;
        }
        return BackpackHelper.findAmmo(player, id);
    }

    public static AmmoContext findAmmo(Container inventory, ResourceLocation id) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!Gun.isAmmo(stack, id)) continue;
            return new AmmoContext(stack, inventory);
        }
        return AmmoContext.NONE;
    }

    public static IAmmoContext findPlayerMagazine(Player player, ResourceLocation id) {
        if (player.m_7500_()) {
            return Gun.getCreativeAmmoContext(id);
        }
        AmmoContext context = Gun.findMagazine((Container)player.m_150109_(), id);
        if (!context.equals(AmmoContext.NONE)) {
            return context;
        }
        return BackpackHelper.findMagazine(player, id);
    }

    public static AmmoContext findMagazine(Container inventory, ResourceLocation id) {
        ItemStack ammoStack = null;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack foundStack = inventory.m_8020_(i);
            if (!Gun.isAmmo(foundStack, id)) continue;
            if (foundStack.m_41773_() == 0) {
                return new AmmoContext(foundStack, inventory);
            }
            if (ammoStack != null && !Gun.hasMoreAmmo(ammoStack, foundStack)) continue;
            ammoStack = foundStack;
        }
        if (ammoStack != null) {
            return new AmmoContext(ammoStack, inventory);
        }
        return AmmoContext.NONE;
    }

    private static ResourceLocation getKey(ItemStack stack) {
        return ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
    }

    private static boolean hasMoreAmmo(ItemStack first, ItemStack second) {
        return second.m_41773_() < first.m_41773_() && first.m_41773_() < first.m_41776_();
    }

    public void playCockSound(LivingEntity player) {
        if (!player.m_9236_().f_46443_) {
            ResourceLocation cockSound = this.getSounds().getCock();
            if (!player.m_6084_()) {
                return;
            }
            if (cockSound == null) {
                cockSound = ((SoundEvent)ModSounds.ITEM_PISTOL_COCK.get()).m_11660_();
            }
            Double radius = (Double)Config.SERVER.reloadMaxDistance.get();
            S2CMessageGunSound messageSound = new S2CMessageGunSound(cockSound, SoundSource.PLAYERS, player, 1.0f, 1.0f, false, true);
            PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.m_9236_(), (double)player.m_20185_(), (double)(player.m_20186_() + 1.0), (double)player.m_20189_(), (double)radius), (IMessage)messageSound);
        }
    }

    @NotNull
    private static AmmoContext getCreativeAmmoContext(ResourceLocation id) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
        ItemStack ammo = item != null ? new ItemStack((ItemLike)item, Integer.MAX_VALUE) : ItemStack.f_41583_;
        return new AmmoContext(ammo, null);
    }

    public static boolean isAmmo(ItemStack stack, ResourceLocation id) {
        return stack != null && Objects.equals(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()), id);
    }

    @Deprecated
    public static int getAmmo(ItemStack gunStack) {
        return GunStateHelper.getAmmoCount(gunStack);
    }

    public static boolean isMaxAmmo(GunData data) {
        int maxAmmo;
        int ammo = Gun.getAmmo(data.gun);
        return ammo == (maxAmmo = GunModifierHelper.getMaxAmmo(data));
    }

    public static void setAmmo(ItemStack gunStack, int amount) {
        CompoundTag tag = gunStack.m_41784_();
        tag.m_128405_("AmmoCount", amount);
    }

    public static boolean hasAmmo(ItemStack gunStack) {
        CompoundTag tag = gunStack.m_41784_();
        return tag.m_128471_("IgnoreAmmo") || tag.m_128451_("AmmoCount") > 0;
    }

    public static void fillAmmo(GunData data) {
        Item item = data.gun.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            CompoundTag tag = data.gun.m_41784_();
            int maxAmmo = GunModifierHelper.getMaxAmmo(data);
            tag.m_128405_("AmmoCount", maxAmmo);
        }
    }

    public static float getFovModifier(ItemStack stack, Gun modifiedGun) {
        Modules.Zoom zoom;
        Scope scope;
        float modifier = 0.0f;
        if (Gun.hasAttachmentEquipped(stack, modifiedGun, AttachmentType.SCOPE) && (scope = Gun.getScope(stack)) != null) {
            if (scope.getFovModifier() < 1.0f) {
                return Mth.m_14036_((float)scope.getFovModifier(), (float)0.01f, (float)1.0f);
            }
            modifier -= scope.getFovModifier();
        }
        return (zoom = modifiedGun.getModules().getZoom()) != null ? modifier + zoom.getFovModifier() : 0.0f;
    }

    public boolean hasAmmo(ResourceLocation ammo) {
        return this.projectiles.containsKey(ammo);
    }

    public Ammo getAmmoConfig(ResourceLocation ammo) {
        return this.projectiles.get(ammo);
    }

    public static class Builder {
        private final Gun gun;

        private Builder() {
            this.gun = new Gun();
        }

        private Builder(Gun gun) {
            this.gun = gun.copy();
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(Gun gun) {
            return new Builder(gun);
        }

        public Gun build() {
            return this.gun.copy();
        }

        public Builder addAmmo(ResourceLocation id) {
            this.gun.general.ammo.add(id);
            return this;
        }

        public Builder setFireRate(int rate) {
            this.gun.general.rate = rate;
            return this;
        }

        public Builder setGripType(GripType gripType) {
            this.gun.general.gripType = gripType;
            return this;
        }

        public Builder setReloadType(ResourceLocation reloadType) {
            this.gun.general.reloadType = reloadType;
            return this;
        }

        public Builder setMaxAmmo(int maxAmmo) {
            this.gun.general.maxAmmo = maxAmmo;
            return this;
        }

        public Builder setReloadAmount(int reloadAmount) {
            this.gun.general.reloadAmount = reloadAmount;
            return this;
        }

        public Builder setReloadTime(int reloadTime) {
            this.gun.general.reloadTime = reloadTime;
            return this;
        }

        public Builder setLoadingType(LoadingType loadingType) {
            this.gun.general.loadingType = loadingType;
            return this;
        }

        public Builder setCategory(String category) {
            this.gun.general.category = category;
            return this;
        }

        public Builder setRecoilAngle(float recoilAngle) {
            this.gun.general.recoilAngle = recoilAngle;
            return this;
        }

        public Builder setRecoilKick(float recoilKick) {
            this.gun.general.recoilKick = recoilKick;
            return this;
        }

        public Builder setRecoilDurationOffset(float recoilDurationOffset) {
            this.gun.general.recoilDurationOffset = recoilDurationOffset;
            return this;
        }

        public Builder setRecoilAdsReduction(float recoilAdsReduction) {
            this.gun.general.recoilAdsReduction = recoilAdsReduction;
            return this;
        }

        public Builder setProjectileAmount(int projectileAmount) {
            this.gun.general.projectileAmount = projectileAmount;
            return this;
        }

        public Builder setAlwaysSpread(boolean alwaysSpread) {
            this.gun.general.alwaysSpread = alwaysSpread;
            return this;
        }

        public Builder setSpread(float spread) {
            this.gun.general.spread = spread;
            return this;
        }

        @Deprecated(since="1.3.0", forRemoval=true)
        public Builder setMuzzleFlash(double size, double xOffset, double yOffset, double zOffset) {
            Display.Flash flash = new Display.Flash();
            flash.size = size;
            flash.xOffset = xOffset;
            flash.yOffset = yOffset;
            flash.zOffset = zOffset;
            this.gun.display.flash = flash;
            return this;
        }

        public Builder setZoom(float fovModifier, double xOffset, double yOffset, double zOffset) {
            Modules.Zoom zoom = new Modules.Zoom();
            zoom.fovModifier = fovModifier;
            zoom.xOffset = xOffset;
            zoom.yOffset = yOffset;
            zoom.zOffset = zOffset;
            this.gun.modules.zoom = zoom;
            return this;
        }

        @Deprecated(since="1.3.0", forRemoval=true)
        public Builder setZoom(Modules.Zoom.Builder builder) {
            this.gun.modules.zoom = builder.build();
            return this;
        }
    }
}

