/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.config;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import com.nukateam.ntgl.common.debug.IDebugWidget;
import com.nukateam.ntgl.common.debug.IEditorMenu;
import com.nukateam.ntgl.common.util.annotation.Optional;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Pair;

public class Fuel
implements INBTSerializable<CompoundTag>,
IEditorMenu {
    public static final String TYPE = "Type";
    @Optional
    private int max = 100;

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Max", this.max);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("Max", 99)) {
            this.max = tag.m_128451_("Max");
        }
    }

    public Fuel copy() {
        Fuel projectile = new Fuel();
        projectile.max = this.max;
        return projectile;
    }

    public JsonObject toJsonObject() {
        Preconditions.checkArgument((this.max > 0 ? 1 : 0) != 0, (Object)"Max capacity must be more than zero");
        JsonObject object = new JsonObject();
        object.addProperty("max", (Number)this.max);
        return object;
    }

    public int getMax() {
        return this.max;
    }

    public static Fuel create(CompoundTag tag) {
        Fuel ammo = new Fuel();
        ammo.deserializeNBT(tag);
        return ammo;
    }

    @Override
    public Component getEditorLabel() {
        return Component.m_237113_((String)"Fuel");
    }

    @Override
    public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {});
    }

    public static class Builder {
        private final Fuel ammo;

        private Builder() {
            this.ammo = new Fuel();
        }

        private Builder(Fuel ammo) {
            this.ammo = ammo.copy();
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(Fuel ammo) {
            return new Builder(ammo);
        }

        public Fuel build() {
            return this.ammo.copy();
        }

        public Builder setProjectileLife(ResourceLocation id, int life) {
            this.ammo.max = life;
            return this;
        }
    }
}

