/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.attachment.impl;

import com.nukateam.ntgl.common.data.attachment.IAttachment;
import com.nukateam.ntgl.common.util.interfaces.IGunModifier;
import com.nukateam.ntgl.common.util.util.GunData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ntgl", value={Dist.CLIENT})
public class Attachment {
    protected IGunModifier[] modifiers;
    private List<Component> perks = null;

    public Attachment(IGunModifier ... modifiers) {
        this.modifiers = modifiers;
    }

    public IGunModifier[] getModifiers() {
        return this.modifiers;
    }

    void setPerks(List<Component> perks) {
        if (this.perks == null) {
            this.perks = perks;
        }
    }

    List<Component> getPerks() {
        return this.perks;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void addInformationEvent(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        GunData data = new GunData(stack, (LivingEntity)player);
        if (stack.m_41720_() instanceof IAttachment) {
            int inputRate;
            double inputAdsSpeed;
            float inputRecoil;
            int inputLife;
            float inputSpread;
            double inputSpeed;
            float inputDamage;
            double inputRadius;
            float inputSound;
            IAttachment attachment = (IAttachment)stack.m_41720_();
            List<Component> perks = ((Attachment)attachment.getProperties()).getPerks();
            if (perks != null && perks.size() > 0) {
                event.getToolTip().add(Component.m_237115_((String)"perk.ntgl.title").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.BOLD}));
                event.getToolTip().addAll(perks);
                return;
            }
            IGunModifier[] modifiers = ((Attachment)attachment.getProperties()).getModifiers();
            ArrayList<Component> positivePerks = new ArrayList<Component>();
            ArrayList<Component> negativePerks = new ArrayList<Component>();
            float outputSound = inputSound = 1.0f;
            for (IGunModifier modifier : modifiers) {
                outputSound = modifier.modifyFireSoundVolume(outputSound, data);
            }
            if (outputSound > inputSound) {
                Attachment.addPerk(negativePerks, false, "perk.ntgl.fire_volume.negative", new Object[0]);
            } else if (outputSound < inputSound) {
                Attachment.addPerk(positivePerks, true, "perk.ntgl.fire_volume.positive", new Object[0]);
            }
            for (IGunModifier modifier : modifiers) {
                if (!modifier.silencedFire(data)) continue;
                Attachment.addPerk(positivePerks, true, "perk.ntgl.silenced.positive", new Object[0]);
                break;
            }
            double outputRadius = inputRadius = 10.0;
            for (IGunModifier modifier : modifiers) {
                outputRadius = modifier.modifyFireSoundRadius(outputRadius, data);
            }
            if (outputRadius > inputRadius) {
                Attachment.addPerk(negativePerks, false, "perk.ntgl.sound_radius.negative", new Object[0]);
            } else if (outputRadius < inputRadius) {
                Attachment.addPerk(positivePerks, true, "perk.ntgl.sound_radius.positive", new Object[0]);
            }
            float additionalDamage = 0.0f;
            for (IGunModifier modifier : modifiers) {
                additionalDamage += modifier.additionalDamage(data);
            }
            if (additionalDamage > 0.0f) {
                Attachment.addPerk(positivePerks, true, "perk.ntgl.additional_damage.positive", ItemStack.f_41584_.format((double)additionalDamage / 2.0));
            } else if (additionalDamage < 0.0f) {
                Attachment.addPerk(negativePerks, false, "perk.ntgl.additional_damage.negative", ItemStack.f_41584_.format((double)additionalDamage / 2.0));
            }
            float outputDamage = inputDamage = 10.0f;
            for (IGunModifier modifier : modifiers) {
                outputDamage = modifier.modifyDamage(outputDamage, data);
            }
            if (outputDamage > inputDamage) {
                Attachment.addPerk(positivePerks, true, "perk.ntgl.modified_damage.positive", new Object[0]);
            } else if (outputDamage < inputDamage) {
                Attachment.addPerk(negativePerks, false, "perk.ntgl.modified_damage.negative", new Object[0]);
            }
            double outputSpeed = inputSpeed = 10.0;
            for (IGunModifier modifier : modifiers) {
                outputSpeed = modifier.modifyProjectileSpeed(outputSpeed, data);
            }
            if (outputSpeed > inputSpeed) {
                Attachment.addPerk(positivePerks, true, "perk.ntgl.projectile_speed.positive", new Object[0]);
            } else if (outputSpeed < inputSpeed) {
                Attachment.addPerk(negativePerks, false, "perk.ntgl.projectile_speed.negative", new Object[0]);
            }
            float outputSpread = inputSpread = 10.0f;
            for (IGunModifier modifier : modifiers) {
                outputSpread = modifier.modifyProjectileSpread(outputSpread, data);
            }
            if (outputSpread > inputSpread) {
                Attachment.addPerk(negativePerks, false, "perk.ntgl.projectile_spread.negative", new Object[0]);
            } else if (outputSpread < inputSpread) {
                Attachment.addPerk(positivePerks, true, "perk.ntgl.projectile_spread.positive", new Object[0]);
            }
            int outputLife = inputLife = 100;
            for (IGunModifier modifier : modifiers) {
                outputLife = modifier.modifyProjectileLife(outputLife, data);
            }
            if (outputLife > inputLife) {
                Attachment.addPerk(positivePerks, true, "perk.ntgl.projectile_life.positive", new Object[0]);
            } else if (outputLife < inputLife) {
                Attachment.addPerk(negativePerks, false, "perk.ntgl.projectile_life.negative", new Object[0]);
            }
            float outputRecoil = inputRecoil = 10.0f;
            for (IGunModifier modifier : modifiers) {
                outputRecoil *= modifier.recoilModifier(data);
            }
            if (outputRecoil > inputRecoil) {
                Attachment.addPerk(negativePerks, false, "perk.ntgl.recoil.negative", new Object[0]);
            } else if (outputRecoil < inputRecoil) {
                Attachment.addPerk(positivePerks, true, "perk.ntgl.recoil.positive", new Object[0]);
            }
            double outputAdsSpeed = inputAdsSpeed = 10.0;
            for (IGunModifier modifier : modifiers) {
                outputAdsSpeed = modifier.modifyAimDownSightSpeed(outputAdsSpeed, data);
            }
            if (outputAdsSpeed > inputAdsSpeed) {
                Attachment.addPerk(positivePerks, true, "perk.ntgl.ads_speed.positive", new Object[0]);
            } else if (outputAdsSpeed < inputAdsSpeed) {
                Attachment.addPerk(negativePerks, false, "perk.ntgl.ads_speed.negative", new Object[0]);
            }
            int outputRate = inputRate = 10;
            for (IGunModifier modifier : modifiers) {
                outputRate = modifier.modifyFireRate(outputRate, data);
            }
            if (outputRate > inputRate) {
                Attachment.addPerk(negativePerks, false, "perk.ntgl.rate.negative", new Object[0]);
            } else if (outputRate < inputRate) {
                Attachment.addPerk(positivePerks, true, "perk.ntgl.rate.positive", new Object[0]);
            }
            positivePerks.addAll(negativePerks);
            ((Attachment)attachment.getProperties()).setPerks(positivePerks);
            if (positivePerks.size() > 0) {
                event.getToolTip().add(Component.m_237115_((String)"perk.ntgl.title").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.BOLD}));
                event.getToolTip().addAll(positivePerks);
            }
        }
    }

    private static void addPerk(List<Component> components, boolean positive, String id, Object ... params) {
        components.add((Component)Component.m_237110_((String)(positive ? "perk.ntgl.entry.positive" : "perk.ntgl.entry.negative"), (Object[])new Object[]{Component.m_237110_((String)id, (Object[])params).m_130940_(ChatFormatting.WHITE)}).m_130940_(positive ? ChatFormatting.DARK_AQUA : ChatFormatting.GOLD));
    }
}

